/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.util.TargetUtils;

public class EntityArrowCustom
extends EntityArrow
implements IEntityAdditionalSpawnData {
    private static final int HOMING_DATAWATCHER_INDEX = 23;
    private static final int TARGET_DATAWATCHER_INDEX = 24;
    private String shooterName = null;
    protected Block inTile;
    protected int inData;
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int ticksInGround = 0;
    protected int ticksInAir = 0;
    protected boolean inGround = false;
    private int knockbackStrength;
    private Item arrowItem = Items.arrow;

    public EntityArrowCustom(World world) {
        super(world);
    }

    public EntityArrowCustom(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowCustom(World world, EntityLivingBase shooter, float velocity) {
        super(world);
        this.renderDistanceWeight = 10.0;
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(shooter.posX, shooter.posY + (double)shooter.getEyeHeight(), shooter.posZ, shooter.rotationYaw, shooter.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, velocity * this.getVelocityFactor(), 1.0f);
    }

    public EntityArrowCustom(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setTarget(target);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(24, (Object)-1);
        this.dataWatcher.addObject(23, (Object)0);
    }

    protected boolean isHomingArrow() {
        return (this.dataWatcher.getWatchableObjectByte(23) & 1) != 0;
    }

    public void setHomingArrow(boolean isHoming) {
        this.dataWatcher.updateObject(23, (Object)((byte)(isHoming ? 1 : 0)));
    }

    public Entity getShooter() {
        if (this.shootingEntity == null && this.shooterName != null) {
            this.shootingEntity = this.worldObj.getPlayerEntityByName(this.shooterName);
        }
        return this.shootingEntity;
    }

    protected EntityLivingBase getTarget() {
        int id = this.dataWatcher.getWatchableObjectInt(24);
        return id > 0 ? (EntityLivingBase)this.worldObj.getEntityByID(id) : null;
    }

    public void setTarget(EntityLivingBase target) {
        this.dataWatcher.updateObject(24, (Object)(target != null ? target.getEntityId() : -1));
    }

    public EntityArrowCustom setArrowItem(Item item) {
        this.arrowItem = item;
        return this;
    }

    public void onUpdate() {
        super.onEntityUpdate();
        this.updateAngles();
        this.checkInGround();
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            this.updateInGround();
        } else {
            this.updateInAir();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double x, double y, double z) {
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            this.ticksInGround = 0;
        }
        super.setVelocity(x, y, z);
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && player.capabilities.isCreativeMode;
            if (this.canBePickedUp == 1 && !player.inventory.addItemStackToInventory(new ItemStack(this.arrowItem, 1, 0))) {
                flag = false;
            }
            if (flag) {
                this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.onItemPickup((Entity)this, 1);
                this.setDead();
            }
        }
    }

    protected DamageSource getDamageSource(Entity entity) {
        return new EntityDamageSourceIndirect("arrow", (Entity)this, this.shootingEntity).setProjectile();
    }

    protected boolean canTargetEntity(Entity entity) {
        return !(entity instanceof EntityEnderman);
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public void setKnockbackStrength(int value) {
        this.knockbackStrength = value;
    }

    protected void updateAngles() {
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
    }

    protected void updatePosition() {
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float motionFactor = 0.99f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
            }
            motionFactor = 0.8f;
        }
        this.updateMotion(motionFactor, this.getGravityVelocity());
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected void updateMotion(float factor, float adjustY) {
        EntityLivingBase target = this.getTarget();
        if (this.isHomingArrow() && target != null) {
            double d0 = target.posX - this.posX;
            double d1 = target.boundingBox.minY + (double)target.height - this.posY;
            double d2 = target.posZ - this.posZ;
            this.setThrowableHeading(d0, d1, d2, this.getVelocityFactor() * 2.0f, 1.0f);
        } else {
            this.motionX *= (double)factor;
            this.motionY *= (double)factor;
            this.motionZ *= (double)factor;
            this.motionY -= (double)adjustY;
        }
    }

    protected void checkInGround() {
        Block block = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
        if (block.getMaterial() != Material.air) {
            block.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = block.getCollisionBoundingBoxFromPool(this.worldObj, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
                this.inGround = true;
            }
        }
    }

    protected void updateInGround() {
        Block block = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
        int k = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
        if (block == this.inTile && k == this.inData) {
            ++this.ticksInGround;
            if (this.ticksInGround == 1200) {
                this.setDead();
            }
        } else {
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        }
    }

    protected void updateInAir() {
        ++this.ticksInAir;
        MovingObjectPosition mop = TargetUtils.checkForImpact(this.worldObj, (Entity)this, this.getShooter(), 0.3, this.ticksInAir >= 5);
        if (mop != null) {
            this.onImpact(mop);
        }
        this.spawnTrailingParticles();
        this.updatePosition();
        this.func_145775_I();
    }

    protected float getVelocityFactor() {
        return 1.5f;
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected String getParticleName() {
        return "crit";
    }

    protected boolean shouldSpawnParticles() {
        return this.getIsCritical() && this.getParticleName().length() > 0;
    }

    protected void spawnTrailingParticles() {
        if (this.shouldSpawnParticles()) {
            for (int i = 0; i < 4; ++i) {
                this.worldObj.spawnParticle(this.getParticleName(), this.posX + this.motionX * (double)i / 4.0, this.posY + this.motionY * (double)i / 4.0, this.posZ + this.motionZ * (double)i / 4.0, -this.motionX, -this.motionY + 0.2, -this.motionZ);
            }
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            this.onImpactEntity(mop);
        } else {
            this.onImpactBlock(mop);
        }
    }

    protected void onImpactEntity(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            this.shootingEntity = this.getShooter();
            float dmg = this.calculateDamage(mop.entityHit);
            if (dmg > 0.0f) {
                if (this.isBurning() && this.canTargetEntity(mop.entityHit)) {
                    mop.entityHit.setFire(5);
                }
                if (mop.entityHit.attackEntityFrom(this.getDamageSource(mop.entityHit), dmg)) {
                    if (mop.entityHit instanceof EntityLivingBase) {
                        this.handlePostDamageEffects((EntityLivingBase)mop.entityHit);
                        if (this.shootingEntity instanceof EntityPlayerMP && mop.entityHit != this.shootingEntity && mop.entityHit instanceof EntityPlayer) {
                            ((EntityPlayerMP)this.shootingEntity).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
                        }
                    }
                    this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    if (this.canTargetEntity(mop.entityHit)) {
                        this.setDead();
                    }
                } else {
                    this.motionX *= (double)-0.1f;
                    this.motionY *= (double)-0.1f;
                    this.motionZ *= (double)-0.1f;
                    this.rotationYaw += 180.0f;
                    this.prevRotationYaw += 180.0f;
                    this.ticksInAir = 0;
                }
            }
        }
    }

    protected void onImpactBlock(MovingObjectPosition mop) {
        this.xTile = mop.blockX;
        this.yTile = mop.blockY;
        this.zTile = mop.blockZ;
        this.inTile = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
        this.inData = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
        this.motionX = (float)(mop.hitVec.xCoord - this.posX);
        this.motionY = (float)(mop.hitVec.yCoord - this.posY);
        this.motionZ = (float)(mop.hitVec.zCoord - this.posZ);
        float f2 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.posX -= this.motionX / (double)f2 * (double)0.05f;
        this.posY -= this.motionY / (double)f2 * (double)0.05f;
        this.posZ -= this.motionZ / (double)f2 * (double)0.05f;
        this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.arrowShake = 7;
        this.setIsCritical(false);
        if (this.inTile.getMaterial() != Material.air) {
            this.inTile.onEntityCollidedWithBlock(this.worldObj, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    protected float calculateDamage(Entity entityHit) {
        float velocity = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        float dmg = (float)((double)velocity * this.getDamage());
        if (this.getIsCritical()) {
            dmg += (float)this.rand.nextInt(MathHelper.ceiling_double_int((double)dmg) / 2 + 2);
        }
        return dmg;
    }

    protected void handlePostDamageEffects(EntityLivingBase entityHit) {
        float f3;
        int k;
        if (!this.worldObj.isRemote) {
            entityHit.setArrowCountInEntity(entityHit.getArrowCountInEntity() + 1);
        }
        if ((k = this.getKnockbackStrength()) > 0 && (f3 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
            double knockback = (double)k * (double)0.6f / (double)f3;
            entityHit.addVelocity(this.motionX * knockback, 0.1, this.motionZ * knockback);
        }
        if (this.shootingEntity instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)entityHit, (Entity)this.shootingEntity);
            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entityHit);
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.setShort("xTile", (short)this.xTile);
        compound.setShort("yTile", (short)this.yTile);
        compound.setShort("zTile", (short)this.zTile);
        compound.setShort("life", (short)this.ticksInGround);
        compound.setInteger("inTile", Block.getIdFromBlock((Block)this.inTile));
        compound.setByte("inData", (byte)this.inData);
        compound.setByte("shake", (byte)this.arrowShake);
        compound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        compound.setByte("pickup", (byte)this.canBePickedUp);
        compound.setDouble("damage", this.getDamage());
        compound.setInteger("arrowId", Item.getIdFromItem((Item)this.arrowItem));
        if ((this.shooterName == null || this.shooterName.length() == 0) && this.shootingEntity instanceof EntityPlayer) {
            this.shooterName = this.shootingEntity.getCommandSenderName();
        }
        compound.setString("shooter", this.shooterName == null ? "" : this.shooterName);
        compound.setInteger("target", this.getTarget() == null ? -1 : this.getTarget().getEntityId());
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        this.xTile = compound.getShort("xTile");
        this.yTile = compound.getShort("yTile");
        this.zTile = compound.getShort("zTile");
        this.ticksInGround = compound.getShort("life");
        this.inTile = Block.getBlockById((int)compound.getInteger("inTile"));
        this.inData = compound.getByte("inData") & 0xFF;
        this.arrowShake = compound.getByte("shake") & 0xFF;
        this.inGround = compound.getByte("inGround") == 1;
        this.setDamage(compound.getDouble("damage"));
        this.canBePickedUp = compound.getByte("pickup");
        this.arrowItem = compound.hasKey("arrowId") ? Item.getItemById((int)compound.getInteger("arrowId")) : Items.arrow;
        this.shooterName = compound.getString("shooter");
        if (this.shooterName != null && this.shooterName.length() == 0) {
            this.shooterName = null;
        }
        this.dataWatcher.updateObject(24, (Object)(compound.hasKey("target") ? compound.getInteger("target") : -1));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.shootingEntity != null ? this.shootingEntity.getEntityId() : -1);
    }

    public void readSpawnData(ByteBuf buffer) {
        Entity shooter = this.worldObj.getEntityByID(buffer.readInt());
        if (shooter instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)shooter;
        }
    }
}

