/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.ref.Config;

public class EntityArrowBomb
extends EntityArrowCustom
implements IEntityBomb {
    private static final int BOMBTYPE_DATAWATCHER_INDEX = 25;
    private float radius = 0.0f;
    private boolean canGrief = true;

    public EntityArrowBomb(World world) {
        super(world);
    }

    public EntityArrowBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowBomb(World world, EntityLivingBase shooter, float velocity) {
        super(world, shooter, velocity);
    }

    public EntityArrowBomb(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    @Override
    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(25, (Object)BombType.BOMB_STANDARD.ordinal());
    }

    @Override
    protected DamageSource getDamageSource(Entity entity) {
        return new EntityDamageSourceIndirect("bomb arrow", (Entity)this, this.shootingEntity).setProjectile().setExplosion();
    }

    public EntityArrowBomb setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public boolean canGriefAdventureMode() {
        return Config.canGriefAdventure();
    }

    public EntityArrowBomb setNoGrief() {
        this.canGrief = false;
        return this;
    }

    @Override
    public BombType getType() {
        return BombType.values()[this.dataWatcher.getWatchableObjectInt(25)];
    }

    public EntityArrowBomb setType(BombType type) {
        this.dataWatcher.updateObject(25, (Object)type.ordinal());
        return this;
    }

    @Override
    public float getMotionFactor() {
        return 1.0f;
    }

    @Override
    public float getDestructionFactor() {
        return 1.0f;
    }

    @Override
    public boolean hasPostExplosionEffect() {
        return false;
    }

    @Override
    protected float getVelocityFactor() {
        return 1.0f;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.065f;
    }

    @Override
    protected String getParticleName() {
        return "smoke";
    }

    @Override
    protected boolean shouldSpawnParticles() {
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.provider.isHellWorld && this.ticksInAir > 0 && !this.worldObj.isRemote && (this.getType() == BombType.BOMB_STANDARD || this.getType() == BombType.BOMB_FLOWER)) {
            CustomExplosion.createExplosion(this, this.worldObj, this.posX, this.posY, this.posZ, this.radius == 0.0f ? ItemBomb.getRadius(this.getType()) : this.radius, (float)this.getDamage(), this.canGrief);
            this.setDead();
        }
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        boolean inFire;
        Material material = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)).getMaterial();
        boolean bl = inFire = this.isBurning() || material == Material.lava || material == Material.fire || this.worldObj.func_147470_e(this.boundingBox);
        if (!this.isDud(inFire)) {
            if (!this.worldObj.isRemote) {
                CustomExplosion.createExplosion(this, this.worldObj, this.posX, this.posY, this.posZ, this.radius == 0.0f ? ItemBomb.getRadius(this.getType()) : this.radius, (float)this.getDamage(), this.canGrief);
                this.setDead();
            }
        } else {
            super.onImpact(mop);
        }
    }

    private boolean isDud(boolean inFire) {
        switch (this.getType()) {
            case BOMB_WATER: {
                return inFire || this.worldObj.provider.isHellWorld;
            }
        }
        return this.worldObj.getBlock((int)this.posX, (int)this.posY, (int)this.posZ).getMaterial() == Material.water;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger("arrowType", this.getType().ordinal());
        compound.setFloat("bombRadius", this.radius);
        compound.setBoolean("canGrief", this.canGrief);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setType(BombType.values()[compound.getInteger("arrowType") % BombType.values().length]);
        this.radius = compound.getFloat("bombRadius");
        this.canGrief = compound.getBoolean("canGrief");
    }
}

