/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.QuestBase;

public class ZSSQuests
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZssPlayerQuests";
    private final Map<Class<? extends IQuest>, IQuest> quests = new HashMap<Class<? extends IQuest>, IQuest>();
    private Item borrowedMask = null;
    private final EntityPlayer player;

    public ZSSQuests(EntityPlayer player) {
        this.player = player;
    }

    public void init(Entity entity, World world) {
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSQuests(player));
    }

    public static final ZSSQuests get(EntityPlayer player) {
        return (ZSSQuests)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public Map<Class<? extends IQuest>, IQuest> getQuests() {
        return Collections.unmodifiableMap(this.quests);
    }

    public IQuest get(Class<? extends IQuest> quest) {
        return this.quests.get(quest);
    }

    public boolean add(IQuest quest) {
        if (quest == null || this.quests.containsKey(quest.getClass())) {
            return false;
        }
        this.quests.put(quest.getClass(), quest);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void update(IQuest quest) {
        this.quests.put(quest.getClass(), quest);
    }

    public boolean hasBegun(Class<? extends IQuest> quest) {
        return this.quests.containsKey(quest) && this.quests.get(quest).hasBegun(this.player);
    }

    public boolean hasCompleted(Class<? extends IQuest> quest) {
        return this.quests.containsKey(quest) && this.quests.get(quest).isComplete(this.player);
    }

    public Item getBorrowedMask() {
        Item mask = ZSSPlayerInfo.get(this.player).getBorrowedMask();
        if (mask != null) {
            this.borrowedMask = mask;
            ZSSPlayerInfo.get(this.player).setBorrowedMask(null);
        }
        return this.borrowedMask;
    }

    public void setBorrowedMask(Item item) {
        this.borrowedMask = item;
    }

    public void copy(ZSSQuests quests) {
        NBTTagCompound compound = new NBTTagCompound();
        quests.saveNBTData(compound);
        this.loadNBTData(compound);
    }

    public void saveNBTData(NBTTagCompound compound) {
        this.writeToNBT(compound, false);
    }

    public void writeToNBT(NBTTagCompound compound, boolean syncOnly) {
        String maskId;
        NBTTagList questList = new NBTTagList();
        for (IQuest quest : this.quests.values()) {
            if (syncOnly && !quest.requiresSync()) continue;
            questList.appendTag((NBTBase)QuestBase.saveToNBT(quest));
        }
        compound.setTag("ZssQuests", (NBTBase)questList);
        String string = maskId = this.borrowedMask == null ? null : GameData.getItemRegistry().getNameForObject((Object)this.borrowedMask);
        if (maskId != null) {
            compound.setString("borrowedMask", maskId);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList questList = compound.getTagList("ZssQuests", 10);
        for (int i = 0; i < questList.tagCount(); ++i) {
            NBTTagCompound tag = questList.getCompoundTagAt(i);
            IQuest quest = QuestBase.loadFromNBT(tag);
            if (quest == null || this.add(quest)) continue;
            ZSSMain.logger.warn("Duplicate quest entry loaded from NBT: " + quest);
        }
        if (compound.hasKey("borrowedMask", 8)) {
            this.borrowedMask = (Item)GameData.getItemRegistry().getObject(compound.getString("borrowedMask"));
        }
    }
}

