/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.world.chunk.Chunk;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.LearnSongPacket;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;
import zeldaswordskills.util.WarpPoint;
import zeldaswordskills.util.WorldUtils;

public class ZSSPlayerSongs {
    private final EntityPlayer player;
    private final Set<AbstractZeldaSong> knownSongs = new HashSet<AbstractZeldaSong>();
    private final Map<Integer, WarpPoint> warpPoints = new HashMap<Integer, WarpPoint>();
    @SideOnly(value=Side.CLIENT)
    public AbstractZeldaSong songToLearn;
    public boolean preventSongGui;
    private final List<SongNote> scarecrowNotes = new ArrayList<SongNote>();
    private long scarecrowTime;
    private long nextSongHealTime;
    private UUID horseUUID = null;
    private int horseId = -1;
    private int horseChunkX;
    private int horseChunkZ;
    private Map<Integer, Long> lonlonCows = new HashMap<Integer, Long>();
    private final Set<String> curedNpcs = new HashSet<String>();

    public ZSSPlayerSongs(EntityPlayer player) {
        this.player = player;
    }

    public static ZSSPlayerSongs get(EntityPlayer player) {
        return ZSSPlayerInfo.get(player).getPlayerSongs();
    }

    public boolean isSongKnown(AbstractZeldaSong song) {
        return this.knownSongs.contains(song);
    }

    public boolean learnSong(AbstractZeldaSong song, List<SongNote> notes) {
        boolean addSong = true;
        if (this.isSongKnown(song)) {
            return false;
        }
        if (!song.canLearn(this.player)) {
            if (!this.player.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.nolearn", new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
            }
            return false;
        }
        if (song == ZeldaSongs.songScarecrow) {
            if (notes == null || notes.size() != 8 || !ZeldaSongs.areNotesUnique(notes)) {
                ZSSMain.logger.warn("Trying to add Scarecrow's Song with invalid list: " + notes);
                return false;
            }
            if (this.scarecrowNotes.isEmpty()) {
                addSong = false;
                this.scarecrowNotes.addAll(notes);
                this.scarecrowTime = this.player.worldObj.getTotalWorldTime() + 168000L;
            } else if (this.player.worldObj.getTotalWorldTime() > this.scarecrowTime) {
                for (int i = 0; i < this.scarecrowNotes.size() && addSong; ++i) {
                    addSong = this.scarecrowNotes.get(i) == notes.get(i);
                }
            } else if (!this.player.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.later", new Object[0]);
            }
        }
        if (addSong) {
            this.knownSongs.add(song);
            this.player.triggerAchievement((StatBase)ZSSAchievements.ocarinaSong);
            if (song == ZeldaSongs.songScarecrow) {
                this.player.triggerAchievement((StatBase)ZSSAchievements.ocarinaScarecrow);
            }
            if (this.knownSongs.size() > 15) {
                this.player.triggerAchievement((StatBase)ZSSAchievements.ocarinaMaestro);
            }
            if (!this.player.worldObj.isRemote) {
                PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)this.player);
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.learned", new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
                PacketDispatcher.sendTo(new LearnSongPacket(song, notes), (EntityPlayerMP)this.player);
            }
        }
        return true;
    }

    public boolean removeSong(AbstractZeldaSong song) {
        if (this.knownSongs.contains(song)) {
            this.knownSongs.remove(song);
            if (song == ZeldaSongs.songScarecrow) {
                this.scarecrowNotes.clear();
                this.scarecrowTime = 0L;
            }
            if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new LearnSongPacket(song, true), (EntityPlayerMP)this.player);
            }
            return true;
        }
        return false;
    }

    public void resetKnownSongs() {
        this.knownSongs.clear();
        this.scarecrowNotes.clear();
        this.scarecrowTime = 0L;
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new LearnSongPacket(true), (EntityPlayerMP)this.player);
        }
    }

    public AbstractZeldaSong getKnownSongFromNotes(List<SongNote> notesPlayed) {
        for (AbstractZeldaSong song : this.knownSongs) {
            if (song == ZeldaSongs.songScarecrow) {
                if (notesPlayed == null || notesPlayed.size() != this.scarecrowNotes.size()) continue;
                for (int i = 0; i < this.scarecrowNotes.size(); ++i) {
                    if (notesPlayed.get(i) == this.scarecrowNotes.get(i)) continue;
                    return null;
                }
                return song;
            }
            if (!song.areCorrectNotes(notesPlayed)) continue;
            return song;
        }
        return null;
    }

    public void onActivatedWarpStone(int x, int y, int z, int meta) {
        if (this.warpPoints.containsKey(meta)) {
            this.warpPoints.remove(meta);
        }
        this.warpPoints.put(meta, new WarpPoint(this.player.worldObj.provider.dimensionId, x, y, z));
    }

    public WarpPoint getWarpPoint(AbstractZeldaSong song) {
        Integer meta = BlockWarpStone.reverseLookup.get(song);
        return meta == null ? null : this.warpPoints.get(meta);
    }

    public boolean canOpenScarecrowGui(boolean addChat) {
        if (this.scarecrowNotes.isEmpty()) {
            return true;
        }
        if (this.isSongKnown(ZeldaSongs.songScarecrow)) {
            if (addChat) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.known", new Object[0]);
            }
            return false;
        }
        if (this.player.worldObj.getTotalWorldTime() < this.scarecrowTime) {
            if (addChat) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.later", new Object[0]);
            }
            return false;
        }
        return true;
    }

    public boolean canHealFromSong() {
        return this.player.getHealth() < this.player.getMaxHealth() && this.player.worldObj.getTotalWorldTime() > this.nextSongHealTime;
    }

    public void setNextHealTime() {
        this.nextSongHealTime = this.player.worldObj.getTotalWorldTime() + 24000L;
    }

    public List<SongNote> getScarecrowNotes() {
        return Collections.unmodifiableList(this.scarecrowNotes);
    }

    public EntityHorse getLastHorseRidden() {
        Entity entity;
        Entity entity2 = entity = this.horseId < 0 ? null : this.player.worldObj.getEntityByID(this.horseId);
        if (entity == null && this.horseUUID != null) {
            entity = this.getHorseByUUID();
        }
        if (entity == null) {
            entity = this.getHorseFromChunk(this.horseChunkX, this.horseChunkZ);
            int n = 1;
            for (int i = -n; entity == null && i <= n; ++i) {
                for (int k = -n; entity == null && k <= n; ++k) {
                    if (i == 0 && k == 0) continue;
                    entity = this.getHorseFromChunk(this.horseChunkX + i, this.horseChunkZ + k);
                }
            }
        }
        if (entity instanceof EntityHorse && entity.isEntityAlive()) {
            return (EntityHorse)entity;
        }
        return null;
    }

    private Entity getHorseByUUID() {
        if (this.horseUUID == null) {
            return null;
        }
        Entity entity = WorldUtils.getEntityByUUID(this.player.worldObj, this.horseUUID);
        if (entity instanceof EntityHorse) {
            this.horseId = entity.getEntityId();
        }
        return entity;
    }

    private Entity getHorseFromChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.player.worldObj.getChunkFromChunkCoords(chunkX, chunkZ);
        if (chunk != null && chunk.isChunkLoaded) {
            return this.getHorseByUUID();
        }
        return null;
    }

    public void setHorseRidden(EntityHorse horse) {
        if (horse.getEntityId() == this.horseId) {
            this.setHorseCoordinates(horse);
        } else if (horse.isTame() && horse.func_152119_ch().equals(this.player.getUniqueID().toString())) {
            this.horseId = horse.getEntityId();
            this.horseUUID = horse.getPersistentID();
            this.setHorseCoordinates(horse);
        }
    }

    private void setHorseCoordinates(EntityHorse horse) {
        this.horseChunkX = MathHelper.floor_double((double)horse.posX) >> 4;
        this.horseChunkZ = MathHelper.floor_double((double)horse.posZ) >> 4;
    }

    public void addLonLonCow(EntityCow cow) {
        NBTTagCompound data = cow.getEntityData();
        if (!(cow.isChild() || data.hasKey("zss_lon_milk") && cow.worldObj.getWorldTime() <= data.getLong("zss_lon_milk"))) {
            this.lonlonCows.put(cow.getEntityId(), cow.worldObj.getWorldTime() + 6000L);
            cow.worldObj.setEntityState((Entity)cow, (byte)18);
        }
    }

    public boolean milkLonLonCow(EntityPlayer player, EntityCow cow) {
        NBTTagCompound data;
        boolean match = false;
        Iterator<Map.Entry<Integer, Long>> iterator = this.lonlonCows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Long> entry = iterator.next();
            if (cow.worldObj.getWorldTime() > entry.getValue()) {
                iterator.remove();
                continue;
            }
            if (entry.getKey().intValue() != cow.getEntityId()) continue;
            match = true;
            iterator.remove();
        }
        ItemStack stack = player.getHeldItem();
        if (!(!match || stack == null || stack.getItem() != Items.glass_bottle || cow.isChild() || (data = cow.getEntityData()).hasKey("zss_lon_milk") && cow.worldObj.getWorldTime() <= data.getLong("zss_lon_milk"))) {
            if (stack.stackSize > 1) {
                --stack.stackSize;
                PlayerUtils.addItemToInventory(player, new ItemStack(ZSSItems.lonlonMilk));
            } else {
                player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.lonlonMilk));
            }
            data.setLong("zss_lon_milk", cow.worldObj.getWorldTime() + 24000L);
            return true;
        }
        return false;
    }

    public boolean hasCuredNpc(String name) {
        return this.curedNpcs.contains(name);
    }

    public boolean onCuredNpc(String name) {
        return this.curedNpcs.add(name);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList songs = new NBTTagList();
        for (AbstractZeldaSong song : this.knownSongs) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setString("song", song.getUnlocalizedName());
            songs.appendTag((NBTBase)tag);
        }
        compound.setTag("KnownSongs", (NBTBase)songs);
        if (!this.scarecrowNotes.isEmpty()) {
            int[] notes = new int[this.scarecrowNotes.size()];
            for (int i = 0; i < this.scarecrowNotes.size(); ++i) {
                notes[i] = this.scarecrowNotes.get(i).ordinal();
            }
            compound.setIntArray("ScarecrowNotes", notes);
        }
        compound.setLong("ScarecrowTime", this.scarecrowTime);
        compound.setLong("NextSongHealTime", this.nextSongHealTime);
        if (this.horseUUID != null) {
            compound.setLong("HorseUUIDMost", this.horseUUID.getMostSignificantBits());
            compound.setLong("HorseUUIDLeast", this.horseUUID.getLeastSignificantBits());
            compound.setInteger("HorseChunkX", this.horseChunkX);
            compound.setInteger("HorseChunkZ", this.horseChunkZ);
        }
        if (!this.warpPoints.isEmpty()) {
            NBTTagList warpList = new NBTTagList();
            for (Integer i : this.warpPoints.keySet()) {
                WarpPoint warp = this.warpPoints.get(i);
                if (warp != null) {
                    NBTTagCompound warpTag = warp.writeToNBT();
                    warpTag.setInteger("WarpKey", i.intValue());
                    warpList.appendTag((NBTBase)warpTag);
                    continue;
                }
                ZSSMain.logger.warn("NULL warp point stored in map with key " + i);
            }
            compound.setTag("WarpList", (NBTBase)warpList);
        }
        if (!this.curedNpcs.isEmpty()) {
            NBTTagList npcs = new NBTTagList();
            for (String name : this.curedNpcs) {
                NBTTagCompound npc = new NBTTagCompound();
                npc.setString("NpcName", name);
                npcs.appendTag((NBTBase)npc);
            }
            compound.setTag("CuredNpcs", (NBTBase)npcs);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList songs = compound.getTagList("KnownSongs", 10);
        this.knownSongs.clear();
        for (int i = 0; i < songs.tagCount(); ++i) {
            NBTTagCompound nBTTagCompound = songs.getCompoundTagAt(i);
            AbstractZeldaSong song = ZeldaSongs.getSongByName(nBTTagCompound.getString("song"));
            if (song == null) continue;
            this.knownSongs.add(song);
        }
        if (compound.hasKey("ScarecrowNotes")) {
            try {
                int[] notes;
                for (int n : notes = compound.getIntArray("ScarecrowNotes")) {
                    this.scarecrowNotes.add(SongNote.values()[n]);
                }
            }
            catch (Exception e) {
                ZSSMain.logger.error("Exception thrown while loading Scarecrow's Song notes: " + e.getMessage());
            }
        }
        this.scarecrowTime = compound.getLong("ScarecrowTime");
        this.nextSongHealTime = compound.getLong("NextHealSongTime");
        if (compound.hasKey("HorseChunkX") && compound.hasKey("HorseChunkZ")) {
            this.horseChunkX = compound.getInteger("HorseChunkX");
            this.horseChunkZ = compound.getInteger("HorseChunkZ");
        }
        if (compound.hasKey("HorseUUIDMost") && compound.hasKey("HorseUUIDLeast")) {
            this.horseUUID = new UUID(compound.getLong("HorseUUIDMost"), compound.getLong("HorseUUIDLeast"));
        }
        if (compound.hasKey("WarpList")) {
            void var4_12;
            NBTTagList warpList = compound.getTagList("WarpList", 10);
            boolean bl = false;
            while (var4_12 < warpList.tagCount()) {
                NBTTagCompound warpTag = warpList.getCompoundTagAt((int)var4_12);
                WarpPoint warp = WarpPoint.readFromNBT(warpTag);
                this.warpPoints.put(warpTag.getInteger("WarpKey"), warp);
                ++var4_12;
            }
        }
        if (compound.hasKey("CuredNpcs")) {
            void var4_14;
            NBTTagList npcs = compound.getTagList("CuredNpcs", 10);
            boolean bl = false;
            while (var4_14 < npcs.tagCount()) {
                NBTTagCompound npc = npcs.getCompoundTagAt((int)var4_14);
                this.curedNpcs.add(npc.getString("NpcName"));
                ++var4_14;
            }
        }
    }
}

