/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.entity.npc.EntityNpcBase;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcOrca
extends EntityNpcBase
implements INpcVillager,
IParryModifier {
    private static final int MATCH_PLAYER_ID = 18;
    private static final int MATCH_INTERVAL = 3000;
    private long nextMatch;
    private int chatTimer;
    private int hitCounter;
    private boolean parryFlag;

    public EntityNpcOrca(World world) {
        super(world);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.6, true));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)0);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
    }

    public Entity getMatchOpponent() {
        return this.worldObj.getEntityByID(this.dataWatcher.getWatchableObjectInt(18));
    }

    private void setMatchOpponent(Entity entity) {
        this.dataWatcher.updateObject(18, (Object)(entity == null ? -1 : entity.getEntityId()));
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Orca";
    }

    protected String getLivingSound() {
        return "mob.villager.haggle";
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    @Override
    public boolean isEntityInvulnerable() {
        return false;
    }

    public void fall(float distance) {
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (source.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.getEntity();
            Entity opponent = this.getMatchOpponent();
            if (this.worldObj.getTotalWorldTime() < this.nextMatch) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.resting", true);
                return false;
            }
            if (opponent != null && opponent != player) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.in_match", true);
                return false;
            }
            if (source.getSourceOfDamage() != player && !source.getDamageType().equals("indirectSword") && !source.getDamageType().equals("indirectCombo")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.melee_only", false);
                return false;
            }
            if (player.getHealth() < 2.0f) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.low_health", true);
                return false;
            }
            if (this.getHeldItem() == null) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.unarmed." + this.worldObj.rand.nextInt(3), true);
                this.setCurrentItemOrArmor(0, new ItemStack(Items.wooden_sword));
                return false;
            }
            if (!PlayerUtils.isHoldingWeapon(player)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.player_no_weapon", true);
                return false;
            }
            if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.armorBreak)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.armor_break", false);
            } else if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.endingBlow)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.ending_blow", false);
            } else if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.risingCut)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.rising_cut", false);
            } else if (source.getDamageType().equals("indirectSword") || source.getDamageType().equals("indirectCombo")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.ranged_sword", false);
            } else if (source.getDamageType().equals("nonSword")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.non_sword", false);
            } else {
                ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                if (skills.getTargetingSkill() == null) {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.unskilled." + this.worldObj.rand.nextInt(3), false);
                } else if (skills.getTargetingSkill().getCurrentTarget() == this) {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.hit." + this.worldObj.rand.nextInt(4), false);
                } else {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.wrong_target", false);
                }
            }
        }
        return super.attackEntityFrom(source, damage);
    }

    protected void damageEntity(DamageSource source, float amount) {
        if (source.getEntity() instanceof EntityPlayer) {
            amount = DirtyEntityAccessor.getModifiedDamage((EntityLivingBase)this, source, amount);
            ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)source, (float)amount);
            this.hitCounter = 0;
        } else {
            super.damageEntity(source, amount);
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).getHealth() < 2.0f) {
            this.setRevengeTarget(null);
            this.sendTranslatedChat((EntityPlayer)entity, "chat.zss.npc.orca.match.victory." + this.worldObj.rand.nextInt(4), true);
        } else {
            if (entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 1.0f)) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    boolean isBlocking = PlayerUtils.isBlocking(player);
                    if (!isBlocking && ++this.hitCounter > 2) {
                        this.setRevengeTarget(null);
                        this.sendTranslatedChat(player, "chat.zss.npc.orca.match.victory." + this.worldObj.rand.nextInt(4), true);
                    } else {
                        this.setRevengeTarget((EntityLivingBase)player);
                        if (isBlocking) {
                            this.sendTranslatedChat(player, "chat.zss.npc.orca.match.attack.blocked." + this.worldObj.rand.nextInt(2), false);
                        } else {
                            this.sendTranslatedChat(player, "chat.zss.npc.orca.match.attack." + this.worldObj.rand.nextInt(4), false);
                        }
                    }
                    ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
                    if (!isBlocking && combo != null && combo.isComboInProgress()) {
                        combo.getCombo().endCombo(player);
                    }
                }
                int knockback = 0;
                if (entity instanceof EntityLivingBase && (knockback += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity))) < 1 && entity instanceof EntityPlayer) {
                    knockback = 1;
                }
                if (knockback > 0) {
                    float f = (float)knockback * 0.5f;
                    double dx = -MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * f;
                    double dz = MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * f;
                    entity.addVelocity(dx, 0.1, dz);
                    this.motionX *= 0.6;
                    this.motionZ *= 0.6;
                }
                return true;
            }
            if (entity instanceof EntityPlayer && ZSSPlayerSkills.get((EntityPlayer)entity).isSkillActive(SkillBase.dodge)) {
                this.sendTranslatedChat((EntityPlayer)entity, "chat.zss.npc.orca.match.attack.dodged." + this.worldObj.rand.nextInt(2), false);
            }
        }
        return false;
    }

    @Override
    public void setRevengeTarget(EntityLivingBase entity) {
        EntityLivingBase prevTarget = this.getAttackTarget();
        Village tmp = this.villageObj;
        this.villageObj = null;
        super.setRevengeTarget(entity);
        this.setAttackTarget(entity);
        this.attackingPlayer = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        this.setMatchOpponent((Entity)this.attackingPlayer);
        this.villageObj = tmp;
        if (entity == null && prevTarget instanceof EntityPlayer) {
            this.nextMatch = this.worldObj.getTotalWorldTime() + 3000L;
            if (this.ticksExisted - this.func_142015_aE() > 99) {
                this.sendTranslatedChat((EntityPlayer)prevTarget, "chat.zss.npc.orca.match.timeout." + this.worldObj.rand.nextInt(3), true);
            }
        }
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        if (this.chatTimer > 0) {
            --this.chatTimer;
        }
        if (this.getAttackTarget() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.getAttackTarget();
            ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
            if (this.parryFlag) {
                this.parryFlag = false;
                if (this.getHeldItem() == null) {
                    this.setRevengeTarget(null);
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.disarmed." + this.worldObj.rand.nextInt(3), true);
                } else {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.disarm_attempt." + this.worldObj.rand.nextInt(3), false);
                }
            } else if (combo != null && combo.isComboInProgress() && combo.getCombo().getConsecutiveHits() > 9) {
                this.setRevengeTarget(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.combo." + this.worldObj.rand.nextInt(3), true);
            } else if (this.getHeldItem() == null) {
                this.setRevengeTarget(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.disarmed." + this.worldObj.rand.nextInt(3), true);
            } else if (this.recentlyHit < 60 && !PlayerUtils.isHoldingWeapon(player)) {
                this.setRevengeTarget(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.quit." + this.worldObj.rand.nextInt(4), true);
            } else if (this.recentlyHit < 10) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.player_idle." + this.worldObj.rand.nextInt(3), false);
                this.recentlyHit = 60;
            }
        }
        super.onLivingUpdate();
    }

    private void sendTranslatedChat(EntityPlayer player, String chat, boolean alwaysSend) {
        if (!this.worldObj.isRemote && (alwaysSend || this.rand.nextInt(Math.max(1, this.chatTimer)) == 0)) {
            PlayerUtils.sendTranslatedChat(player, chat, new Object[0]);
            this.chatTimer = this.worldObj.rand.nextInt(20) + this.worldObj.rand.nextInt(20) + 20;
        }
    }

    public boolean interact(EntityPlayer player) {
        Entity opponent = this.getMatchOpponent();
        if (opponent != null) {
            if (opponent != player) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.match.in_match", new Object[0]);
            }
            return false;
        }
        if (!player.worldObj.isRemote) {
            ItemStack stack = player.getHeldItem();
            if (ZSSPlayerSkills.get(player).completedCrests()) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.master." + player.worldObj.rand.nextInt(4), new Object[0]);
            } else if (stack != null && stack.getItem() instanceof ItemTreasure && stack.getItemDamage() == ItemTreasure.Treasures.KNIGHTS_CREST.ordinal()) {
                ZSSPlayerSkills.get(player).giveCrest();
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.idle." + this.rand.nextInt(5), new Object[0]);
            }
        }
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        if (!villager.worldObj.isRemote && villager.getClass() == EntityVillager.class && !villager.isChild()) {
            ItemStack stack = player.getHeldItem();
            return stack != null && stack.getItem() == ZSSItems.treasure && ItemTreasure.Treasures.byDamage(stack.getItemDamage()) == ItemTreasure.Treasures.KNIGHTS_CREST ? Event.Result.ALLOW : Event.Result.DEFAULT;
        }
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
        ZSSPlayerSkills.get(player).giveCrest();
    }

    @Override
    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.setCurrentItemOrArmor(0, new ItemStack(Items.wooden_sword));
        return data;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        this.parryFlag = true;
        return 0.5f;
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.0f;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setLong("nextMatch", this.nextMatch);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.nextMatch = compound.getLong("nextMatch");
    }
}

