/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ICustomMerchant;
import zeldaswordskills.entity.npc.EntityNpcBase;
import zeldaswordskills.item.ItemCustomEgg;

public abstract class EntityNpcMerchantBase
extends EntityNpcBase
implements ICustomMerchant {
    protected MerchantRecipeList trades;
    protected EntityPlayer customer;
    protected String lastCustomer;
    protected boolean refreshTrades;
    protected int refreshTimer;

    public EntityNpcMerchantBase(World world) {
        super(world);
    }

    protected abstract void populateTradingList();

    protected void refreshTradingList() {
        for (MerchantRecipe trade : this.trades) {
            if (!trade.isRecipeDisabled()) continue;
            trade.func_82783_a(this.rand.nextInt(6) + this.rand.nextInt(6) + 2);
        }
    }

    protected abstract void updateTradingList();

    protected void displayTradingGuiFor(EntityPlayer player) {
        if (!(this.worldObj.isRemote || this.trades != null && this.trades.size() <= 0)) {
            this.setCustomer(player);
            player.displayGUIMerchant((IMerchant)this, this.getCustomNameTag());
        }
    }

    public EntityPlayer getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityPlayer player) {
        this.customer = player;
    }

    public MerchantRecipeList getRecipes(EntityPlayer player) {
        if (this.trades == null || this.trades.isEmpty()) {
            this.populateTradingList();
        }
        return this.trades;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRecipes(MerchantRecipeList trades) {
        this.trades = trades;
    }

    @Override
    public void setMerchantTrades(MerchantRecipeList trades) {
        this.trades = trades;
    }

    public void useRecipe(MerchantRecipe recipe) {
        recipe.incrementToolUses();
        this.livingSoundTime = -this.getTalkInterval();
        this.playSound("mob.villager.yes", this.getSoundVolume(), this.getSoundPitch());
        if (recipe.hasSameIDsAs((MerchantRecipe)this.trades.get(this.trades.size() - 1))) {
            this.refreshTimer = 40;
            this.refreshTrades = true;
            this.lastCustomer = this.customer == null ? null : this.customer.getCommandSenderName();
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.worldObj.isRemote && this.livingSoundTime > -this.getTalkInterval() + 20) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playSound(stack == null ? "mob.villager.no" : "mob.villager.yes", this.getSoundVolume(), this.getSoundPitch());
        }
    }

    public boolean interact(EntityPlayer player) {
        boolean flag;
        ItemStack stack = player.inventory.getCurrentItem();
        boolean bl = flag = stack != null && (stack.getItem() == Items.spawn_egg || stack.getItem() instanceof ItemCustomEgg);
        if (!flag && this.isEntityAlive() && this.getCustomer() == null && !this.isChild() && !player.isSneaking()) {
            this.displayTradingGuiFor(player);
            return true;
        }
        return super.interact(player);
    }

    protected void updateAITasks() {
        if (this.getCustomer() == null && this.refreshTimer > 0) {
            --this.refreshTimer;
            if (this.refreshTimer <= 0) {
                if (this.refreshTrades) {
                    this.refreshTradingList();
                    this.updateTradingList();
                    this.refreshTrades = false;
                    if (this.villageObj != null && this.lastCustomer != null) {
                        this.worldObj.setEntityState((Entity)this, (byte)14);
                        this.villageObj.setReputationForPlayer(this.lastCustomer, 1);
                    }
                }
                this.addPotionEffect(new PotionEffect(Potion.regeneration.id, 200, 0));
            }
        }
        super.updateAITasks();
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        if (this.trades != null) {
            compound.setTag("Offers", (NBTBase)this.trades.getRecipiesAsTags());
        }
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.hasKey("Offers", 10)) {
            NBTTagCompound tradeTag = compound.getCompoundTag("Offers");
            this.trades = new MerchantRecipeList(tradeTag);
        }
    }
}

