/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import zeldaswordskills.ref.Config;

public abstract class EntityNpcBase
extends EntityCreature
implements INpc {
    private int randomTickDivider;
    public Village villageObj;

    public EntityNpcBase(World world) {
        super(world);
        this.setSize(0.6f, 1.8f);
        this.func_110163_bv();
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected abstract String getNameTagOnSpawn();

    private void setNameOnSpawn() {
        String name = this.getNameTagOnSpawn();
        if (name != null && name.length() > 0) {
            this.setCustomNameTag(name);
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.5);
    }

    public boolean allowLeashing() {
        return false;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean isEntityInvulnerable() {
        return Config.areNpcsInvulnerable();
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        if (--this.randomTickDivider <= 0) {
            this.worldObj.villageCollectionObj.addVillagerPosition(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ));
            this.randomTickDivider = 70 + this.rand.nextInt(50);
            this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), 32);
            if (this.villageObj == null) {
                this.detachHome();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.getCenter();
                this.setHomeArea(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, (int)((float)this.villageObj.getVillageRadius() * 0.6f));
            }
            this.randomUpdateTick();
        }
        super.updateAITick();
    }

    protected void randomUpdateTick() {
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        switch (flag) {
            case 12: {
                this.generateRandomParticles("heart");
                break;
            }
            case 13: {
                this.generateRandomParticles("angryVillager");
                break;
            }
            case 14: {
                this.generateRandomParticles("happyVillager");
                break;
            }
            default: {
                super.handleHealthUpdate(flag);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void generateRandomParticles(String particle) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(particle, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 1.0 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d1, d2);
        }
    }

    public void setRevengeTarget(EntityLivingBase entity) {
        super.setRevengeTarget(entity);
        if (this.villageObj != null && entity != null) {
            this.villageObj.addOrRenewAgressor(entity);
            if (entity instanceof EntityPlayer) {
                int rep = this.isChild() ? -3 : -1;
                this.villageObj.setReputationForPlayer(entity.getCommandSenderName(), rep);
                if (this.isEntityAlive()) {
                    this.worldObj.setEntityState((Entity)this, (byte)13);
                }
            }
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.setNameOnSpawn();
        return data;
    }
}

