/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ListIterator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.entity.npc.EntityNpcMerchantBase;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcBarnes
extends EntityNpcMerchantBase
implements INpcVillager {
    private static final MerchantRecipe standardBomb = new MerchantRecipe(new ItemStack(Items.emerald, 8), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_STANDARD.ordinal()));
    private static final MerchantRecipe waterBomb = new MerchantRecipe(new ItemStack(Items.emerald, 12), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal()));
    private static final MerchantRecipe fireBomb = new MerchantRecipe(new ItemStack(Items.emerald, 16), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FIRE.ordinal()));
    private static final MerchantRecipe bombSeeds = new MerchantRecipe(new ItemStack(ZSSItems.bombFlowerSeed), new ItemStack(Items.emerald, 4));

    public EntityNpcBarnes(World world) {
        super(world);
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Barnes";
    }

    protected String getLivingSound() {
        return "mob.villager.haggle";
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    @Override
    protected void populateTradingList() {
        MerchantRecipeList newTrades = new MerchantRecipeList();
        newTrades.add((Object)standardBomb);
        if (this.trades == null) {
            this.trades = newTrades;
        } else {
            for (int i = 0; i < this.trades.size(); ++i) {
                MerchantRecipeHelper.addToListWithCheck(newTrades, (MerchantRecipe)this.trades.get(i));
            }
            this.trades = newTrades;
        }
    }

    @Override
    protected void refreshTradingList() {
        ListIterator iterator = this.trades.listIterator();
        while (iterator.hasNext()) {
            MerchantRecipe trade = (MerchantRecipe)iterator.next();
            if (this.isBombTrade(trade)) {
                iterator.set(this.getRefreshedBombTrade(trade));
                continue;
            }
            if (!trade.isRecipeDisabled()) continue;
            trade.func_82783_a(this.rand.nextInt(6) + this.rand.nextInt(6) + 2);
        }
    }

    @Override
    protected void updateTradingList() {
    }

    private boolean isBombTrade(MerchantRecipe trade) {
        return this.isBombTrade(trade.getItemToSell()) || this.isBombTrade(trade.getItemToBuy());
    }

    private boolean isBombTrade(ItemStack stack) {
        return stack != null && (stack.getItem() instanceof ItemBomb || stack.getItem() instanceof ItemBombBag || stack.getItem() == ZSSItems.bombFlowerSeed);
    }

    private MerchantRecipe getRefreshedBombTrade(MerchantRecipe trade) {
        MerchantRecipe newTrade = new MerchantRecipe(trade.getItemToBuy(), trade.getSecondItemToBuy(), trade.getItemToSell());
        newTrade.func_82783_a(92);
        return newTrade;
    }

    @Override
    public boolean interact(EntityPlayer player) {
        if (!this.isEntityAlive() || player.isSneaking()) {
            return false;
        }
        if (this.getCustomer() != null) {
            if (!this.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.merchant.busy", new Object[0]);
            }
            return true;
        }
        ItemStack stack = player.getHeldItem();
        String chat = "chat.zss.npc.barnes.greeting";
        boolean openGui = true;
        if (stack != null && this.trades != null) {
            if (stack.getItem() == ZSSItems.bombFlowerSeed) {
                chat = this.insertBombTrade(bombSeeds) ? "chat.zss.npc.barnes.trade.bombseeds.new" : "chat.zss.npc.barnes.trade.bombseeds.old";
            } else if (stack.getItem() == Items.fish) {
                if (this.insertBombTrade(waterBomb)) {
                    --stack.stackSize;
                    chat = "chat.zss.npc.barnes.trade.water";
                    openGui = false;
                }
            } else if (stack.getItem() == Items.magma_cream) {
                if (this.insertBombTrade(fireBomb)) {
                    --stack.stackSize;
                    chat = "chat.zss.npc.barnes.trade.fire";
                    openGui = false;
                }
            } else if (!MerchantRecipeHelper.hasSimilarTrade(this.trades, waterBomb)) {
                chat = "chat.zss.npc.barnes.material.water";
            } else if (!MerchantRecipeHelper.hasSimilarTrade(this.trades, fireBomb)) {
                chat = "chat.zss.npc.barnes.material.fire";
            }
        }
        if (!this.worldObj.isRemote) {
            PlayerUtils.sendTranslatedChat(player, chat, new Object[0]);
            if (openGui) {
                this.displayTradingGuiFor(player);
            }
        }
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        if (player.worldObj.isRemote || villager.getClass() != EntityVillager.class || villager.isChild()) {
            return Event.Result.DEFAULT;
        }
        if (PlayerUtils.consumeHeldItem(player, Items.gunpowder, 1)) {
            return Event.Result.ALLOW;
        }
        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.barnes.hmph", new Object[0]);
        return Event.Result.DENY;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.barnes.open", new Object[0]);
        this.populateTradingList();
    }

    public boolean addBombBagTrade() {
        return Config.enableTradeBombBag() && this.insertBombTrade(new MerchantRecipe(new ItemStack(Items.emerald, Config.getBombBagPrice()), new ItemStack(ZSSItems.bombBag)));
    }

    private boolean insertBombTrade(MerchantRecipe trade) {
        MerchantRecipe r;
        if (this.trades == null || MerchantRecipeHelper.hasSimilarTrade(this.trades, trade)) {
            return false;
        }
        int i = 0;
        for (i = 0; i < this.trades.size() && (r = (MerchantRecipe)this.trades.get(i)).getItemToSell().getItem() instanceof ItemBomb; ++i) {
        }
        this.trades.add(i, (Object)trade);
        return true;
    }
}

