/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ISongEntity;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ai.GenericAIDefendVillage;
import zeldaswordskills.entity.ai.IVillageDefender;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.QuestBiggoronSword;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class EntityGoron
extends EntityVillager
implements IVillageDefender,
ISongEntity {
    private static final MerchantRecipe BIGGORONS_TRADE = new MerchantRecipe(new ItemStack(ZSSItems.masterOre, 3), new ItemStack(Items.diamond, 4), new ItemStack(ZSSItems.swordBiggoron));
    protected Village village;
    private static final Byte ATTACK_FLAG = 4;
    private int regenTimer;
    private boolean wasChild;

    public EntityGoron(World world) {
        this(world, 0);
    }

    public EntityGoron(World world, int profession) {
        super(world, profession);
        this.setSize(1.5f, 2.8f);
        this.tasks.taskEntries.clear();
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAILookAtTradePlayer((EntityVillager)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, IMob.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).getAttributeValue(), 16.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIVillagerMate((EntityVillager)this));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIFollowGolem((EntityVillager)this));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIPlay((EntityVillager)this, 0.32));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityVillager.class, 5.0f, 0.02f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetTasks.addTask(1, (EntityAIBase)new GenericAIDefendVillage(this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(0.75);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
        this.isImmuneToFire = true;
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
    }

    private void updateEntityAttributes() {
        this.updateEntityAttributes(this.isChild());
    }

    private void updateEntityAttributes(boolean isChild) {
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(isChild ? 40.0 : 100.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(isChild ? 0.5 : 0.3);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(isChild ? 0.25 : 0.75);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(isChild ? 2.0 : 8.0);
        this.wasChild = isChild;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        super.onLivingUpdate();
        if ((this.getAITarget() instanceof EntityPlayer || this.getAttackTarget() instanceof EntityPlayer) && (this.ticksExisted > this.func_142015_aE() + 30 || this.recentlyHit < 70)) {
            this.setRevengeTarget(null);
            this.setAttackTarget(null);
            this.attackingPlayer = null;
        }
        if (!this.worldObj.isRemote) {
            this.updateHealth();
        }
    }

    public void updateAITick() {
        ChunkCoordinates cc;
        super.updateAITick();
        if (!this.hasHome()) {
            this.village = null;
        } else if (this.village == null && (cc = this.getHomePosition()) != null) {
            this.village = this.worldObj.villageCollectionObj.findNearestVillage(cc.posX, cc.posY, cc.posZ, 32);
        }
    }

    protected void updateHealth() {
        if (this.getHealth() < this.getMaxHealth() && ++this.regenTimer > 399) {
            this.heal(1.0f);
            this.regenTimer = 0;
        }
        if (this.wasChild && !this.isChild()) {
            this.updateEntityAttributes();
        }
    }

    public MerchantRecipeList getRecipes(EntityPlayer player) {
        MerchantRecipeList list = super.getRecipes(player);
        MerchantRecipeHelper.removeTrade(list, BIGGORONS_TRADE, false, true);
        if ("Biggoron".equals(this.getCustomNameTag()) && ZSSQuests.get(player).hasCompleted(QuestBiggoronSword.class)) {
            list.add(0, (Object)BIGGORONS_TRADE);
        }
        return list;
    }

    public boolean interact(EntityPlayer player) {
        if (this.worldObj.isRemote) {
            return super.interact(player);
        }
        boolean isDarunia = "Darunia".equals(this.getCustomNameTag());
        boolean isCured = ZSSPlayerSongs.get(player).hasCuredNpc("Darunia");
        if (isDarunia && !isCured || this.rand.nextInt(4) == 0) {
            String chat;
            String string = chat = "Darunia".equals(this.getCustomNameTag()) ? "chat.zss.darunia." : "chat.zss.goron.";
            if (isCured) {
                PlayerUtils.sendTranslatedChat(player, chat + "cured." + this.rand.nextInt(4), new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, chat + "depressed." + this.rand.nextInt(4), new Object[0]);
            }
            return true;
        }
        return super.interact(player);
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (super.attackEntityFrom(source, amount)) {
            Entity entity = source.getEntity();
            if (entity != this && entity instanceof EntityLivingBase && this.riddenByEntity != entity && this.ridingEntity != entity) {
                this.setAttackTarget((EntityLivingBase)entity);
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        if (flag == ATTACK_FLAG) {
            this.attackTime = 10;
        } else {
            super.handleHealthUpdate(flag);
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        if (this.attackTime > 0) {
            return false;
        }
        float amount = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int knockback = 0;
        this.attackTime = 20;
        this.worldObj.setEntityState((Entity)this, ATTACK_FLAG.byteValue());
        if (entity instanceof EntityLivingBase) {
            amount += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            knockback += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), amount)) {
            int fire;
            if (knockback > 0) {
                float f = (float)knockback * 0.5f;
                double dx = -MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * f;
                double dz = MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * f;
                entity.addVelocity(dx, 0.1, dz);
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((fire = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(fire * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return flag;
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    protected void collideWithEntity(Entity entity) {
        if (entity instanceof IMob && this.canAttackClass(entity.getClass()) && this.getRNG().nextInt(20) == 0) {
            this.setAttackTarget((EntityLivingBase)entity);
        }
        super.collideWithEntity(entity);
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + (this.isChild() ? 4 : 10);
    }

    protected String getLivingSound() {
        return this.isTrading() ? "mob.villager.haggle" : "mob.villager.idle";
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    public EntityGoron createChild(EntityAgeable entity) {
        EntityGoron goron = new EntityGoron(this.worldObj);
        goron.onSpawnWithEgg(null);
        goron.updateEntityAttributes(true);
        return goron;
    }

    @Override
    public Village getVillageToDefend() {
        return this.village;
    }

    @Override
    public boolean onSongPlayed(EntityPlayer player, AbstractZeldaSong song, int power, int affected) {
        if ("Darunia".equals(this.getCustomNameTag())) {
            this.playLivingSound();
            if (song == ZeldaSongs.songSaria) {
                if (ZSSPlayerSongs.get(player).hasCuredNpc("Darunia")) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.song.saria.darunia.thanks", new Object[0]);
                } else if (power < 5) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.song.saria.darunia.weak", new Object[0]);
                } else if (ZSSPlayerSongs.get(player).onCuredNpc("Darunia")) {
                    ItemStack gift = new ItemStack(ZSSItems.gauntletsSilver);
                    new TimedChatDialogue(player, 0, 1500, new IChatComponent[]{new ChatComponentTranslation("chat.zss.song.saria.darunia.0", new Object[0]), new ChatComponentTranslation("chat.zss.song.saria.darunia.1", new Object[0]), new ChatComponentTranslation("chat.zss.song.saria.darunia.2", new Object[]{new ChatComponentTranslation(gift.getUnlocalizedName() + ".name", new Object[0])})});
                    new TimedAddItem(player, gift, 3000, "zeldaswordskills:success");
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.song.saria.darunia.thanks", new Object[0]);
                }
            } else if (ZSSPlayerSongs.get(player).hasCuredNpc("Darunia")) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.darunia.cured.wrong", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.darunia.wrong", new Object[0]);
            }
            return true;
        }
        if (song == ZeldaSongs.songSaria && affected == 0) {
            this.playLivingSound();
            if (ZSSPlayerSongs.get(player).hasCuredNpc("Darunia")) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.saria.goron", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.saria.goron.depressed", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.updateEntityAttributes();
    }

    public static void doVillagerSpawn(EntityVillager villager, World world) {
        NBTTagCompound compound = villager.getEntityData();
        if (!villager.isChild() && !compound.hasKey("zssFirstJoinFlag")) {
            compound.setBoolean("zssFirstJoinFlag", true);
            int ratio = ZSSEntities.getGoronRatio();
            if (ratio > 0 && world.rand.nextInt(ratio) == 0) {
                int x = MathHelper.floor_double((double)villager.posX);
                int y = MathHelper.floor_double((double)villager.posY);
                int z = MathHelper.floor_double((double)villager.posZ);
                try {
                    if (world.villageCollectionObj.getVillageList().isEmpty() || world.villageCollectionObj.findNearestVillage(x, y, z, 32) != null) {
                        EntityGoron goron = new EntityGoron(world, world.rand.nextInt(5));
                        double posX = villager.posX + (double)world.rand.nextInt(8) - 4.0;
                        double posZ = villager.posZ + (double)world.rand.nextInt(8) - 4.0;
                        goron.setLocationAndAngles(posX, villager.posY + 1.0, posZ, villager.rotationYaw, villager.rotationPitch);
                        if (goron.getCanSpawnHere()) {
                            world.spawnEntityInWorld((Entity)goron);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }
}

