/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ai.EntityAINearestAttackableTargetNight;
import zeldaswordskills.entity.ai.EntityAIRangedMagic;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.ai.IEntityTeleport;
import zeldaswordskills.entity.ai.IMagicUser;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityWizzrobe
extends EntityMob
implements IEntityLootable,
IEntityTeleport,
IEntityVariant,
IMagicUser {
    protected static final int TYPE_INDEX = 16;
    protected static final int CASTING_TIME = 17;
    protected static final int MAX_CAST_TIME = 18;
    protected final EntityAIRangedMagic magicAI = this.getMagicAI();
    protected final EntityAITeleport teleportAI = this.getNewTeleportAI();
    private int noTargetTime;

    public static String[] getDefaultBiomes() {
        ArrayList biomes = Lists.newArrayList((Object[])new BiomeType[]{BiomeType.ARID, BiomeType.JUNGLE, BiomeType.PLAINS, BiomeType.RIVER, BiomeType.TAIGA});
        for (WizzrobeType type : WizzrobeType.values()) {
            biomes.add(type.favoredBiome);
        }
        return BiomeType.getBiomeArray(null, biomes.toArray(new BiomeType[biomes.size()]));
    }

    public EntityWizzrobe(World world) {
        super(world);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)this.magicAI);
        this.tasks.addTask(3, (EntityAIBase)this.teleportAI);
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTargetNight((EntityCreature)this, EntityPlayer.class, 0, true, 0.5f));
        this.experienceValue = 8;
        this.setSize(0.6f, 1.8f);
        this.setType(WizzrobeType.WIND_WIZ);
    }

    @Override
    public EntityAITeleport getTeleportAI() {
        return this.teleportAI;
    }

    protected EntityAITeleport getNewTeleportAI() {
        return new EntityAITeleport((EntityCreature)this, 16.0, 60, true, true, true, true, true);
    }

    protected EntityAIRangedMagic getMagicAI() {
        return new EntityAIRangedMagic(this, 20, 60, 16.0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)((byte)WizzrobeType.WIND_WIZ.ordinal()));
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)0);
    }

    public MagicType getMagicType() {
        return this.getWizzrobeType().magicType;
    }

    public WizzrobeType getWizzrobeType() {
        return WizzrobeType.values()[this.dataWatcher.getWatchableObjectByte(16) % WizzrobeType.values().length];
    }

    public void setType(WizzrobeType type) {
        this.dataWatcher.updateObject(16, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
    }

    @Override
    public EntityWizzrobe setType(int type) {
        this.setType(WizzrobeType.values()[type % WizzrobeType.values().length]);
        return this;
    }

    private void setTypeOnSpawn() {
        if (Config.areMobVariantsAllowed() && this.rand.nextFloat() < Config.getMobVariantChance()) {
            this.setType(this.rand.nextInt(WizzrobeType.values().length));
        } else {
            BiomeGenBase biome = this.worldObj.getBiomeGenForCoords(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ));
            BiomeType biomeType = BiomeType.getBiomeTypeFor(biome);
            for (WizzrobeType t : WizzrobeType.values()) {
                if (t.favoredBiome != biomeType) continue;
                this.setType(t);
                return;
            }
            if (biomeType != null) {
                switch (biomeType) {
                    case ARID: {
                        this.setType(this.rand.nextFloat() < 0.5f ? WizzrobeType.LIGHTNING_WIZ : WizzrobeType.FIRE_WIZ);
                        break;
                    }
                    case RIVER: 
                    case JUNGLE: {
                        this.setType(this.rand.nextFloat() < 0.5f ? WizzrobeType.WIND_WIZ : WizzrobeType.LIGHTNING_WIZ);
                        break;
                    }
                    case TAIGA: {
                        this.setType(this.rand.nextFloat() < 0.5f ? WizzrobeType.WIND_WIZ : WizzrobeType.ICE_WIZ);
                        break;
                    }
                }
            }
        }
    }

    protected void applyTypeTraits() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        info.removeAllBuffs();
        info.applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 50);
        info.applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 50);
        switch (this.getMagicType()) {
            case FIRE: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 50);
                info.applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
                break;
            }
            case ICE: {
                info.applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 50);
                info.applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 100);
                break;
            }
            case LIGHTNING: {
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
                break;
            }
            case WIND: {
                break;
            }
        }
    }

    protected int getBaseCastingTime() {
        return 80;
    }

    public int getCurrentCastingTime() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    private void setCurrentCastingTime(int time) {
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(17, (Object)Math.max(0, time));
        }
    }

    public int getMaxCastingTime() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    private void setMaxCastingTime(int time) {
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(18, (Object)Math.max(0, time));
        }
    }

    public final void setTeleBounds(AxisAlignedBB newBounds) {
        this.teleportAI.setTeleBounds(newBounds);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean attackEntityAsMob(Entity target) {
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.worldObj.isRemote) {
            boolean wasReflected = false;
            if (source.getSourceOfDamage() instanceof EntityMagicSpell) {
                EntityMagicSpell spell = (EntityMagicSpell)source.getSourceOfDamage();
                wasReflected = spell.getEntityData().getBoolean("isReflected");
                if (spell.getThrower() == this && !wasReflected) {
                    return false;
                }
            }
            if (!wasReflected && this.canTelevade(source) && this.teleportAI.teleportRandomly()) {
                return false;
            }
        }
        return super.attackEntityFrom(source, amount);
    }

    protected void damageEntity(DamageSource source, float amount) {
        if (this.getCurrentCastingTime() > 0 && !this.isEntityInvulnerable() && amount >= this.getMinInterruptDamage()) {
            float interruptChance = 1.0f - (this.getMaxInterruptDamage() - amount) / this.getMaxInterruptDamage();
            if (this.rand.nextFloat() < interruptChance) {
                this.magicAI.interruptCasting();
                this.teleportAI.scheduleNextTeleport(2);
            }
        }
        super.damageEntity(source, amount);
    }

    protected Entity findPlayerToAttack() {
        return this.getBrightness(1.0f) < 0.5f ? this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 32.0) : null;
    }

    protected float getBaseSpellDamage() {
        return 4.0f;
    }

    protected float getSpellAoE() {
        return 1.25f;
    }

    protected float getReflectChance() {
        return -1.0f;
    }

    protected float getMinInterruptDamage() {
        return 4.0f;
    }

    protected float getMaxInterruptDamage() {
        return 16.0f;
    }

    private boolean canTelevade(DamageSource source) {
        if (this.getCurrentCastingTime() > 0 || !this.canEvadeSource(source)) {
            return false;
        }
        return this.teleportAI.canTeleport() || !this.teleportAI.isTeleporting() && this.rand.nextFloat() < this.getTelevadeChance();
    }

    protected boolean canEvadeSource(DamageSource source) {
        return source.getEntity() != null;
    }

    protected float getTelevadeChance() {
        return 0.5f;
    }

    @Override
    public boolean canContinueCasting() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        if (info.isBuffActive(Buff.STUN)) {
            if (this.worldObj.rand.nextInt(50) > info.getBuffAmplifier(Buff.STUN)) {
                info.removeBuff(Buff.STUN);
            }
            return false;
        }
        return true;
    }

    @Override
    public int beginSpellCasting(EntityLivingBase target) {
        if (target == null) {
            return 0;
        }
        int castTime = this.getBaseCastingTime() - this.worldObj.difficultySetting.getDifficultyId() * 10;
        castTime += (this.rand.nextInt(castTime) - this.rand.nextInt(castTime)) / 2;
        this.setMaxCastingTime(castTime);
        this.setCurrentCastingTime(castTime);
        return castTime;
    }

    @Override
    public void castPassiveSpell() {
    }

    @Override
    public void castRangedSpell(EntityLivingBase target, float range) {
        float difficulty = this.worldObj.difficultySetting.getDifficultyId();
        EntityMagicSpell spell = new EntityMagicSpell(this.worldObj, (EntityLivingBase)this, target, 0.8f + 0.25f * difficulty, 14 - this.worldObj.difficultySetting.getDifficultyId() * 4);
        spell.setType(this.getMagicType());
        spell.setArea(this.getSpellAoE());
        spell.setDamageBypassesArmor();
        spell.setDamage(this.getBaseSpellDamage() * difficulty);
        spell.setReflectChance(this.getReflectChance());
        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whoosh", 0.4f, 0.5f);
        if (!this.worldObj.isRemote) {
            this.worldObj.spawnEntityInWorld((Entity)spell);
        }
        this.teleportAI.scheduleNextTeleport(this.rand.nextInt(5) + this.rand.nextInt(5) + 6);
    }

    @Override
    public void stopCasting() {
        this.setCurrentCastingTime(0);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        int castTime = this.getCurrentCastingTime();
        if (!this.worldObj.isRemote && castTime > 0) {
            this.setCurrentCastingTime(--castTime);
            MagicType type = this.getMagicType();
            if (castTime % type.getSoundFrequency() == 0) {
                this.worldObj.playSoundAtEntity((Entity)this, type.getMovingSound(), type.getSoundVolume(this.rand) * 0.5f, type.getSoundPitch(this.rand));
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.worldObj.spawnParticle("portal", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - 0.25, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
        }
        if (this.worldObj.isDaytime() && this.ticksExisted % 20 == 0 && !this.isValidLightLevel()) {
            this.despawnEntity();
        }
    }

    public void onUpdate() {
        super.onUpdate();
        this.teleportAI.invalidateBounds(256.0);
        if (!this.onGround && this.motionY < 0.0) {
            this.motionY *= 0.6;
        }
        if (this.isBurning() && this.getMagicType() == MagicType.FIRE) {
            this.extinguish();
        }
        if (this.teleportAI.getTeleBounds() == null && this.getEntityToAttack() == null && ++this.noTargetTime > 400) {
            this.noTargetTime = 0;
            Entity player = this.findPlayerToAttack();
            if (player instanceof EntityPlayer && !this.worldObj.isRemote && this.canEntityBeSeen(player) && !((EntityPlayer)player).capabilities.disableDamage) {
                this.setTarget(player);
                this.teleportAI.setTeleporting();
                for (int i = 0; i < 64 && !EntityAITeleport.teleportToEntity(this.worldObj, (EntityLivingBase)this, player, null, this.teleportAI.isGrounded); ++i) {
                }
            }
        }
    }

    protected void fall(float distance) {
    }

    protected Item getDropItem() {
        return Items.ender_pearl;
    }

    protected void dropRareDrop(int rarity) {
        ItemStack drop = this.getRareDrop(rarity, 4);
        if (drop != null) {
            this.entityDropItem(drop, 0.0f);
        }
    }

    private ItemStack getRareDrop(int rarity, int modifier) {
        if (rarity > 0) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
        }
        if (this.rand.nextInt(8) == 0) {
            ItemStack book = new ItemStack(Items.book);
            EnchantmentHelper.addRandomEnchantment((Random)this.rand, (ItemStack)book, (int)(this.rand.nextInt(8) + this.rand.nextInt(8) + modifier));
            return book;
        }
        switch (this.getWizzrobeType()) {
            case FIRE_WIZ: {
                return new ItemStack(ZSSItems.arrowFire);
            }
            case ICE_WIZ: {
                return new ItemStack(ZSSItems.arrowIce);
            }
            case LIGHTNING_WIZ: {
                return new ItemStack(ZSSItems.arrowLight);
            }
        }
        return null;
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.rand.nextInt(10 - whip.ordinal()) == 0) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
        }
        return this.getRareDrop(0, 3 * (whip.ordinal() + 1));
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return true;
    }

    public boolean getCanSpawnHere() {
        return !this.worldObj.isDaytime() && super.getCanSpawnHere() && this.worldObj.getTotalWorldTime() > (long)Config.getTimeToSpawnWizzrobe();
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.setTypeOnSpawn();
        return data;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setByte("WizzrobeType", this.dataWatcher.getWatchableObjectByte(16));
        AxisAlignedBB box = this.teleportAI.getTeleBounds();
        if (box != null) {
            NBTTagCompound bounds = new NBTTagCompound();
            bounds.setDouble("minX", box.minX);
            bounds.setDouble("maxX", box.maxX);
            bounds.setDouble("minY", box.minY);
            bounds.setDouble("maxY", box.maxY);
            bounds.setDouble("minZ", box.minZ);
            bounds.setDouble("maxZ", box.maxZ);
            compound.setTag("teleBounds", (NBTBase)bounds);
        }
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.dataWatcher.updateObject(16, (Object)compound.getByte("WizzrobeType"));
        if (compound.hasKey("teleBounds")) {
            NBTTagCompound bounds = compound.getCompoundTag("teleBounds");
            double minX = bounds.getDouble("minX");
            double maxX = bounds.getDouble("maxX");
            double minY = bounds.getDouble("minY");
            double maxY = bounds.getDouble("maxY");
            double minZ = bounds.getDouble("minZ");
            double maxZ = bounds.getDouble("maxZ");
            this.setTeleBounds(AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
    }

    public static enum WizzrobeType {
        FIRE_WIZ(MagicType.FIRE, BiomeType.FIERY),
        ICE_WIZ(MagicType.ICE, BiomeType.COLD),
        LIGHTNING_WIZ(MagicType.LIGHTNING, BiomeType.MOUNTAIN),
        WIND_WIZ(MagicType.WIND, BiomeType.FOREST);

        public final MagicType magicType;
        public final BiomeType favoredBiome;

        private WizzrobeType(MagicType type, BiomeType favoredBiome) {
            this.magicType = type;
            this.favoredBiome = favoredBiome;
        }
    }
}

