/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BiomeType;

public class EntityKeese
extends EntityBat
implements IMob,
IEntityLootable,
IEntityVariant {
    private ChunkCoordinates currentFlightTarget;
    private static final int TYPE_INDEX = 17;
    private static final int SHOCK_INDEX = 18;
    private boolean swarmSpawned;

    public static String[] getDefaultBiomes() {
        ArrayList biomes = Lists.newArrayList((Object[])new BiomeType[]{BiomeType.RIVER, BiomeType.MOUNTAIN});
        for (KeeseType type : KeeseType.values()) {
            if (type.favoredBiome != null) {
                biomes.add(type.favoredBiome);
            }
            if (type.secondBiome == null) continue;
            biomes.add(type.secondBiome);
        }
        return BiomeType.getBiomeArray(null, biomes.toArray(new BiomeType[biomes.size()]));
    }

    public EntityKeese(World world) {
        super(world);
        this.setSize(0.5f, 0.9f);
        this.setIsBatHanging(true);
        this.setType(KeeseType.NORMAL);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)((byte)KeeseType.NORMAL.ordinal()));
        this.dataWatcher.addObject(18, (Object)0);
    }

    public KeeseType getType() {
        return KeeseType.values()[this.dataWatcher.getWatchableObjectByte(17) % KeeseType.values().length];
    }

    public void setType(KeeseType type) {
        this.dataWatcher.updateObject(17, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)this.getType().maxHealth);
        this.setHealth(this.getMaxHealth());
    }

    @Override
    public EntityKeese setType(int type) {
        this.setType(KeeseType.values()[type % KeeseType.values().length]);
        return this;
    }

    private void setTypeOnSpawn() {
        if (this.worldObj.provider.isHellWorld && this.rand.nextFloat() < Config.getKeeseCursedChance()) {
            this.setType(KeeseType.CURSED);
        } else if (this.rand.nextFloat() < Config.getKeeseCursedChance()) {
            this.setType(KeeseType.CURSED);
        } else if (Config.areMobVariantsAllowed() && this.rand.nextFloat() < Config.getMobVariantChance()) {
            this.setType(this.rand.nextInt(KeeseType.values().length));
        } else {
            BiomeGenBase biome = this.worldObj.getBiomeGenForCoords(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ));
            BiomeType biomeType = BiomeType.getBiomeTypeFor(biome);
            for (KeeseType t : KeeseType.values()) {
                if (t.favoredBiome != biomeType && t.secondBiome != biomeType) continue;
                this.setType(t);
                return;
            }
        }
    }

    private void applyTypeTraits() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        info.removeAllBuffs();
        info.applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 50);
        switch (this.getType()) {
            case CURSED: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
                info.applyBuff(Buff.WEAKNESS_HOLY, Integer.MAX_VALUE, 100);
                this.experienceValue = 7;
                break;
            }
            case FIRE: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
                info.applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
                this.isImmuneToFire = true;
                this.experienceValue = 3;
                break;
            }
            case ICE: {
                info.applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
                info.applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 100);
                this.experienceValue = 3;
                break;
            }
            case THUNDER: {
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 100);
                this.experienceValue = 5;
                break;
            }
            default: {
                this.experienceValue = 1;
            }
        }
    }

    protected boolean canShock() {
        return this.getType() == KeeseType.THUNDER;
    }

    public int getShockTime() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    public void setShockTime(int time) {
        this.dataWatcher.updateObject(18, (Object)time);
    }

    public boolean getSpawnSwarm() {
        return !this.swarmSpawned;
    }

    public EntityKeese setSpawnSwarm(boolean spawnSwarm) {
        this.swarmSpawned = !spawnSwarm;
        return this;
    }

    private float getDamage() {
        return 2.0f;
    }

    private DamageSource getDamageSource() {
        if (this.getShockTime() > 0) {
            return new DamageUtils.DamageSourceShock("shock", (Entity)this, this.worldObj.difficultySetting.getDifficultyId() * 50, 1.0f);
        }
        switch (this.getType()) {
            case FIRE: {
                return new EntityDamageSource("mob", (Entity)this).setFireDamage();
            }
            case ICE: {
                return new DamageUtils.DamageSourceIce("mob", (Entity)this, 100, 0);
            }
        }
        return new EntityDamageSource("mob", (Entity)this);
    }

    protected void dropRareDrop(int rarity) {
        if (this.getType() == KeeseType.CURSED) {
            switch (rarity) {
                case 1: {
                    this.entityDropItem(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal()), 0.0f);
                    break;
                }
                default: {
                    this.entityDropItem(new ItemStack(this.rand.nextInt(8) == 0 ? ZSSItems.smallHeart : ZSSItems.heartPiece), 0.0f);
                    break;
                }
            }
        } else {
            switch (rarity) {
                case 1: {
                    this.entityDropItem(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.MONSTER_CLAW.ordinal()), 0.0f);
                    break;
                }
                default: {
                    this.entityDropItem(new ItemStack(this.rand.nextInt(3) == 1 ? Items.emerald : ZSSItems.smallHeart), 0.0f);
                }
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.rand.nextFloat() < 0.1f * (float)(1 + whip.ordinal())) {
            return new ItemStack(ZSSItems.treasure, 1, this.getType() == KeeseType.CURSED ? ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal() : ItemTreasure.Treasures.MONSTER_CLAW.ordinal());
        }
        return new ItemStack(this.rand.nextInt(3) > 0 ? Items.emerald : ZSSItems.smallHeart);
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return true;
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (this.attackTime == 0 && this.canEntityBeSeen((Entity)player) && this.getDistanceSqToEntity((Entity)player) < 1.5 && (player.getCurrentArmor(3) == null || player.getCurrentArmor(3).getItem() != ZSSItems.maskSkull) && player.attackEntityFrom(this.getDamageSource(), this.getDamage())) {
            this.attackTime = this.rand.nextInt(20) + 20;
            this.playSound("mob.bat.hurt", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            int t = this.getShockTime();
            if (t > 0) {
                this.setShockTime(Math.max(0, t - this.rand.nextInt(50) - 25));
            }
            switch (this.getType()) {
                case CURSED: {
                    this.applyRandomCurse(player);
                    break;
                }
                case FIRE: {
                    if (!(this.rand.nextFloat() < 0.5f)) break;
                    player.setFire(this.rand.nextInt(4) + 4);
                    break;
                }
            }
        }
    }

    private void applyRandomCurse(EntityPlayer player) {
        switch (this.rand.nextInt(16)) {
            case 0: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.ATTACK_DOWN, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 1: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.rand.nextInt(500) + 100, this.rand.nextInt(26) + 25);
                break;
            }
            case 2: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_DOWN, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 3: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_COLD, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 4: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_FIRE, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 5: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_MAGIC, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 6: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_SHOCK, this.rand.nextInt(500) + 100, this.rand.nextInt(51) + 50);
                break;
            }
            case 7: {
                player.addPotionEffect(new PotionEffect(Potion.confusion.id, this.rand.nextInt(500) + 100, 1));
                break;
            }
            case 8: {
                player.addPotionEffect(new PotionEffect(Potion.blindness.id, this.rand.nextInt(500) + 100, 1));
                break;
            }
            case 9: {
                player.addPotionEffect(new PotionEffect(Potion.poison.id, this.rand.nextInt(100) + 50, this.rand.nextInt(9) / 8));
                break;
            }
            case 10: {
                player.addPotionEffect(new PotionEffect(Potion.harm.id, 1, this.rand.nextInt(9) / 8));
                break;
            }
        }
    }

    public void onUpdate() {
        int time;
        super.onUpdate();
        if (!this.swarmSpawned && !this.worldObj.isRemote) {
            this.swarmSpawned = true;
            if (this.rand.nextFloat() < Config.getKeeseSwarmChance()) {
                int n = Config.getKeeseSwarmSize() - this.rand.nextInt(Config.getKeeseSwarmSize());
                for (int i = 0; i < n; ++i) {
                    EntityKeese k = new EntityKeese(this.worldObj);
                    double x = this.posX + (double)(this.rand.nextFloat() * 2.0f);
                    double z = this.posZ + (double)(this.rand.nextFloat() * 2.0f);
                    k.setPosition(x, this.posY, z);
                    k.setTypeOnSpawn();
                    k.swarmSpawned = true;
                    this.worldObj.spawnEntityInWorld((Entity)k);
                }
            }
        }
        if ((time = this.getShockTime()) > 0) {
            this.setShockTime(time - 1);
            if (time % 8 > 6 && this.rand.nextInt(4) == 0) {
                this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:shock", this.getSoundVolume(), 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
            }
        }
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
    }

    protected void updateAITasks() {
        block10: {
            block12: {
                block11: {
                    if (ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN)) {
                        return;
                    }
                    super.updateAITasks();
                    if (this.getIsBatHanging()) break block10;
                    if (!(this.currentFlightTarget == null || this.worldObj.isAirBlock(this.currentFlightTarget.posX, this.currentFlightTarget.posY, this.currentFlightTarget.posZ) && this.currentFlightTarget.posY >= 1)) {
                        this.currentFlightTarget = null;
                    }
                    if (this.currentFlightTarget == null || this.rand.nextInt(30) == 0) break block11;
                    float f = this.currentFlightTarget.getDistanceSquared((int)this.posX, (int)this.posY, (int)this.posZ);
                    float f2 = this.attackingPlayer != null ? 1.0f : 4.0f;
                    if (!(f < f2)) break block12;
                }
                EntityPlayer entityPlayer = this.attackingPlayer = this.getLastAttacker() instanceof EntityPlayer ? (EntityPlayer)this.getLastAttacker() : this.worldObj.getClosestPlayerToEntity((Entity)this, 8.0);
                if (!(this.attackingPlayer == null || this.attackingPlayer.capabilities.isCreativeMode || this.attackingPlayer.getCurrentArmor(3) != null && this.attackingPlayer.getCurrentArmor(3).getItem() == ZSSItems.maskSkull)) {
                    this.currentFlightTarget = new ChunkCoordinates((int)this.attackingPlayer.posX, (int)this.attackingPlayer.posY + 1, (int)this.attackingPlayer.posZ);
                    this.worldObj.playAuxSFXAtEntity(this.attackingPlayer, 1015, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                } else {
                    this.currentFlightTarget = new ChunkCoordinates((int)this.posX + this.rand.nextInt(7) - this.rand.nextInt(7), (int)this.posY + this.rand.nextInt(6) - 2, (int)this.posZ + this.rand.nextInt(7) - this.rand.nextInt(7));
                }
            }
            double d0 = (double)this.currentFlightTarget.posX + 0.5 - this.posX;
            double d1 = (double)this.currentFlightTarget.posY + 0.1 - this.posY;
            double d2 = (double)this.currentFlightTarget.posZ + 0.5 - this.posZ;
            this.motionX += (Math.signum(d0) * 0.5 - this.motionX) * (double)0.1f;
            this.motionY += (Math.signum(d1) * (double)0.7f - this.motionY) * (double)0.1f;
            this.motionZ += (Math.signum(d2) * 0.5 - this.motionZ) * (double)0.1f;
            float f = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
            float f1 = MathHelper.wrapAngleTo180_float((float)(f - this.rotationYaw));
            this.moveForward = 0.5f;
            this.rotationYaw += f1;
            if (this.attackingPlayer == null && this.rand.nextInt(100) == 0 && this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), (int)this.posY + 1, MathHelper.floor_double((double)this.posZ)).isNormalCube()) {
                this.setIsBatHanging(true);
            } else if (this.canShock() && this.getShockTime() == 0 && !ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN) && this.attackingPlayer != null && (this.recentlyHit > 0 && this.rand.nextInt(20) == 0 || this.rand.nextInt(300) == 0)) {
                this.setShockTime(this.rand.nextInt(50) + this.worldObj.difficultySetting.getDifficultyId() * (this.rand.nextInt(20) + 10));
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (!this.worldObj.isRemote && this.getIsBatHanging()) {
            this.setIsBatHanging(false);
        }
        if (this.getShockTime() > 0) {
            if (source instanceof EntityDamageSourceIndirect) {
                if (source.isMagicDamage()) {
                    return super.attackEntityFrom(source, amount);
                }
                if (source.isExplosion()) {
                    ZSSEntityInfo.get((EntityLivingBase)this).stun(20 + this.rand.nextInt((int)(amount * 5.0f) + 1));
                    this.setShockTime(0);
                } else if (source instanceof IDamageSourceStun) {
                    this.setShockTime(0);
                }
            } else if (source instanceof EntityDamageSource && source.getEntity() instanceof EntityPlayer && !source.damageType.equals("thorns")) {
                source.getEntity().attackEntityFrom(this.getDamageSource(), this.getDamage());
                this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:shock", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
            }
            return false;
        }
        return super.attackEntityFrom(source, amount);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.swarmSpawned = compound.getBoolean("SpawnedSwarm");
        this.dataWatcher.updateObject(17, (Object)compound.getByte("KeeseType"));
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setBoolean("SpawnedSwarm", this.swarmSpawned);
        compound.setByte("KeeseType", this.dataWatcher.getWatchableObjectByte(17));
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.setTypeOnSpawn();
        return data;
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && (this.posY < 64.0 || this.rand.nextInt(16) > 13) && this.isValidLightLevel() && !this.worldObj.isAnyLiquid(this.boundingBox);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j = MathHelper.floor_double((double)this.boundingBox.minY), k = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        if (this.worldObj.isThundering()) {
            int i1 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            l = this.worldObj.getBlockLightValue(i, j, k);
            this.worldObj.skylightSubtracted = i1;
        }
        return l <= this.rand.nextInt(8);
    }

    public static enum KeeseType {
        NORMAL(8.0f, BiomeType.PLAINS, BiomeType.FOREST),
        FIRE(12.0f, BiomeType.FIERY, BiomeType.JUNGLE),
        ICE(12.0f, BiomeType.COLD, BiomeType.TAIGA),
        THUNDER(12.0f, BiomeType.ARID, BiomeType.BEACH),
        CURSED(16.0f, null, null);

        public final float maxHealth;
        public final BiomeType favoredBiome;
        public final BiomeType secondBiome;

        private KeeseType(float maxHealth, BiomeType favoredBiome, BiomeType secondBiome) {
            this.maxHealth = maxHealth;
            this.favoredBiome = favoredBiome;
            this.secondBiome = secondBiome;
        }
    }
}

