/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ai.EntityAILevitate;
import zeldaswordskills.entity.ai.EntityAIRangedMagic;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;

public class EntityGrandWizzrobe
extends EntityWizzrobe
implements IBossDisplayData {
    private int transformTimer;

    public EntityGrandWizzrobe(World world) {
        super(world);
        this.tasks.addTask(0, (EntityAIBase)new EntityAILevitate((EntityLivingBase)this, 2.5));
        this.targetTasks.taskEntries.clear();
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.func_110163_bv();
        this.setType(this.rand.nextInt(EntityWizzrobe.WizzrobeType.values().length));
        this.setSize(1.0f, 3.0f);
        this.experienceValue = 50;
    }

    @Override
    protected EntityAITeleport getNewTeleportAI() {
        return new EntityAITeleport((EntityCreature)this, 16.0, 60, false, true, true, true, true);
    }

    @Override
    protected EntityAIRangedMagic getMagicAI() {
        return new EntityAIRangedMagic(this, 10, 40, 24.0);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(300.0);
    }

    @Override
    protected void applyTypeTraits() {
        super.applyTypeTraits();
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
    }

    protected boolean canDespawn() {
        return false;
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + this.worldObj.difficultySetting.getDifficultyId() * 4;
    }

    @Override
    protected float getTelevadeChance() {
        return 1.0f;
    }

    @Override
    protected int getBaseCastingTime() {
        return 60;
    }

    @Override
    protected float getBaseSpellDamage() {
        return 8.0f;
    }

    @Override
    protected float getSpellAoE() {
        return 2.5f;
    }

    @Override
    protected float getReflectChance() {
        return 1.0f;
    }

    @Override
    protected float getMinInterruptDamage() {
        return 8.0f;
    }

    @Override
    protected float getMaxInterruptDamage() {
        return 32.0f;
    }

    @Override
    public int beginSpellCasting(EntityLivingBase target) {
        if (this.transformTimer > 0) {
            return 0;
        }
        return super.beginSpellCasting(target);
    }

    @Override
    public void castPassiveSpell() {
    }

    @Override
    public void castRangedSpell(EntityLivingBase target, float range) {
        super.castRangedSpell(target, range);
        this.transformTimer = 10;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.transformTimer > 0 && --this.transformTimer == 0 && !this.worldObj.isRemote) {
            this.setType(this.rand.nextInt(EntityWizzrobe.WizzrobeType.values().length));
        }
    }

    protected void dropFewItems(boolean recentlyHit, int lootingLevel) {
        super.dropFewItems(recentlyHit, lootingLevel);
        this.entityDropItem(new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 0.0f);
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return wasItemStolen;
    }
}

