/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ai.IEntityAnimationOffset;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntitySwordBeam;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public abstract class EntityDekuBase
extends EntityCreature
implements IMob,
IEntityAnimationOffset {
    protected static byte flag_index;
    public static final byte CUSTOM_DEATH;
    public int custom_death;
    private final int ticksExistedOffset;

    public EntityDekuBase(World world) {
        super(world);
        this.addAITasks();
        this.setSize(0.75f, 2.0f);
        this.experienceValue = 5;
        this.ticksExistedOffset = this.getTickOffset(world);
    }

    protected int getTickOffset(World world) {
        return world.rand.nextInt(3600);
    }

    @Override
    public int getTicksExistedOffset(int action_id) {
        return this.ticksExistedOffset;
    }

    protected void addAITasks() {
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
    }

    protected String getHurtSound() {
        return "zeldaswordskills:leaf_hit";
    }

    protected String getDeathSound() {
        return "zeldaswordskills:leaf_hit";
    }

    public void addVelocity(double dx, double dy, double dz) {
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean handleWaterMovement() {
        return false;
    }

    public boolean handleLavaMovement() {
        return false;
    }

    public boolean isReallyInLava() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.lava);
    }

    public void setSprinting(boolean sprinting) {
    }

    protected void jump() {
    }

    public void fall(float distance) {
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected boolean canAttack() {
        return true;
    }

    public boolean canAttackClass(Class clazz) {
        return !EntityDekuBase.class.isAssignableFrom(clazz) && super.canAttackClass(clazz);
    }

    public boolean canEntityBeSeen(Entity entity) {
        Vec3 end;
        Vec3 start = Vec3.createVectorHelper((double)this.posX, (double)(this.posY + (double)this.getEyeHeight()), (double)this.posZ);
        return this.worldObj.func_147447_a(start, end = Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), false, true, false) == null;
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        if (!this.canAttack()) {
            return false;
        }
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return flag;
    }

    protected boolean isSourceFatal(DamageSource source) {
        if (source.getSourceOfDamage() instanceof EntityBoomerang) {
            return true;
        }
        if (source.getEntity() instanceof EntityPlayer) {
            return ZSSPlayerSkills.get((EntityPlayer)source.getEntity()).isSkillActive(SkillBase.spinAttack);
        }
        return source.isExplosion() && ZSSEntityInfo.get((EntityLivingBase)this).hasIngestedBomb();
    }

    protected boolean isSlashing(DamageSource source) {
        if (source.getSourceOfDamage() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)source.getSourceOfDamage();
            if (PlayerUtils.isSword(entity.getHeldItem())) {
                return true;
            }
        } else if (source.isProjectile()) {
            return source.getSourceOfDamage() instanceof EntityBoomerang || source.getSourceOfDamage() instanceof EntitySwordBeam;
        }
        return false;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.isReallyInLava()) {
            this.setOnFireFromLava();
        }
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
    }

    public void onDeath(DamageSource source) {
        byte flag;
        super.onDeath(source);
        if (!this.worldObj.isRemote && (flag = this.getCustomDeathFlag(source)) != 0) {
            this.worldObj.setEntityState((Entity)this, flag);
        }
    }

    protected byte getCustomDeathFlag(DamageSource source) {
        return this.isSlashing(source) ? CUSTOM_DEATH : (byte)0;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        if (flag == CUSTOM_DEATH) {
            this.custom_death = this.rand.nextInt(2) == 0 ? -1 : 1;
        } else {
            super.handleHealthUpdate(flag);
        }
    }

    protected Item getDropItem() {
        return Items.stick;
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (!this.isValidSpawnBlock() || !this.isValidLightLevel()) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    protected boolean isValidSpawnBlock() {
        int i = MathHelper.floor_double((double)this.posX);
        int j = MathHelper.floor_double((double)this.boundingBox.minY);
        int k = MathHelper.floor_double((double)this.posZ);
        return this.isValidMaterial(this.worldObj.getBlock(i, j - 1, k).getMaterial());
    }

    protected boolean isValidMaterial(Material material) {
        return material == Material.grass || material == Material.ground || material == Material.clay || material == Material.sand;
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j = MathHelper.floor_double((double)this.boundingBox.minY), k = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int light = this.worldObj.getBlockLightValue(i, j, k);
        if (this.worldObj.isThundering()) {
            int sky = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            light = this.worldObj.getBlockLightValue(i, j, k);
            this.worldObj.skylightSubtracted = sky;
        }
        return light <= this.rand.nextInt(8);
    }

    static {
        byte by = flag_index = (byte)10;
        flag_index = (byte)(by + 1);
        CUSTOM_DEATH = by;
    }
}

