/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.api.entity.IEntityCustomTarget;
import zeldaswordskills.api.entity.ai.EntityAIDynamicAction;
import zeldaswordskills.api.entity.ai.EntityAIDynamicProne;
import zeldaswordskills.api.entity.ai.EntityAITargetBombs;
import zeldaswordskills.api.entity.ai.EntityAction;
import zeldaswordskills.api.entity.ai.IEntityDynamic;
import zeldaswordskills.api.entity.ai.IEntityDynamicAI;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.mobs.EntityDekuBase;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class EntityDekuBaba
extends EntityDekuBase
implements IEntityBombEater,
IEntityDynamic,
IEntityCustomTarget {
    public static final byte BOMB_INGESTED;
    public static final EntityAction ACTION_SPROUT;
    public static final EntityAction ACTION_READY;
    public static final EntityAction ACTION_ATTACK;
    public static final EntityAction ACTION_BOMB;
    public static final EntityAction ACTION_PRONE;
    private static final Map<Integer, EntityAction> actionMap;
    public static final int ALERTNESS_INDEX = 17;
    public static final int TARGET_INDEX = 18;
    public static final int CUSTOM_TARGET_INDEX = 19;
    public static final int DIFFICULTY_INDEX = 20;
    public static final int STATUS_INDEX = 21;
    public static final int STATUS_BOMB = 1;
    public static final int STATUS_CONFUSED = 2;
    public static final int MAX_ALERTNESS = 50;
    public static final int FUSE_TIME = 20;
    protected EntityAction action = ACTION_READY;
    protected final List<EntityAction> actionList = new ArrayList<EntityAction>();
    protected int action_timer;
    protected boolean prone;
    protected int status_timer;
    protected Entity target;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(null, BiomeType.FOREST, BiomeType.JUNGLE, BiomeType.PLAINS, BiomeType.RIVER);
    }

    protected static void registerAction(EntityAction action) {
        actionMap.put(action.id, action);
    }

    public EntityDekuBaba(World world) {
        super(world);
        this.actionList.add(this.action);
    }

    @Override
    protected void addAITasks() {
        this.tasks.addTask(1, (EntityAIBase)new EntityAIDynamicProne(this, ACTION_PRONE, 63));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIDynamicAction(this, ACTION_ATTACK, 4.0f, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITargetBombs(this, ACTION_BOMB, 3.0f, true));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)-1);
        this.dataWatcher.addObject(19, (Object)-1);
        this.dataWatcher.addObject(20, (Object)this.worldObj.difficultySetting.getDifficultyId());
        this.dataWatcher.addObject(21, (Object)0);
    }

    protected String getLivingSound() {
        return this.isFullyAlert() ? "step.grass" : null;
    }

    protected float getSoundVolume() {
        return 0.75f + this.rand.nextFloat() * 0.25f;
    }

    protected float getSoundPitch() {
        return 0.5f;
    }

    protected int getAlertness() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public boolean isFullyAlert() {
        return this.isEntityAlive() && this.getActionTime(EntityDekuBaba.ACTION_SPROUT.id) > ACTION_SPROUT.getDuration(this.getActionSpeed(EntityDekuBaba.ACTION_SPROUT.id));
    }

    protected boolean isAIEnabled() {
        return true;
    }

    private void updateAlertness() {
        int modified;
        int i;
        if (this.action == ACTION_PRONE) {
            return;
        }
        int alertness = this.getAlertness();
        int n = i = this.getCurrentTarget() == null ? -1 : 1;
        if (this.getCurrentTarget() != null && !this.canEntityBeSeen(this.getCurrentTarget())) {
            int n2 = i = this.rand.nextInt(4) == 0 ? -1 : 0;
        }
        if ((modified = MathHelper.clamp_int((int)(alertness + i), (int)0, (int)50)) != alertness) {
            this.dataWatcher.updateObject(17, (Object)modified);
        }
    }

    public boolean isConfused() {
        return this.dataWatcher.getWatchableObjectInt(21) == 2;
    }

    public void setConfused(boolean confused) {
        this.dataWatcher.updateObject(21, (Object)(confused ? 2 : 0));
        this.status_timer = confused && this.status_timer == 0 ? this.rand.nextInt(80) + this.rand.nextInt(80) + 142 : 0;
    }

    public boolean isAttack(int action_id) {
        return action_id == EntityDekuBaba.ACTION_ATTACK.id || action_id == EntityDekuBaba.ACTION_BOMB.id;
    }

    @Override
    public List<EntityAction> getActiveActions() {
        return this.actionList;
    }

    @Override
    public int getActionTime(int action_id) {
        if (action_id == EntityDekuBaba.ACTION_SPROUT.id) {
            return this.getAlertness();
        }
        EntityAction a = this.getActionById(action_id);
        if (a == this.action && this.action_timer > 0) {
            return a.getDuration(this.getActionSpeed(action_id)) - this.action_timer;
        }
        return 0;
    }

    @Override
    public float getActionSpeed(int action_id) {
        int i = this.getDifficultyModifier() - 2;
        if (this.isAttack(action_id)) {
            return 0.7f + (float)i * 0.15f;
        }
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            return 1.0f + (float)i * 0.25f;
        }
        return 1.0f;
    }

    @Override
    public boolean canExecute(int action_id, IEntityDynamicAI ai) {
        if (this.isAttack(action_id)) {
            Entity entity = this.getCurrentTarget();
            return this.action_timer == 0 && entity != null && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, entity, 15.0f);
        }
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            return this.prone;
        }
        return true;
    }

    @Override
    public void beginAction(int action_id, IEntityDynamicAI ai) {
        if (this.isAttack(action_id)) {
            this.playLivingSound();
        }
        this.setActionState(action_id);
    }

    @Override
    public void endAction(int action_id, IEntityDynamicAI ai) {
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            this.prone = false;
        }
        if (action_id == this.action.id) {
            this.setActionState(EntityDekuBaba.ACTION_READY.id);
        }
    }

    @Override
    public void performAction(int action_id, IEntityDynamicAI ai) {
        Entity target = this.getCurrentTarget();
        if (!this.isConfused()) {
            if (action_id == EntityDekuBaba.ACTION_ATTACK.id) {
                if (target instanceof EntityLivingBase && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, target, 15.0f)) {
                    this.attackEntityAsMob(target);
                }
            } else if (action_id == EntityDekuBaba.ACTION_BOMB.id && target instanceof IEntityBombIngestible && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, target, 15.0f)) {
                IEntityBombIngestible bomb = (IEntityBombIngestible)this.getCurrentTarget();
                if (ZSSEntityInfo.get((EntityLivingBase)this).onBombIngested(bomb)) {
                    this.dataWatcher.updateObject(21, (Object)1);
                    this.worldObj.setEntityState((Entity)this, BOMB_INGESTED);
                    double damage = this.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.attackDamage).getAttributeValue();
                    bomb.setExplosionDamage((float)damage * (float)this.worldObj.difficultySetting.getDifficultyId());
                    bomb.setFuseTime(20);
                    ZSSEntityInfo.get((EntityLivingBase)this).refreshFuseTime();
                }
            }
        }
    }

    public int getDifficultyModifier() {
        return this.dataWatcher.getWatchableObjectInt(20);
    }

    public int getBombTimer() {
        return this.status_timer > 0 && this.dataWatcher.getWatchableObjectInt(21) == 1 ? 20 - this.status_timer : 0;
    }

    @Override
    public Event.Result ingestBomb(IEntityBombIngestible bomb) {
        return Event.Result.DENY;
    }

    @Override
    public boolean onBombIndigestion(IEntityBombIngestible bomb) {
        this.prone = true;
        return true;
    }

    @Override
    public boolean doesIngestedBombExplode(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean isIngestedBombFatal(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public Entity getCurrentTarget() {
        Entity entity = this.getCustomTarget();
        if (entity == null) {
            entity = this.getAttackTarget();
        }
        return entity;
    }

    @Override
    public Entity getCustomTarget() {
        if (this.target == null && this.dataWatcher.getWatchableObjectInt(19) > -1) {
            this.target = this.worldObj.getEntityByID(this.dataWatcher.getWatchableObjectInt(19));
            if (this.target == null) {
                this.dataWatcher.updateObject(19, (Object)-1);
            }
        }
        return this.target;
    }

    @Override
    public void setCustomTarget(Entity entity) {
        this.target = entity;
        this.dataWatcher.updateObject(19, (Object)(entity == null ? -1 : entity.getEntityId()));
    }

    public EntityLivingBase getAttackTarget() {
        if (super.getAttackTarget() == null && this.dataWatcher.getWatchableObjectInt(18) > -1) {
            Entity target = this.worldObj.getEntityByID(this.dataWatcher.getWatchableObjectInt(18));
            if (target instanceof EntityLivingBase) {
                this.setAttackTarget((EntityLivingBase)target);
            } else {
                this.dataWatcher.updateObject(18, (Object)-1);
            }
        }
        return super.getAttackTarget();
    }

    public void setAttackTarget(EntityLivingBase entity) {
        super.setAttackTarget(entity);
        this.dataWatcher.updateObject(18, (Object)(entity == null ? -1 : entity.getEntityId()));
    }

    @Override
    protected boolean canAttack() {
        return this.isFullyAlert() && this.action != ACTION_PRONE;
    }

    @Override
    public boolean attackEntityAsMob(Entity entity) {
        EntityPlayer player;
        boolean blocking = false;
        if (entity instanceof EntityPlayer && PlayerUtils.isBlocking(player = (EntityPlayer)entity) && PlayerUtils.isShield(player.getHeldItem())) {
            blocking = true;
        }
        boolean flag = super.attackEntityAsMob(entity);
        if (blocking) {
            this.prone = true;
        }
        return flag;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.isFullyAlert() && source.getSourceOfDamage() != null) {
            return false;
        }
        if (this.isSourceFatal(source)) {
            this.prone ^= !this.isAttack(this.action.id);
            return super.attackEntityFrom(source, this.getMaxHealth());
        }
        if (this.prone) {
            if (super.attackEntityFrom(source, this.getSlashDamage(source, amount))) {
                this.onProneAttack(source, amount);
                return true;
            }
            return false;
        }
        if (this.didAttackCauseProne(source, amount)) {
            return true;
        }
        if (this.isDamageEffective(source)) {
            return super.attackEntityFrom(source, amount);
        }
        return false;
    }

    protected void onProneAttack(DamageSource source, float amount) {
        if (this.getHealth() > 0.0f) {
            this.setActionState(EntityDekuBaba.ACTION_READY.id);
            this.action_timer = 10;
        }
    }

    protected boolean didAttackCauseProne(DamageSource source, float amount) {
        boolean flag = false;
        if (this.prone || amount < 0.5f || source.getEntity() == null) {
            return false;
        }
        if (source.isExplosion()) {
            flag = super.attackEntityFrom(source, Math.max(0.5f, amount * 0.25f));
        } else if (source instanceof IPostDamageEffect && ((IPostDamageEffect)source).getDuration(EnumDamageType.STUN) > 0) {
            amount = Math.max(amount * 0.25f, 0.5f);
            flag = super.attackEntityFrom(source, amount);
        } else if (this.isAttack(this.action.id) && this.getActionTime(this.action.id) > this.worldObj.difficultySetting.getDifficultyId()) {
            flag = super.attackEntityFrom(source, this.getSlashDamage(source, amount));
        }
        if (flag && this.getHealth() > 0.0f) {
            if (!this.isConfused() && source.getSourceOfDamage() instanceof EntityPlayer && ((EntityPlayer)source.getSourceOfDamage()).getHeldItem() == null) {
                this.setConfused(true);
            } else {
                this.setConfused(false);
                this.prone = true;
            }
        }
        return flag;
    }

    protected float getSlashDamage(DamageSource source, float amount) {
        return this.isSlashing(source) ? (this.prone ? this.getMaxHealth() : this.getMaxHealth() / 2.0f) : amount;
    }

    protected boolean isDamageEffective(DamageSource source) {
        return source.isFireDamage() || source.isExplosion() || source.isMagicDamage() || source == DamageSource.inWall || source == DamageSource.outOfWorld;
    }

    protected boolean isTargetValid(EntityLivingBase entity) {
        if (!entity.isEntityAlive()) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.disableDamage) {
            return false;
        }
        return entity.getDistanceSqToEntity((Entity)this) < 100.0;
    }

    @Override
    public void onUpdate() {
        Entity target;
        super.onUpdate();
        if (!this.isEntityAlive()) {
            return;
        }
        if (this.target != null && !this.target.isEntityAlive()) {
            this.setCustomTarget(null);
        }
        if (this.getAttackTarget() != null && !this.isTargetValid(this.getAttackTarget())) {
            this.setAttackTarget(null);
        }
        this.updateAlertness();
        if (!this.worldObj.isRemote) {
            if (this.worldObj.difficultySetting.getDifficultyId() != this.getDifficultyModifier()) {
                this.dataWatcher.updateObject(20, (Object)this.worldObj.difficultySetting.getDifficultyId());
            }
        } else if (this.isConfused() && this.ticksExisted % 10 == 0) {
            Vec3 look = this.getLookVec();
            for (int i = 0; i < 1; ++i) {
                this.worldObj.spawnParticle("spell", this.posX - look.xCoord * 0.5 + 0.1 * this.rand.nextGaussian(), this.boundingBox.maxY + 0.25 + 0.15 * this.rand.nextGaussian(), this.posZ - look.zCoord * 0.5 + 0.1 * this.rand.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
        if (this.status_timer > 0) {
            --this.status_timer;
            if (this.status_timer == 0 && !this.worldObj.isRemote) {
                this.dataWatcher.updateObject(21, (Object)0);
            }
        }
        if (this.action_timer > 0 && this.isEntityAlive()) {
            --this.action_timer;
            if (this.action_timer == 0) {
                this.setActionState(EntityDekuBaba.ACTION_READY.id);
            }
        }
        if (this.getActionTime(EntityDekuBaba.ACTION_SPROUT.id) > ACTION_SPROUT.getActionFrame(1.0f) && (target = this.getCurrentTarget()) != null && this.action != ACTION_PRONE) {
            this.getLookHelper().setLookPositionWithEntity(target, 30.0f, 30.0f);
            double dx = target.posX - this.posX;
            double dz = target.posZ - this.posZ;
            double dy = target.posY - (double)MathHelper.floor_double((double)(this.boundingBox.minY + 0.5));
            double d = dx * dx + dy * dy + dz * dz;
            if (d >= 2.500000277905201E-7) {
                float f = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                this.rotationYaw = this.limitAngle(this.rotationYaw, f, 30.0f);
            }
        }
    }

    @Override
    protected byte getCustomDeathFlag(DamageSource source) {
        if (this.prone || this.isSourceFatal(source)) {
            return super.getCustomDeathFlag(source);
        }
        return 0;
    }

    private float limitAngle(float angle, float target, float max) {
        target = MathHelper.clamp_float((float)MathHelper.wrapAngleTo180_float((float)(target - angle)), (float)(-max), (float)max);
        return angle + target;
    }

    public EntityAction getActionById(int id) {
        return actionMap.get(id);
    }

    protected boolean setActionState(int id) {
        EntityAction a = this.getActionById(id);
        if (a != null) {
            this.action = a;
            this.prone = this.action == ACTION_PRONE;
            this.action_timer = this.action.getDuration(this.getActionSpeed(this.action.id));
            if (!this.worldObj.isRemote) {
                this.worldObj.setEntityState((Entity)this, (byte)this.action.id);
            }
            this.actionList.set(0, this.action);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        if (flag == BOMB_INGESTED) {
            this.status_timer = 20;
        } else if (!this.setActionState(flag)) {
            super.handleHealthUpdate(flag);
        }
    }

    @Override
    protected Item getDropItem() {
        return this.prone ? Items.stick : ZSSItems.dekuNut;
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("statusIndex", this.dataWatcher.getWatchableObjectInt(21));
        compound.setInteger("statusTimer", this.status_timer);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.dataWatcher.updateObject(21, (Object)compound.getInteger("statusIndex"));
        this.status_timer = compound.getInteger("statusTimer");
    }

    static {
        byte by = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by + 1);
        BOMB_INGESTED = by;
        byte by2 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by2 + 1);
        ACTION_SPROUT = new EntityAction(by2, 11, 5);
        byte by3 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by3 + 1);
        ACTION_READY = new EntityAction(by3, 0, 5);
        byte by4 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by4 + 1);
        ACTION_ATTACK = new EntityAction(by4, 16, 7);
        byte by5 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by5 + 1);
        ACTION_BOMB = new EntityAction(by5, EntityDekuBaba.ACTION_ATTACK.duration, EntityDekuBaba.ACTION_ATTACK.action_frame);
        byte by6 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by6 + 1);
        ACTION_PRONE = new EntityAction(by6, 60, 0);
        actionMap = new HashMap<Integer, EntityAction>();
        EntityDekuBaba.registerAction(ACTION_SPROUT);
        EntityDekuBaba.registerAction(ACTION_READY);
        EntityDekuBaba.registerAction(ACTION_ATTACK);
        EntityDekuBaba.registerAction(ACTION_BOMB);
        EntityDekuBaba.registerAction(ACTION_PRONE);
    }
}

