/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.IDamageAoE;
import zeldaswordskills.api.entity.IEntityBackslice;
import zeldaswordskills.api.entity.IEntityEvil;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ai.EntityAIPowerAttack;
import zeldaswordskills.entity.ai.IPowerAttacker;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityDarknut
extends EntityMob
implements IEntityBackslice,
IEntityEvil,
IEntityLootable,
IParryModifier,
IPowerAttacker,
IEntityVariant {
    private static final UUID armorKnockbackModifierUUID = UUID.fromString("71AF0F88-82E5-49DE-B9CC-844048E33D69");
    private static final AttributeModifier armorKnockbackModifier = new AttributeModifier(armorKnockbackModifierUUID, "Armor Knockback Resistance", 1.0, 0).setSaved(false);
    private static final UUID armorMoveBonusUUID = UUID.fromString("B6C8CCB6-AE7B-4F14-908A-2F41BDB4D720");
    private static final AttributeModifier armorMoveBonus = new AttributeModifier(armorMoveBonusUUID, "Armor Movement Bonus", 0.35, 1).setSaved(false);
    private final EntityAIPowerAttack powerAttackAI = this.getNewPowerAttackAI();
    private static final byte ATTACK_FLAG = 5;
    private static final byte POWER_UP_FLAG = 6;
    private static final byte POWER_ATTACK_FLAG = 7;
    private static final byte PARRY_FLAG = 8;
    private static final byte SPIN_FLAG = 9;
    private static final int TYPE_INDEX = 16;
    private static final int ARMOR_INDEX = 17;
    private static final int CAPE_INDEX = 18;
    @SideOnly(value=Side.CLIENT)
    public int attackTimer;
    @SideOnly(value=Side.CLIENT)
    public int chargeTimer;
    @SideOnly(value=Side.CLIENT)
    public boolean isPowerAttack;
    public int parryTimer;
    private int recentHitTimer;
    private int recentHits;
    private int spinAttackTimer;
    private List<EntityLivingBase> targets;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(null, BiomeType.ARID, BiomeType.BEACH, BiomeType.FIERY, BiomeType.MOUNTAIN, BiomeType.PLAINS);
    }

    public EntityDarknut(World world) {
        super(world);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(1.0f, 3.0f);
        this.experienceValue = 12;
    }

    protected EntityAIPowerAttack getNewPowerAttackAI() {
        return new EntityAIPowerAttack(this, 4.0);
    }

    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)Float.valueOf(20.0f));
        this.dataWatcher.addObject(18, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.225);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
    }

    public int getType() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    @Override
    public EntityDarknut setType(int type) {
        this.dataWatcher.updateObject(16, (Object)((byte)type));
        this.setWearingCape(type > 0 ? (byte)60 : 0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(type > 0 ? 100.0 : 50.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(type > 0 ? 7.0 : 5.0);
        this.setHealth(this.getMaxHealth());
        this.experienceValue = type > 0 ? 20 : 12;
        return this;
    }

    protected float getArmorDamage() {
        return this.dataWatcher.getWatchableObjectFloat(17);
    }

    protected void setArmorDamage(float value) {
        this.dataWatcher.updateObject(17, (Object)Float.valueOf(value));
    }

    public boolean isArmored() {
        return this.getArmorDamage() > 0.0f;
    }

    public boolean isSpinning() {
        return this.spinAttackTimer > 0;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return "zeldaswordskills:armor_move";
    }

    protected String getHurtSound() {
        return "zeldaswordskills:armor_hit";
    }

    protected String getDeathSound() {
        return "zeldaswordskills:armor_die";
    }

    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.swordDarknut));
        this.setCurrentItemOrArmor(3, new ItemStack((Item)Items.iron_chestplate));
        this.applyArmorAttributeModifiers(true);
    }

    private void applyArmorAttributeModifiers(boolean wearingArmor) {
        IAttributeInstance moveAttribute = this.getEntityAttribute(SharedMonsterAttributes.movementSpeed);
        moveAttribute.removeModifier(armorMoveBonus);
        IAttributeInstance knockbackAttribute = this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance);
        knockbackAttribute.removeModifier(armorKnockbackModifier);
        this.tasks.removeTask((EntityAIBase)this.powerAttackAI);
        if (wearingArmor) {
            this.tasks.addTask(1, (EntityAIBase)this.powerAttackAI);
            knockbackAttribute.applyModifier(armorKnockbackModifier);
        } else {
            moveAttribute.applyModifier(armorMoveBonus);
        }
    }

    public int getTotalArmorValue() {
        return Math.min(20, super.getTotalArmorValue() + 2 * this.worldObj.difficultySetting.getDifficultyId());
    }

    public boolean isWearingCape() {
        return this.dataWatcher.getWatchableObjectByte(18) > 0;
    }

    protected void setWearingCape(byte ticksRequired) {
        this.dataWatcher.updateObject(18, (Object)ticksRequired);
    }

    private void damageCape() {
        byte b = this.dataWatcher.getWatchableObjectByte(18);
        if (b > 0) {
            this.setWearingCape((byte)(b - 1));
            if (b == 1) {
                this.extinguish();
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        boolean isPlayer = source.getEntity() instanceof EntityPlayer;
        if (this.isEntityInvulnerable() || this.isSpinning()) {
            return false;
        }
        if (source == DamageSource.inWall && this.ticksExisted > 10) {
            this.breakEnclosingBlocks();
        } else {
            if (source.isUnblockable() || isPlayer && ZSSPlayerSkills.get((EntityPlayer)source.getEntity()).isSkillActive(SkillBase.armorBreak)) {
                if (this.parryAttack(source)) {
                    return false;
                }
                return super.attackEntityFrom(source, amount);
            }
            if (source.getEntity() == null || source.isMagicDamage()) {
                if (this.isArmored() && (source == DamageSource.cactus || source == DamageSource.fallingBlock)) {
                    return false;
                }
                return super.attackEntityFrom(source, amount);
            }
            if (this.isWearingCape()) {
                if (source.isFireDamage()) {
                    this.setFire(3);
                }
                return false;
            }
            if (source.isExplosion() && this.isArmored()) {
                if ((amount = this.damageDarknutArmor(amount * (1.25f - 0.25f * (float)this.worldObj.difficultySetting.getDifficultyId()))) < 0.5f) {
                    return false;
                }
            } else if (!this.worldObj.isRemote) {
                if (this.isArmored()) {
                    if (TargetUtils.isTargetInFrontOf((Entity)this, source.getEntity(), 120.0f)) {
                        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                        return false;
                    }
                    if (isPlayer && ZSSPlayerSkills.get((EntityPlayer)source.getEntity()).isSkillActive(SkillBase.backSlice)) {
                        return super.attackEntityFrom(source, amount);
                    }
                    if (amount > (float)this.worldObj.difficultySetting.getDifficultyId() * 2.0f) {
                        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
                        this.damageDarknutArmor(amount * 0.5f);
                    }
                    return false;
                }
                if (this.parryAttack(source)) {
                    return false;
                }
                if (this.recentHitTimer > 0) {
                    if (++this.recentHits > 3 && this.rand.nextFloat() < 0.15f * (float)this.recentHits) {
                        this.playLivingSound();
                        this.worldObj.playSoundAtEntity((Entity)this, "zeldaswordskills:spinattack", 1.0f, this.rand.nextFloat() * 0.4f + 0.5f);
                        this.worldObj.setEntityState((Entity)this, (byte)9);
                        this.spinAttackTimer = 12;
                        this.recentHits = 0;
                        this.targets = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.expand(4.0, 0.0, 4.0));
                        if (this.targets.contains(this)) {
                            this.targets.remove(this);
                        }
                    }
                } else {
                    this.recentHits = 1;
                }
                this.recentHitTimer = 60;
            }
        }
        return super.attackEntityFrom(source, amount);
    }

    protected void breakEnclosingBlocks() {
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)(this.posY + (double)this.getEyeHeight()));
        int z = MathHelper.floor_double((double)this.posZ);
        boolean flag = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = k + z;
                    Block block = this.worldObj.getBlock(dx, dy, dz);
                    float hardness = block.getBlockHardness(this.worldObj, dx, dy, dz);
                    if (!block.isNormalCube() || !(hardness >= 0.0f) || !(hardness < 20.0f) || !block.canEntityDestroy((IBlockAccess)this.worldObj, dx, dy, dz, (Entity)this)) continue;
                    flag = true;
                    if (this.worldObj.isRemote) continue;
                    this.worldObj.func_147480_a(dx, dy, dz, true);
                }
            }
        }
        if (flag) {
            this.swingItem();
            this.attackTime = 20;
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
        }
    }

    protected boolean parryAttack(DamageSource source) {
        Entity entity = source.getEntity();
        if (entity == null || source.isExplosion() || source instanceof IDamageAoE && ((IDamageAoE)source).isAoEDamage()) {
            return false;
        }
        if (TargetUtils.isTargetInFrontOf((Entity)this, entity, 90.0f) && this.rand.nextFloat() < 0.5f - (float)this.parryTimer * 0.05f) {
            this.worldObj.setEntityState((Entity)this, (byte)8);
            this.parryTimer = 10;
            super.swingItem();
            this.attackTime = Math.max(this.attackTime, 5);
            if (entity instanceof EntityLivingBase && !source.isProjectile()) {
                EntityLivingBase attacker = (EntityLivingBase)entity;
                if (attacker.getHeldItem() != null) {
                    WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                    float disarmChance = Parry.getDisarmModifier((EntityLivingBase)this, attacker);
                    if (this.rand.nextFloat() < disarmChance) {
                        WorldUtils.dropHeldItem(attacker);
                    }
                }
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.1f * (float)this.worldObj.difficultySetting.getDifficultyId();
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.1f * (float)this.worldObj.difficultySetting.getDifficultyId();
    }

    protected float damageDarknutArmor(float amount) {
        float armorDamage = this.getArmorDamage();
        float f = amount - armorDamage;
        if ((armorDamage -= amount) < 0.1f) {
            armorDamage = 0.0f;
            this.onArmorDestroyed();
        }
        this.setArmorDamage(armorDamage);
        return f > 0.0f ? f : 0.0f;
    }

    protected void onArmorDestroyed() {
        if (this.getType() > 0) {
            this.setCurrentItemOrArmor(3, new ItemStack((Item)Items.chainmail_chestplate));
        } else {
            this.setCurrentItemOrArmor(3, null);
        }
        this.applyArmorAttributeModifiers(false);
    }

    public boolean attackEntityAsMob(Entity entity) {
        if (this.attackTime <= 0) {
            this.attackTime = 20;
            this.worldObj.setEntityState((Entity)this, (byte)5);
            if (TargetUtils.isTargetInFrontOf((Entity)this, entity, 60.0f) && this.attackEntity(entity, 5)) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                return true;
            }
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        }
        return false;
    }

    protected boolean attackEntity(Entity entity, int flag) {
        int k;
        float damage = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int n = k = flag == 7 || flag == 9 ? 1 : 0;
        if (entity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            k += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (entity.attackEntityFrom(this.getDamageSource(flag), damage)) {
            int j;
            if (k > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)k * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)k * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLightArrowFatal() {
        return true;
    }

    @Override
    public float getLightArrowDamage(float amount) {
        return 0.0f;
    }

    protected DamageSource getDamageSource(int flag) {
        switch (flag) {
            case 7: {
                return DamageSource.causeMobDamage((EntityLivingBase)this).setDamageBypassesArmor();
            }
        }
        return DamageSource.causeMobDamage((EntityLivingBase)this);
    }

    @Override
    public boolean allowDamageMultiplier(EntityPlayer player) {
        return this.getArmorDamage() < 0.1f;
    }

    @Override
    public boolean allowDisarmorment(EntityPlayer player, float damage) {
        return this.getArmorDamage() < 0.1f;
    }

    @Override
    public float onBackSliced(EntityPlayer attacker, int level, float damage) {
        if (this.isArmored()) {
            this.damageDarknutArmor(this.getDamageArmorAmount());
            if (!this.isArmored()) {
                attacker.triggerAchievement((StatBase)ZSSAchievements.orcaCanOpener);
            }
            return 0.0f;
        }
        return damage;
    }

    protected float getDamageArmorAmount() {
        return this.getArmorDamage();
    }

    @Override
    public void beginPowerAttack() {
        this.attackTime = this.getChargeTime();
        this.worldObj.setEntityState((Entity)this, (byte)6);
    }

    @Override
    public void cancelPowerAttack() {
        this.worldObj.setEntityState((Entity)this, (byte)6);
    }

    @Override
    public int getChargeTime() {
        return 28 - this.worldObj.difficultySetting.getDifficultyId() * 5;
    }

    @Override
    public void performPowerAttack(EntityLivingBase target) {
        this.worldObj.setEntityState((Entity)this, (byte)7);
        this.attackTime = 20;
        if (TargetUtils.isTargetInFrontOf((Entity)this, (Entity)target, 60.0f) && this.attackEntity((Entity)target, 7)) {
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
        } else {
            this.onAttackMissed();
        }
    }

    @Override
    public void onAttackMissed() {
        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
    }

    public void swingItem() {
    }

    protected void updateAITasks() {
        if (this.spinAttackTimer > 0) {
            ++this.entityAge;
        } else {
            super.updateAITasks();
        }
    }

    public void onLivingUpdate() {
        if (this.isWearingCape() && this.isBurning()) {
            this.damageCape();
        }
        super.onLivingUpdate();
        if (this.parryTimer > 0) {
            --this.parryTimer;
        }
        if (this.recentHitTimer > 0 && --this.recentHitTimer == 0) {
            this.recentHits = 0;
        }
        if (this.spinAttackTimer > 0) {
            --this.spinAttackTimer;
            if (this.isEntityAlive()) {
                this.rotationYaw += 30.0f;
                while (this.rotationYaw > 360.0f) {
                    this.rotationYaw -= 360.0f;
                }
                while (this.rotationYaw < -360.0f) {
                    this.rotationYaw += 360.0f;
                }
                if (!this.worldObj.isRemote) {
                    List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)this, 5, 1.0);
                    for (EntityLivingBase target : list) {
                        if (this.targets == null || !this.targets.contains(target)) continue;
                        this.attackEntity((Entity)target, 9);
                        this.targets.remove(target);
                    }
                }
            }
        }
        if (this.worldObj.isRemote) {
            if (this.attackTimer > 0) {
                --this.attackTimer;
            } else if (this.attackTimer < 0) {
                ++this.attackTimer;
            }
            if (this.chargeTimer > 0) {
                --this.chargeTimer;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte flag) {
        switch (flag) {
            case 5: {
                this.isPowerAttack = false;
                if (this.attackTimer != 0) break;
                this.attackTimer = this.rand.nextFloat() < 0.5f ? 10 : -10;
                break;
            }
            case 8: {
                this.parryTimer = 10;
                super.swingItem();
                break;
            }
            case 6: {
                this.chargeTimer = this.chargeTimer > 0 ? 0 : this.getChargeTime();
                break;
            }
            case 7: {
                this.isPowerAttack = true;
                this.attackTimer = 7;
                this.chargeTimer = 0;
                break;
            }
            case 9: {
                this.spinAttackTimer = 12;
                break;
            }
            default: {
                super.handleHealthUpdate(flag);
            }
        }
    }

    public void setCurrentItemOrArmor(int slot, ItemStack stack) {
        super.setCurrentItemOrArmor(slot, stack);
        if (!this.worldObj.isRemote && slot == 3 && stack == null && this.getArmorDamage() > 0.0f) {
            this.applyArmorAttributeModifiers(false);
            this.setArmorDamage(0.0f);
        }
    }

    protected void dropFewItems(boolean recentlyHit, int lootingLevel) {
        int n = this.rand.nextInt(Math.max(2, 3 + lootingLevel));
        switch (n) {
            case 0: {
                this.entityDropItem(new ItemStack(Items.flint), 0.0f);
                break;
            }
            case 1: {
                this.entityDropItem(new ItemStack(Items.coal), 0.0f);
                break;
            }
            default: {
                this.entityDropItem(new ItemStack(Items.iron_ingot), 0.0f);
            }
        }
    }

    protected void dropRareDrop(int rarity) {
        switch (rarity) {
            case 1: {
                this.entityDropItem(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.KNIGHTS_CREST.ordinal()), 0.0f);
                break;
            }
            default: {
                this.entityDropItem(new ItemStack(Items.painting), 0.0f);
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return this.getEquipmentInSlot(3) == null ? 0.25f : 0.0f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.KNIGHTS_CREST.ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        if (wasItemStolen) {
            player.triggerAchievement((StatBase)ZSSAchievements.orcaDeknighted);
        }
        return wasItemStolen;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return false;
    }

    public boolean getCanSpawnHere() {
        return super.getCanSpawnHere() && this.worldObj.getTotalWorldTime() > (long)Config.getTimeToSpawnDarknut();
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        data = super.onSpawnWithEgg(data);
        this.addRandomArmor();
        if (this.rand.nextFloat() < 0.05f * (float)this.worldObj.difficultySetting.getDifficultyId()) {
            this.setType(1);
        }
        return data;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("ArmorHealth", this.getArmorDamage());
        compound.setByte("DarknutType", this.dataWatcher.getWatchableObjectByte(16));
        compound.setByte("CapeHealth", this.dataWatcher.getWatchableObjectByte(18));
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setArmorDamage(compound.getFloat("ArmorHealth"));
        this.applyArmorAttributeModifiers(this.isArmored());
        this.dataWatcher.updateObject(16, (Object)compound.getByte("DarknutType"));
        this.dataWatcher.updateObject(18, (Object)compound.getByte("CapeHealth"));
    }
}

