/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.buff;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public enum Buff {
    ATTACK_UP("buff.zss.attack_up", false, 8),
    ATTACK_DOWN("buff.zss.attack_down", true, 8),
    DEFENSE_UP("buff.zss.defense_up", false, 10),
    DEFENSE_DOWN("buff.zss.defense_down", true, 10),
    EVADE_UP("buff.zss.evade_up", false, 9),
    EVADE_DOWN("buff.zss.evade_down", true, 9),
    RESIST_COLD("buff.zss.resist_cold", false, 2),
    RESIST_FIRE("buff.zss.resist_fire", false, 3),
    RESIST_HOLY("buff.zss.resist_holy", false, 7),
    RESIST_MAGIC("buff.zss.resist_magic", false, 4),
    RESIST_SHOCK("buff.zss.resist_shock", false, 5),
    RESIST_STUN("buff.zss.resist_stun", false, 6),
    STUN("buff.zss.stun", true, false, 6, true),
    WEAKNESS_COLD("buff.zss.weakness_cold", true, 2),
    WEAKNESS_FIRE("buff.zss.weakness_fire", true, 3),
    WEAKNESS_HOLY("buff.zss.weakness_holy", true, 7),
    WEAKNESS_MAGIC("buff.zss.weakness_magic", true, 4),
    WEAKNESS_SHOCK("buff.zss.weakness_shock", true, 5),
    WEAKNESS_STUN("buff.zss.weakness_stun", true, 6),
    RESIST_QUAKE("buff.zss.resist_quake", false, 11),
    WEAKNESS_QUAKE("buff.zss.weakness_quake", true, 11),
    UNLIMITED_MAGIC("buff.zss.unlimited_magic", false, false, -1, true);

    public final String unlocalizedName;
    public final boolean isDebuff;
    public final boolean displayArrow;
    public final int iconIndex;
    public final boolean syncNonPlayerEntity;

    private Buff(String name, boolean isDebuff, int index) {
        this(name, isDebuff, true, index);
    }

    private Buff(String name, boolean isDebuff, boolean displayArrow, int index) {
        this(name, isDebuff, displayArrow, index, false);
    }

    private Buff(String name, boolean isDebuff, boolean displayArrow, int index, boolean syncNonPlayerEntity) {
        this.unlocalizedName = name;
        this.isDebuff = isDebuff;
        this.displayArrow = displayArrow;
        this.iconIndex = index;
        this.syncNonPlayerEntity = syncNonPlayerEntity;
    }

    public String getName() {
        return StatCollector.translateToLocal((String)(this.unlocalizedName + ".name"));
    }

    public boolean hasIcon() {
        return this.iconIndex >= 0;
    }

    public void onAdded(EntityLivingBase entity, int amplifier) {
        switch (this) {
            case STUN: {
                if (!(entity instanceof EntityPlayer)) break;
                ((EntityPlayer)entity).clearItemInUse();
                break;
            }
        }
    }

    public void onRemoved(EntityLivingBase entity, int amplifier) {
    }

    public void onUpdate(EntityLivingBase entity, int remainingDuration, int amplifier) {
        switch (this) {
            case STUN: {
                entity.posX = entity.prevPosX - entity.motionX;
                entity.posY = entity.prevPosY - entity.motionY;
                entity.posZ = entity.prevPosZ - entity.motionZ;
                entity.motionZ = 0.0;
                entity.motionY = 0.0;
                entity.motionX = 0.0;
                entity.attackTime = 20;
                if (!(entity instanceof EntityCreature)) break;
                ((EntityCreature)entity).setTarget(null);
                break;
            }
        }
    }
}

