/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;

public class EntityAILevitate
extends EntityAIBase {
    private final EntityLivingBase entity;
    private final double minHeightSq;

    public EntityAILevitate(EntityLivingBase entity, double minHeight) {
        this.entity = entity;
        this.minHeightSq = minHeight * minHeight;
        this.setMutexBits(16);
    }

    public boolean checkHeight() {
        int i;
        int x = MathHelper.floor_double((double)this.entity.posX);
        int y = MathHelper.floor_double((double)this.entity.posY);
        int z = MathHelper.floor_double((double)this.entity.posZ);
        for (i = 0; i < y && !this.entity.worldObj.getBlock(x, y - i, z).getMaterial().isSolid() && !this.entity.worldObj.getBlock(x, y - i, z).getMaterial().isLiquid(); ++i) {
        }
        return this.entity.getDistanceSq((double)x, (double)(y - i + 1), (double)z) < this.minHeightSq;
    }

    public boolean shouldExecute() {
        return this.checkHeight();
    }

    public boolean continueExecuting() {
        return this.checkHeight();
    }

    public void updateTask() {
        this.entity.motionY += this.entity.getEntityAttribute(SharedMonsterAttributes.movementSpeed).getAttributeValue();
    }
}

