/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class EntityNavi
extends EntityFairy
implements IEntityOwnable {
    private static final int OWNER_INDEX = 17;
    private EntityPlayer owner;

    public EntityNavi(World world) {
        super(world);
        this.func_110163_bv();
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
    }

    @Override
    public void setFairyHome(double x, double y, double z) {
        super.setFairyHome(x, y, z);
        this.home = null;
    }

    @Override
    public boolean canDespawn() {
        return false;
    }

    @Override
    protected void collideWithEntity(Entity entity) {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.getOwner() == null && this.ticksExisted > 10) {
                this.setDead();
            } else if (Config.getNaviRange() > 0 && this.ticksExisted % Config.getNaviFrequency() == 0) {
                this.detectDungeons();
            }
        }
    }

    @Override
    protected void updateAITasks() {
        if (this.getOwner() != null && this.ticksExisted % 30 == 0) {
            Vec3 look = this.owner.getLookVec();
            int x = MathHelper.floor_double((double)(this.owner.posX - look.xCoord));
            int y = MathHelper.floor_double((double)(this.owner.posY + (double)this.owner.getEyeHeight()));
            int z = MathHelper.floor_double((double)(this.owner.posZ - look.zCoord));
            this.home = new int[]{x, y + 1, z};
            if (this.owner.getDistanceSqToEntity((Entity)this) > 144.0) {
                this.setLocationAndAngles(this.owner.posX + look.xCoord, this.owner.posY + (double)this.owner.getEyeHeight(), this.owner.posZ + look.zCoord, this.rotationYaw, this.rotationPitch);
            }
        }
        super.updateAITasks();
    }

    public String func_152113_b() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwnerUUID(String uuid) {
        this.dataWatcher.updateObject(17, (Object)uuid);
    }

    public EntityPlayer getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        try {
            UUID uuid = UUID.fromString(this.func_152113_b());
            if (uuid != null) {
                this.owner = this.worldObj.func_152378_a(uuid);
            }
            return this.owner;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
        this.setOwnerUUID(player.getUniqueID().toString());
    }

    private void detectDungeons() {
        int range = Config.getNaviRange();
        double r2 = range * range;
        int r = range + range / 2;
        int ry = MathHelper.ceiling_float_int((float)((float)r / 2.0f));
        int x = MathHelper.floor_double((double)(this.owner.posX + 0.5));
        int y = MathHelper.floor_double((double)(this.owner.posY + (double)this.owner.getEyeHeight()));
        int z = MathHelper.floor_double((double)(this.owner.posZ + 0.5));
        boolean search = true;
        for (int i = x - r; i <= x + r && search; ++i) {
            for (int j = y - ry; j <= y + ry && search; ++j) {
                for (int k = z - r; k <= z + r && search; ++k) {
                    double d;
                    if (!(this.worldObj.getBlock(i, j, k) instanceof BlockSecretStone) || !((d = this.owner.getDistanceSq((double)i + 0.5, (double)j + 0.5, (double)k + 0.5)) <= r2)) continue;
                    float f = (float)(Math.sqrt(d) / (double)r);
                    PlayerUtils.playSound(this.owner, "zeldaswordskills:fairy_laugh", 0.6f - f / 2.0f, 1.0f);
                    search = false;
                }
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        String uuid = this.func_152113_b();
        if (uuid != null && uuid.length() > 0) {
            compound.setString("OwnerUUID", uuid);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        String s;
        super.readEntityFromNBT(compound);
        String string = s = compound.hasKey("OwnerUUID", 8) ? compound.getString("OwnerUUID") : "";
        if (s.length() > 0) {
            this.setOwnerUUID(s);
        }
    }
}

