/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.TargetUtils;

public class EntityFairy
extends EntityAmbientCreature {
    protected ChunkCoordinates currentFlightTarget;
    protected int[] home = null;
    protected boolean canBeBottled = true;

    public EntityFairy(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.isImmuneToFire = true;
    }

    public void setFairyHome(double x, double y, double z) {
        this.setPositionAndUpdate(x, y, z);
        this.home = new int[]{(int)x, (int)y, (int)z};
    }

    public void onReleased() {
        this.canBeBottled = this.home != null;
    }

    public boolean isEntityInvulnerable() {
        return true;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        return false;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public boolean canDespawn() {
        return this.home == null;
    }

    public boolean canBePushed() {
        return false;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    protected String getLivingSound() {
        return "zeldaswordskills:fairy_living";
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(5.0);
    }

    protected void collideWithEntity(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).heal(1.0f);
        }
        if (entity instanceof EntityPlayer) {
            ZSSPlayerInfo.get((EntityPlayer)entity).restoreMagic(0.5f);
        }
    }

    protected boolean interact(EntityPlayer player) {
        ItemStack stack = player.getHeldItem();
        if (this.canBeBottled && stack != null && stack.getItem() == Items.glass_bottle) {
            if (!this.worldObj.isRemote) {
                player.triggerAchievement((StatBase)ZSSAchievements.fairyCatcher);
                ItemStack fairyBottle = new ItemStack(ZSSItems.fairyBottle);
                if (this.hasCustomNameTag()) {
                    fairyBottle.setStackDisplayName(this.getCustomNameTag());
                }
                player.setCurrentItemOrArmor(0, fairyBottle);
                if (stack.stackSize > 1) {
                    stack.splitStack(1);
                    if (!player.inventory.addItemStackToInventory(stack)) {
                        player.worldObj.spawnEntityInWorld((Entity)new EntityItem(player.worldObj, player.posX, player.posY, player.posZ, stack));
                    }
                }
                this.worldObj.playSoundAtEntity((Entity)player, "zeldaswordskills:cork", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.0f));
                this.setDead();
            }
            return true;
        }
        return false;
    }

    public void onUpdate() {
        super.onUpdate();
        this.motionY *= (double)0.6f;
        if (!this.worldObj.isRemote && this.canDespawn()) {
            if (this.worldObj.provider.dimensionId == -1 && this.ticksExisted > 60) {
                this.setDead();
            }
            if (this.worldObj.isDaytime() && TargetUtils.canEntitySeeSky(this.worldObj, (Entity)this)) {
                this.setDead();
            }
        }
    }

    public boolean getCanSpawnHere() {
        return !this.worldObj.isDaytime() && TargetUtils.canEntitySeeSky(this.worldObj, (Entity)this) && super.getCanSpawnHere();
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!(this.currentFlightTarget == null || this.worldObj.isAirBlock(this.currentFlightTarget.posX, this.currentFlightTarget.posY, this.currentFlightTarget.posZ) && this.currentFlightTarget.posY >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.home != null && (this.posY < (double)this.home[1] || this.getDistanceSq(this.home[0], this.home[1], this.home[2]) > 16.0)) {
            this.currentFlightTarget = new ChunkCoordinates(this.home[0], this.home[1], this.home[2]);
        } else if (this.currentFlightTarget == null || this.rand.nextInt(30) == 0 || this.currentFlightTarget.getDistanceSquared((int)this.posX, (int)this.posY, (int)this.posZ) < 4.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.posX + this.rand.nextInt(7) - this.rand.nextInt(7), (int)this.posY + this.rand.nextInt(6) - 2, (int)this.posZ + this.rand.nextInt(7) - this.rand.nextInt(7));
        }
        double d0 = (double)this.currentFlightTarget.posX + 0.5 - this.posX;
        double d1 = (double)this.currentFlightTarget.posY + 0.1 - this.posY;
        double d2 = (double)this.currentFlightTarget.posZ + 0.5 - this.posZ;
        this.motionX += (Math.signum(d0) * 0.5 - this.motionX) * (double)0.1f;
        this.motionY += (Math.signum(d1) * (double)0.7f - this.motionY) * (double)0.1f;
        this.motionZ += (Math.signum(d2) * 0.5 - this.motionZ) * (double)0.1f;
        float f = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
        float f1 = MathHelper.wrapAngleTo180_float((float)(f - this.rotationYaw));
        this.moveForward = 0.5f;
        this.rotationYaw += f1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        int i = super.getBrightnessForRender(par1);
        int j = (i & 0xFF) + 120;
        int k = i >> 16 & 0xFF;
        if (j > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setBoolean("canBeBottled", this.canBeBottled);
        compound.setBoolean("hasHome", this.home != null);
        if (this.home != null) {
            compound.setIntArray("FairyHome", this.home);
        }
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.canBeBottled = compound.getBoolean("canBeBottled");
        if (compound.getBoolean("hasHome")) {
            this.home = compound.getIntArray("FairyHome");
        }
    }
}

