/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;

public class CustomEntityList {
    private static int entitiesAdded = 0;
    public static Map<String, Class<? extends Entity>> stringToClassMapping = new HashMap<String, Class<? extends Entity>>();
    public static Map<Class<? extends Entity>, String> classToStringMapping = new HashMap<Class<? extends Entity>, String>();
    public static Map<Integer, Class<? extends Entity>> IDtoClassMapping = new HashMap<Integer, Class<? extends Entity>>();
    private static Map<Class<? extends Entity>, Integer> classToIDMapping = new HashMap<Class<? extends Entity>, Integer>();
    private static Map<String, Integer> stringToIDMapping = new HashMap<String, Integer>();
    public static HashMap<Class<? extends Entity>, List<Integer>> entityEggs = new LinkedHashMap<Class<? extends Entity>, List<Integer>>();

    public static void addMapping(Class<? extends Entity> oclass, String entityName) {
        int entityID = CustomEntityList.getEntityId(oclass);
        stringToClassMapping.put(entityName, oclass);
        classToStringMapping.put(oclass, entityName);
        IDtoClassMapping.put(entityID, oclass);
        classToIDMapping.put(oclass, entityID);
        stringToIDMapping.put(entityName, entityID);
    }

    public static void addMapping(Class<? extends Entity> oclass, String entityName, Integer ... colors) {
        CustomEntityList.addMapping(oclass, entityName);
        entityEggs.put(oclass, Arrays.asList(colors));
    }

    public static int getEntityId(Class<? extends Entity> oclass) {
        if (classToIDMapping.containsKey(oclass)) {
            return classToIDMapping.get(oclass);
        }
        if (!IDtoClassMapping.containsKey(entitiesAdded)) {
            return entitiesAdded++;
        }
        ZSSMain.logger.warn(String.format("ID Conflict: Entity ID %d already taken while getting ID for entity of class %s", entitiesAdded, oclass));
        while (IDtoClassMapping.containsKey(entitiesAdded)) {
            ++entitiesAdded;
        }
        return entitiesAdded;
    }

    public static Entity createEntityByName(String entityName, World world) {
        return CustomEntityList.createEntity(stringToClassMapping.get(entityName), world);
    }

    public static Entity createEntityFromNBT(NBTTagCompound compound, World world) {
        Entity entity = CustomEntityList.createEntityByName(compound.getString("id"), world);
        if (entity != null) {
            try {
                entity.readFromNBT(compound);
            }
            catch (Exception e) {
                ZSSMain.logger.error(String.format("An Entity %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.getString("id")));
                e.printStackTrace();
                entity = null;
            }
        } else {
            ZSSMain.logger.warn("Skipping Entity with id " + compound.getString("id"));
        }
        return entity;
    }

    public static Entity createEntityByID(int entityID, World world) {
        return CustomEntityList.createEntity(CustomEntityList.getClassFromID(entityID), world);
    }

    public static Entity createEntity(Class<? extends Entity> oclass, World world) {
        Entity entity = null;
        try {
            if (oclass != null) {
                entity = oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        Class<?> oclass = entity.getClass();
        return classToIDMapping.containsKey(oclass) ? classToIDMapping.get(oclass) : 0;
    }

    public static Class<? extends Entity> getClassFromID(int entityID) {
        return IDtoClassMapping.get(entityID);
    }

    public static String getEntityString(Entity entity) {
        return classToStringMapping.get(entity.getClass());
    }

    public static String getStringFromID(int entityID) {
        Class<? extends Entity> oclass = CustomEntityList.getClassFromID(entityID);
        return oclass != null ? classToStringMapping.get(oclass) : null;
    }
}

