/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.command;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.util.PlayerUtils;

public class CommandSetMagic
extends CommandBase {
    public static final ICommand INSTANCE = new CommandSetMagic();

    private CommandSetMagic() {
    }

    public String getCommandName() {
        return "zssmagic";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getCommandUsage(ICommandSender player) {
        return "commands.zssmagic.usage";
    }

    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 4 || !"add".equals(args[1]) && !"set".equals(args[1]) || !"current".equals(args[2]) && !"max".equals(args[2])) {
            throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
        }
        EntityPlayerMP commandSender = CommandBase.getCommandSenderAsPlayer((ICommandSender)sender);
        EntityPlayerMP player = CommandBase.getPlayer((ICommandSender)sender, (String)args[0]);
        ZSSPlayerInfo info = ZSSPlayerInfo.get((EntityPlayer)player);
        boolean max = "max".equals(args[2]);
        boolean add = "add".equals(args[1]);
        int mp = CommandBase.parseInt((ICommandSender)commandSender, (String)args[3]);
        if (mp < 0 && !add) {
            throw new CommandException("commands.zssmagic.negative", new Object[]{args[2]});
        }
        if (add) {
            mp = (int)((float)mp + (max ? info.getMaxMagic() : info.getCurrentMagic()));
        }
        if (max) {
            info.setMaxMagic(mp);
            mp = Math.round(info.getMaxMagic());
        } else {
            info.setCurrentMagic(mp);
            mp = Math.round(info.getCurrentMagic());
        }
        PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.zssmagic.success", player.getCommandSenderName(), args[2], mp);
    }

    public List addTabCompletionOptions(ICommandSender sender, String[] args) {
        switch (args.length) {
            case 1: {
                return CommandBase.getListOfStringsMatchingLastWord((String[])args, (String[])this.getPlayers());
            }
            case 2: {
                return Arrays.asList("add", "set");
            }
            case 3: {
                return Arrays.asList("current", "max");
            }
        }
        return null;
    }

    protected String[] getPlayers() {
        return MinecraftServer.getServer().getAllUsernames();
    }
}

