/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.handler.BattlegearEvents;
import zeldaswordskills.item.ItemHeroBow;

@SideOnly(value=Side.CLIENT)
public class RenderItemCustomBow
implements IItemRenderer {
    private static final ItemStack vanillaArrow = new ItemStack(Items.arrow);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], false);
                break;
            }
        }
    }

    private void renderEquippedBow(ItemStack stack, EntityLivingBase entity, boolean firstPerson) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        if (entity instanceof EntityPlayer) {
            if (!firstPerson) {
                GL11.glRotated((double)15.0, (double)0.02, (double)0.01, (double)0.0);
                GL11.glTranslated((double)0.1, (double)-0.3, (double)0.2);
            }
            EntityPlayer player = (EntityPlayer)entity;
            IIcon icon = stack.getItem().getIcon(stack, 0, player, player.getItemInUse(), player.getItemInUseCount());
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
            int useDuration = player.getItemInUseDuration();
            if (useDuration > 0) {
                ItemStack quiverArrow;
                ItemStack arrowStack;
                int drawAmount = useDuration > 17 ? 2 : (useDuration > 13 ? 1 : 0);
                ItemStack itemStack = arrowStack = stack.getItem() instanceof ItemHeroBow ? ((ItemHeroBow)stack.getItem()).getArrow(player) : vanillaArrow;
                if (ZSSMain.isBG2Enabled && (quiverArrow = BattlegearEvents.getQuiverArrow(stack, player)) != null) {
                    arrowStack = quiverArrow;
                }
                if (arrowStack != null) {
                    icon = arrowStack.getIconIndex();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(firstPerson ? -0.03125f : 0.03125f));
                    ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMinU(), (float)icon.getMinV(), (float)icon.getMaxU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                    GL11.glPopMatrix();
                }
            }
        } else {
            IIcon icon = stack.getItem().getIcon(stack, 0);
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
        }
        GL11.glPopMatrix();
    }
}

