/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.model.ModelCube;
import zeldaswordskills.client.model.ModelWizzrobe;
import zeldaswordskills.entity.mobs.EntityGrandWizzrobe;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.projectile.EntityMagicSpell;

@SideOnly(value=Side.CLIENT)
public class RenderEntityWizzrobe
extends RenderLiving {
    private static final ResourceLocation fireWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_fire.png");
    private static final ResourceLocation iceWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_ice.png");
    private static final ResourceLocation lightningWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_lightning.png");
    private static final ResourceLocation windWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_wind.png");
    private static final ResourceLocation grandFireWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_fire_grand.png");
    private static final ResourceLocation grandIceWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_ice_grand.png");
    private static final ResourceLocation grandLightningWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_lightning_grand.png");
    private static final ResourceLocation grandWindWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_wind_grand.png");
    private final EntityMagicSpell spell;
    private final ModelWizzrobe model;
    private final ModelCube box1 = new ModelCube(4);
    private final ModelCube box2 = new ModelCube(4);
    private final float scale;

    public RenderEntityWizzrobe(ModelWizzrobe model, float scale) {
        super((ModelBase)model, 0.5f);
        this.model = model;
        this.scale = scale;
        this.spell = new EntityMagicSpell((World)Minecraft.getMinecraft().theWorld);
    }

    protected void preRenderCallback(EntityLivingBase entity, float partialTick) {
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
    }

    public void doRender(EntityLiving entity, double dx, double dy, double dz, float yaw, float partialTick) {
        if (entity instanceof IBossDisplayData) {
            BossStatus.setBossStatus((IBossDisplayData)((IBossDisplayData)entity), (boolean)true);
        }
        super.doRender(entity, dx, dy, dz, yaw, partialTick);
        if (this.model.atPeak) {
            this.renderSpell((EntityWizzrobe)entity, dx, dy, dz, yaw, partialTick);
        }
    }

    private void renderSpell(EntityWizzrobe wizzrobe, double dx, double dy, double dz, float yaw, float partialTick) {
        float roll;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        Vec3 vec3 = Vec3.createVectorHelper((double)dx, (double)dy, (double)dz).normalize();
        GL11.glTranslated((double)(dx - vec3.xCoord), (double)(dy + (double)wizzrobe.getEyeHeight()), (double)(dz - vec3.zCoord));
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        for (roll = ((float)wizzrobe.getCurrentCastingTime() + partialTick) * 40.0f; roll > 360.0f; roll -= 360.0f) {
        }
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)roll, (float)0.8f, (float)0.0f, (float)-0.6f);
        this.bindTexture(wizzrobe.getMagicType().getEntityTexture());
        Tessellator.instance.setBrightness(0xF000F0);
        this.box1.render((Entity)this.spell);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.box2.render((Entity)this.spell);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        boolean grand = entity instanceof EntityGrandWizzrobe;
        switch (((EntityWizzrobe)entity).getMagicType()) {
            case FIRE: {
                return grand ? grandFireWizTexture : fireWizTexture;
            }
            case ICE: {
                return grand ? grandIceWizTexture : iceWizTexture;
            }
            case LIGHTNING: {
                return grand ? grandLightningWizTexture : lightningWizTexture;
            }
        }
        return grand ? grandWindWizTexture : windWizTexture;
    }
}

