/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ModParticle
extends EntityFX {
    public static final ResourceLocation modParticles = new ResourceLocation("zeldaswordskills", "textures/particles.png");
    public static final ResourceLocation minecraftParticles = new ResourceLocation("textures/particle/particles.png");
    protected int iconStages;
    protected int iconStartIndex;
    private int initialIconIndex;
    private int remainingIconStages;
    private boolean animated = false;
    private float fadeInTime = 0.0f;
    private float baseAlpha = 1.0f;
    private float fadeOutTime = 0.8f;
    private boolean glowing = false;

    public ModParticle(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    public ModParticle(World world, double x, double y, double z, double velX, double velY, double velZ) {
        super(world, x, y, z, velX, velY, velZ);
        this.motionX = velX;
        this.motionY = velY;
        this.motionZ = velZ;
    }

    public void setAlphaF(float value) {
        this.setBaseAlpha(value);
    }

    protected void setBaseAlpha(float value) {
        this.baseAlpha = value;
        this.particleAlpha = value;
    }

    protected void setRandomScale(float min, float max) {
        this.particleScale = this.rand.nextFloat() * (max - min) + min;
    }

    protected void setRandomMaxAge(int min, int max) {
        this.particleMaxAge = MathHelper.floor_float((float)(this.rand.nextFloat() * (float)(max - min))) + min;
    }

    protected void randomizeVelocity(double maximum) {
        this.motionX += (this.rand.nextDouble() * 2.0 - 1.0) * maximum;
        this.motionY += (this.rand.nextDouble() * 2.0 - 1.0) * maximum;
        this.motionZ += (this.rand.nextDouble() * 2.0 - 1.0) * maximum;
    }

    protected void setTexturePositions(int x, int y) {
        this.setTexturePositions(x, y, 1, false);
    }

    protected void setTexturePositions(int x, int y, int stages, boolean randomStart) {
        this.remainingIconStages = this.iconStages = stages;
        this.initialIconIndex = this.iconStartIndex = y * 16 + x;
        if (randomStart) {
            int firstStage = this.rand.nextInt(stages - 1);
            this.initialIconIndex += firstStage;
            this.remainingIconStages -= firstStage;
        }
        this.setParticleTextureIndex(this.initialIconIndex);
    }

    protected void setAnimated(boolean value) {
        this.animated = value;
    }

    protected void setFade(float fadeInTime, float fadeOutTime) {
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
    }

    protected void setGlowing() {
        this.glowing = true;
    }

    public void renderParticle(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        tessellator.draw();
        Minecraft.getMinecraft().renderEngine.bindTexture(modParticles);
        tessellator.startDrawingQuads();
        tessellator.setBrightness(this.getBrightnessForRender(partialTick));
        super.renderParticle(tessellator, partialTick, rotX, rotXZ, rotZ, rotYZ, rotXY);
        tessellator.draw();
        tessellator.startDrawingQuads();
        Minecraft.getMinecraft().renderEngine.bindTexture(minecraftParticles);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float ageFraq = (float)this.particleAge / (float)this.particleMaxAge;
        this.particleAlpha = this.alphaAtAge(ageFraq);
        this.particleScale = this.scaleAtAge(ageFraq);
        if (this.animated && this.remainingIconStages > 1) {
            int stage = MathHelper.floor_float((float)(ageFraq * (float)this.remainingIconStages));
            this.setParticleTextureIndex(this.initialIconIndex + stage);
        }
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }

    public int getBrightnessForRender(float partialTick) {
        return this.glowing ? 0xF000F0 : super.getBrightnessForRender(partialTick);
    }

    protected float alphaAtAge(float ageFraq) {
        if (ageFraq <= this.fadeInTime) {
            return this.baseAlpha * ageFraq / this.fadeInTime;
        }
        if (ageFraq >= this.fadeOutTime) {
            return this.baseAlpha * (1.0f - (ageFraq - this.fadeOutTime) / (1.0f - this.fadeOutTime));
        }
        return this.baseAlpha;
    }

    protected float scaleAtAge(float ageFraq) {
        return this.particleScale;
    }

    protected void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.setRBGColorF(r, g, b);
    }
}

