/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.client.particle.ParticleCyclone;

@SideOnly(value=Side.CLIENT)
public class FXCycloneRing
extends EntityFX {
    public static float ascendVelocity = 0.2f;
    public static int puffsPerRing = 8;
    public static float maxRingHeight = 4.0f;
    public static float baseAngleVelocity = 0.4f;
    private EntityFX[] puffs;
    private float dAngle;
    private float yaw;
    private float pitch;
    private Vec3 axis;
    private float ringHeight;
    private float baseAngle;

    public FXCycloneRing(World world, double x, double y, double z, double velX, double velY, double velZ, float yaw, float pitch, float alpha, EffectRenderer renderer) {
        super(world, x, y, z);
        this.motionX = velX;
        this.motionY = velY;
        this.motionZ = velZ;
        this.axis = Vec3.createVectorHelper((double)0.0, (double)1.0, (double)0.0);
        this.particleGravity = 0.0f;
        this.yaw = yaw;
        this.pitch = pitch;
        this.axis.rotateAroundX(pitch);
        this.axis.rotateAroundY(yaw);
        this.ringHeight = ascendVelocity;
        this.baseAngle = 0.0f;
        this.particleAlpha = alpha;
        this.puffs = new EntityFX[puffsPerRing];
        for (int i = 0; i < puffsPerRing; ++i) {
            int zInt;
            int yInt;
            int xInt;
            Block block;
            if (Math.random() < 0.07 && (block = world.getBlock(xInt = MathHelper.floor_double((double)x), yInt = MathHelper.floor_double((double)y) - 1, zInt = MathHelper.floor_double((double)z))) != null) {
                int metadata = world.getBlockMetadata(xInt, yInt, zInt);
                this.puffs[i] = new EntityDiggingFX(world, x, y + 0.1, z, velX, velY, velZ, block, metadata).applyColourMultiplier(xInt, yInt, zInt).multipleParticleScaleBy(0.5f);
                renderer.addEffect(this.puffs[i]);
                continue;
            }
            this.puffs[i] = new ParticleCyclone(world, x, y, z, velX, velY, velZ);
            this.puffs[i].setAlphaF(this.particleAlpha);
            renderer.addEffect(this.puffs[i]);
        }
        this.dAngle = (float)Math.PI * 2 / (float)this.puffs.length;
    }

    public void setAlphaF(float alpha) {
        super.setAlphaF(alpha);
        for (int i = 0; i < this.puffs.length; ++i) {
            this.puffs[i].setAlphaF(alpha);
        }
    }

    public void renderParticle(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
    }

    public void onUpdate() {
        int i;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float ringWidth = FXCycloneRing.getWidthVSHeight(this.ringHeight);
        for (i = 0; i < this.puffs.length; ++i) {
            Vec3 vec = Vec3.createVectorHelper((double)ringWidth, (double)0.0, (double)0.0);
            vec.rotateAroundY(this.baseAngle + (float)i * this.dAngle);
            vec.rotateAroundX(this.pitch);
            vec.rotateAroundY(this.yaw);
            this.puffs[i].motionX = this.posX + this.motionX + vec.xCoord - this.puffs[i].posX;
            this.puffs[i].motionY = this.posY + this.motionY + vec.yCoord - this.puffs[i].posY;
            this.puffs[i].motionZ = this.posZ + this.motionZ + vec.zCoord - this.puffs[i].posZ;
        }
        if (this.axis != null) {
            if (this.ringHeight < maxRingHeight) {
                this.posX += this.axis.xCoord * (double)ascendVelocity;
                this.posY += this.axis.yCoord * (double)ascendVelocity;
                this.posZ += this.axis.zCoord * (double)ascendVelocity;
                this.ringHeight += ascendVelocity;
            } else {
                for (i = 0; i < puffsPerRing; ++i) {
                    this.puffs[i].setDead();
                }
                this.setDead();
            }
        }
        this.baseAngle += baseAngleVelocity;
        if ((double)this.baseAngle > Math.PI * 2) {
            this.baseAngle = (float)((double)this.baseAngle - Math.PI * 2);
        }
    }

    public static float getWidthVSHeight(float height) {
        return height * 0.2f + 0.15f;
    }
}

