/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.entity.mobs.EntityWizzrobe;

@SideOnly(value=Side.CLIENT)
public class ModelWizzrobe
extends ModelBase {
    private ModelRenderer hat;
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer rightArm;
    private ModelRenderer leftArm;
    private ModelRenderer robe;
    private int maxCastTick;
    public boolean atPeak;
    private static final float[] rotX = new float[]{-0.5f, -1.35f, -2.0f, -2.5f};
    private static final float[] rotZ = new float[]{0.1f, 0.15f, 0.2f, 0.25f};

    public ModelWizzrobe() {
        this(0.0f, 0.0f);
    }

    public ModelWizzrobe(float f1, float f2) {
        this.textureWidth = 64;
        this.textureHeight = 128;
        this.head = new ModelRenderer((ModelBase)this, 0, 0).setTextureSize(this.textureWidth, this.textureHeight);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, f1);
        this.head.setRotationPoint(0.0f, 0.0f + f2, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 0, 16).setTextureSize(this.textureWidth, this.textureHeight);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 8, 4, f1);
        this.body.setRotationPoint(0.0f, 0.0f + f2, 0.0f);
        this.rightArm = new ModelRenderer((ModelBase)this, 32, 10).setTextureSize(this.textureWidth, this.textureHeight);
        this.rightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, f1);
        this.rightArm.setRotationPoint(-5.0f, 2.0f + f2, 0.0f);
        this.leftArm = new ModelRenderer((ModelBase)this, 32, 10).setTextureSize(this.textureWidth, this.textureHeight);
        this.leftArm.mirror = true;
        this.leftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, f1);
        this.leftArm.setRotationPoint(5.0f, 2.0f + f2, 0.0f);
        this.robe = new ModelRenderer((ModelBase)this, 32, 0).setTextureSize(this.textureWidth, this.textureHeight);
        this.robe.addBox(-4.0f, 0.0f, -3.0f, 8, 4, 6, f1);
        this.robe.setRotationPoint(0.0f, 8.0f + f2, 0.0f);
        this.setRotation(this.robe, 0.0f, 0.0f, 0.0f);
        this.body.addChild(this.robe);
        ModelRenderer robeMid = new ModelRenderer((ModelBase)this, 0, 28).setTextureSize(this.textureWidth, this.textureHeight);
        robeMid.addBox(-5.0f, 0.0f, -4.0f, 10, 6, 8, f1);
        robeMid.setRotationPoint(0.0f, 4.0f + f2, 0.0f);
        this.setRotation(robeMid, 0.0f, 0.0f, 0.0f);
        this.robe.addChild(robeMid);
        ModelRenderer robeLower = new ModelRenderer((ModelBase)this, 0, 42).setTextureSize(this.textureWidth, this.textureHeight);
        robeLower.addBox(-6.0f, 0.0f, -5.0f, 12, 6, 10, f1);
        robeLower.setRotationPoint(0.0f, 6.0f + f2, 0.0f);
        this.setRotation(robeLower, 0.0f, 0.0f, 0.0f);
        robeMid.addChild(robeLower);
        this.hat = new ModelRenderer((ModelBase)this, 24, 58).setTextureSize(this.textureWidth, this.textureHeight);
        this.hat.setRotationPoint(-5.0f, -10.03125f, -5.0f);
        this.hat.addBox(0.0f, 0.0f, 0.0f, 10, 2, 10);
        this.head.addChild(this.hat);
        ModelRenderer hatLayer1 = new ModelRenderer((ModelBase)this, 36, 31).setTextureSize(this.textureWidth, this.textureHeight);
        hatLayer1.setRotationPoint(1.75f, -4.0f, 2.0f);
        hatLayer1.addBox(0.0f, 0.0f, 0.0f, 7, 4, 7);
        hatLayer1.rotateAngleX = -0.05235988f;
        hatLayer1.rotateAngleZ = 0.02617994f;
        this.hat.addChild(hatLayer1);
        ModelRenderer hatLayer2 = new ModelRenderer((ModelBase)this, 48, 14).setTextureSize(this.textureWidth, this.textureHeight);
        hatLayer2.setRotationPoint(1.75f, -4.0f, 2.0f);
        hatLayer2.addBox(0.0f, 0.0f, 0.0f, 4, 4, 4);
        hatLayer2.rotateAngleX = -0.10471976f;
        hatLayer2.rotateAngleZ = 0.05235988f;
        hatLayer1.addChild(hatLayer2);
        ModelRenderer hatLayer3 = new ModelRenderer((ModelBase)this, 26, 18).setTextureSize(this.textureWidth, this.textureHeight);
        hatLayer3.setRotationPoint(1.75f, -2.0f, 2.0f);
        hatLayer3.addBox(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.25f);
        hatLayer3.rotateAngleX = -0.20943952f;
        hatLayer3.rotateAngleZ = 0.10471976f;
        hatLayer2.addChild(hatLayer3);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.render(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        this.head.render(f5);
        this.body.render(f5);
        this.rightArm.render(f5);
        this.leftArm.render(f5);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setLivingAnimations(EntityLivingBase entity, float par2, float par3, float par4) {
        this.setLivingAnimations((EntityWizzrobe)entity, par2, par3, par4);
    }

    private void setLivingAnimations(EntityWizzrobe entity, float par2, float par3, float par4) {
        int castTime = entity.getCurrentCastingTime();
        if (castTime > 0) {
            this.maxCastTick = entity.getMaxCastingTime() - 1;
            int i = 0;
            if (castTime == 1 || castTime == this.maxCastTick) {
                i = 0;
            } else if (castTime == 2 || castTime == this.maxCastTick - 1) {
                i = 1;
            } else if (castTime == 3 || castTime == this.maxCastTick - 2) {
                i = 2;
                this.atPeak = false;
            } else {
                i = 3;
                this.atPeak = true;
            }
            this.rightArm.rotateAngleX = rotX[i];
            this.leftArm.rotateAngleX = rotX[i];
            this.rightArm.rotateAngleZ = -rotZ[i];
            this.leftArm.rotateAngleZ = rotZ[i];
        } else {
            this.rightArm.rotateAngleZ = 0.0f;
            this.leftArm.rotateAngleZ = 0.0f;
        }
    }

    public void setRotationAngles(float f1, float f2, float f3, float f4, float f5, float f6, Entity entity) {
        super.setRotationAngles(f1, f2, f3, f4, f5, f6, entity);
        this.head.rotateAngleY = f4 / 57.295776f;
        if (((EntityWizzrobe)entity).getCurrentCastingTime() == 0) {
            this.rightArm.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f;
            this.leftArm.rotateAngleX = MathHelper.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f;
            this.atPeak = false;
        }
    }
}

