/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import zeldaswordskills.api.client.animation.AnimationCircle;
import zeldaswordskills.api.client.animation.AnimationTargetAngle;
import zeldaswordskills.api.client.animation.AnimationTargetOffset;
import zeldaswordskills.api.client.animation.AnimationVisible;
import zeldaswordskills.api.client.animation.AnimationWave;
import zeldaswordskills.api.client.animation.IAnimation;
import zeldaswordskills.api.client.animation.IProgressType;
import zeldaswordskills.api.client.animation.RotationAxis;
import zeldaswordskills.api.entity.ai.EntityAction;
import zeldaswordskills.client.model.ModelDekuBase;
import zeldaswordskills.entity.mobs.EntityDekuBaba;
import zeldaswordskills.entity.mobs.EntityDekuBase;

public class ModelDekuBaba
extends ModelDekuBase {
    protected final ImmutableList<IAnimation> ATTACK_ANIMATION;
    protected final ImmutableList<IAnimation> LOOPING_ANIMATIONS;
    protected final ImmutableList<IAnimation> READY_ANIMATION;
    protected final ImmutableList<IAnimation> SPROUT_ANIMATION;

    public ModelDekuBaba() {
        this.ATTACK_ANIMATION = new ImmutableList.Builder().add((Object)new AnimationTargetAngle(this.stem1, RotationAxis.X, -35.0f, 0, 3, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem1, RotationAxis.X, 45.0f, 3, 7, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem1, RotationAxis.X, -15.0f, 9, 12, true)).add((Object)new AnimationTargetAngle(this.stem1, RotationAxis.X, -15.0f, 12, 15, true).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.stem2, RotationAxis.X, 45.0f, 0, 3, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem2, RotationAxis.X, 20.0f, 3, 7, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem2, RotationAxis.X, 20.0f, 12, 15, true).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.stem3, RotationAxis.X, 50.0f, 0, 3, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem3, RotationAxis.X, 15.0f, 3, 7, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.stem3, RotationAxis.X, 30.0f, 9, 12, true)).add((Object)new AnimationTargetAngle(this.stem3, RotationAxis.X, 30.0f, 12, 15, true).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.head_base, RotationAxis.X, 50.0f, 0, 3, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.head_base, RotationAxis.X, 15.0f, 3, 7, true).setProgressType(IProgressType.SQUARED)).add((Object)new AnimationTargetAngle(this.head_base, RotationAxis.X, 60.0f, 9, 12, true)).add((Object)new AnimationTargetAngle(this.head_base, RotationAxis.X, 60.0f, 12, 15, true).setAllowOffset(false)).add((Object)new AnimationVisible(this.tongue_base, 9, 13, false, true)).add((Object)new AnimationTargetAngle(this.mouth_base_lower, RotationAxis.X, -45.0f, 0, 5, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_base_lower, RotationAxis.X, -90.0f, 7, 9, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_base_lower, RotationAxis.X, -60.0f, 12, 15, true).setAllowInversion(false).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.mouth_lower, RotationAxis.X, 0.0f, 7, 9, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_lower, RotationAxis.X, -25.0f, 12, 15, true).setAllowInversion(false).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.mouth_base_upper, RotationAxis.X, -55.0f, 0, 5, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_base_upper, RotationAxis.X, 0.0f, 7, 9, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_base_upper, RotationAxis.X, -30.0f, 12, 15, true).setAllowInversion(false).setAllowOffset(false)).add((Object)new AnimationTargetAngle(this.mouth_upper, RotationAxis.X, -90.0f, 7, 9, true).setAllowInversion(false)).add((Object)new AnimationTargetAngle(this.mouth_upper, RotationAxis.X, -70.0f, 12, 15, true).setAllowInversion(false).setAllowOffset(false)).build();
        this.LOOPING_ANIMATIONS = new ImmutableList.Builder().add((Object)new AnimationCircle(RotationAxis.X, RotationAxis.Z, 0.15f, 0.25f, 0.25f, false, this.stem1, this.stem2, this.stem3, this.head_base)).add((Object)new AnimationCircle(RotationAxis.X, RotationAxis.Z, 0.15f, 0.1f, 0.15f, true, this.tongue_base, this.tongue_mid, this.tongue_tip)).add((Object)new AnimationWave.AnimationWaveSin(RotationAxis.X, 0.1f, 0.15f, 0.15f, this.tongue_base, this.tongue_mid, this.tongue_tip)).build();
        this.READY_ANIMATION = new ImmutableList.Builder().add((Object)new AnimationTargetAngle(this.stem1, RotationAxis.X, -15.0f, 5, 10, true)).add((Object)new AnimationTargetAngle(this.stem2, RotationAxis.X, 20.0f, 5, 10, true)).add((Object)new AnimationTargetAngle(this.stem3, RotationAxis.X, 30.0f, 5, 10, true)).add((Object)new AnimationTargetAngle(this.head_base, RotationAxis.X, 60.0f, 5, 10, true)).build();
        this.SPROUT_ANIMATION = new ImmutableList.Builder().add((Object)new AnimationTargetOffset(this.stem1, RotationAxis.Y, 2.0f, 0, 0).setAllowInversion(false)).add((Object)new AnimationTargetOffset(this.stem1, RotationAxis.Y, 0.0f, 1, EntityDekuBaba.ACTION_SPROUT.duration).setAllowInversion(false)).add((Object)new AnimationVisible(this.stem1, 0, 1, false, true)).build();
    }

    @Override
    protected void applyAnimations(EntityDekuBase entity, float par2, float par3, float partialTick) {
        this.applyAnimations((EntityDekuBaba)entity, par2, par3, partialTick);
    }

    protected void applyAnimations(EntityDekuBaba entity, float par2, float par3, float partialTick) {
        int frame = entity.getActionTime(EntityDekuBaba.ACTION_SPROUT.id);
        float modifier = entity.getCurrentTarget() == null ? -partialTick : partialTick;
        float speed = entity.getActionSpeed(EntityDekuBaba.ACTION_SPROUT.id);
        IAnimation.Helper.applyAnimation(this.SPROUT_ANIMATION, frame, modifier, speed, 1.0f, 0.0f, false);
        IAnimation.Helper.applyAnimation(this.READY_ANIMATION, frame, modifier, speed, 1.0f, 0.0f, entity.isConfused());
        boolean flag = this.applyDeathAnimation(entity, par2, par3, partialTick);
        if (entity.isFullyAlert()) {
            speed = entity.isConfused() ? 0.9f : 1.0f;
            float factor = entity.isConfused() ? 1.25f : 1.0f;
            float offset = entity.isConfused() ? 0.15f : 1.0f;
            IAnimation.Helper.applyAnimation(this.LOOPING_ANIMATIONS, entity.ticksExisted + entity.getTicksExistedOffset(-1), partialTick, speed, factor, offset, false);
            if (!flag) {
                this.animateActions(entity, par2, par3, partialTick);
            }
        }
    }

    private void animateActions(EntityDekuBaba entity, float par2, float par3, float partialTick) {
        Entity target = entity.getCurrentTarget();
        List<EntityAction> actions = entity.getActiveActions();
        for (EntityAction action : actions) {
            int frame = entity.getActionTime(action.id);
            if (frame <= 0) continue;
            float speed = entity.getActionSpeed(action.id);
            float offset = 0.0f;
            if (target != null && (action == EntityDekuBaba.ACTION_ATTACK || action == EntityDekuBaba.ACTION_BOMB)) {
                offset = 0.075f * MathHelper.clamp_float((float)((float)(entity.boundingBox.maxY - target.boundingBox.maxY)), (float)-2.0f, (float)1.5f);
            }
            IAnimation.Helper.applyAnimation(this.getAnimation(action), frame, partialTick, speed, 1.0f, offset, entity.isConfused());
        }
    }

    protected ImmutableList<IAnimation> getAnimation(EntityAction action) {
        if (action == EntityDekuBaba.ACTION_ATTACK) {
            return this.ATTACK_ANIMATION;
        }
        if (action == EntityDekuBaba.ACTION_BOMB) {
            return this.ATTACK_ANIMATION;
        }
        if (action == EntityDekuBaba.ACTION_PRONE) {
            return this.PRONE_ANIMATION;
        }
        return null;
    }
}

