/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import zeldaswordskills.client.gui.GuiMusicBase;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.LearnSongPacket;
import zeldaswordskills.network.bidirectional.PlayRecordPacket;
import zeldaswordskills.network.server.ZeldaSongPacket;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;
import zeldaswordskills.util.TimedChatDialogue;

@SideOnly(value=Side.CLIENT)
public class GuiOcarina
extends GuiMusicBase {
    protected static final ResourceLocation texture = new ResourceLocation("zeldaswordskills", "textures/gui/gui_ocarina.png");
    private List<SongNote> scarecrowNotes;
    private boolean scarecrowFirst;
    private int currentNoteIndex;
    private final boolean wasSneaking;

    public GuiOcarina(int x, int y, int z) {
        this(x, y, z, false);
    }

    public GuiOcarina(int x, int y, int z, boolean isScarecrow) {
        super(x, y, z);
        if (isScarecrow) {
            this.scarecrowNotes = ZSSPlayerSongs.get((EntityPlayer)this.mc.thePlayer).getScarecrowNotes();
            if (this.scarecrowNotes == null || this.scarecrowNotes.isEmpty()) {
                this.scarecrowFirst = true;
                this.scarecrowNotes = new ArrayList<SongNote>();
            }
        }
        this.wasSneaking = this.mc.thePlayer.isSneaking();
    }

    @Override
    public void initGui() {
        super.initGui();
        if (this.scarecrowFirst) {
            new TimedChatDialogue((EntityPlayer)this.mc.thePlayer, 0, 1600, new IChatComponent[]{new ChatComponentTranslation("chat.zss.song.scarecrow.greet.0", new Object[0]), new ChatComponentTranslation("chat.zss.song.scarecrow.greet.1", new Object[0])});
        } else if (this.scarecrowNotes != null && !this.scarecrowNotes.isEmpty()) {
            new TimedChatDialogue((EntityPlayer)this.mc.thePlayer, 0, 1600, new IChatComponent[]{new ChatComponentTranslation("chat.zss.song.scarecrow.last.0", new Object[0]), new ChatComponentTranslation("chat.zss.song.scarecrow.last.1", new Object[0])});
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return texture;
    }

    @Override
    public void updateScreen() {
        if (this.song == ZeldaSongs.songScarecrow && this.scarecrowNotes != null) {
            if (++this.ticksSinceLastNote == 20) {
                if (this.currentNoteIndex == this.scarecrowNotes.size()) {
                    this.mc.thePlayer.closeScreen();
                } else {
                    this.onNotePlayed(this.scarecrowNotes.get(this.currentNoteIndex++));
                }
            }
        } else {
            super.updateScreen();
        }
    }

    public void onGuiClosed() {
        if (this.song != null) {
            if (this.ticksSinceLastNote > this.song.getMinDuration() || this.scarecrowNotes != null && this.currentNoteIndex == this.scarecrowNotes.size()) {
                if (this.scarecrowFirst || this.scarecrowNotes != null && !ZSSPlayerSongs.get((EntityPlayer)this.mc.thePlayer).isSongKnown(ZeldaSongs.songScarecrow)) {
                    PacketDispatcher.sendToServer(new LearnSongPacket(this.song, this.scarecrowNotes));
                } else if (!this.wasSneaking) {
                    PacketDispatcher.sendToServer(new ZeldaSongPacket(this.song));
                }
            } else {
                PacketDispatcher.sendToServer(new PlayRecordPacket(null, this.x, this.y, this.z));
            }
        }
    }

    @Override
    protected void onNoteAdded() {
        if (this.scarecrowNotes != null) {
            if (this.melody.size() == 8) {
                if (!ZeldaSongs.areNotesUnique(this.melody)) {
                    this.melody.clear();
                    PlayerUtils.sendTranslatedChat((EntityPlayer)this.mc.thePlayer, "chat.zss.song.scarecrow.copycat", new Object[0]);
                } else if (this.scarecrowNotes.isEmpty()) {
                    boolean flag = true;
                    for (int i = 0; i < this.melody.size() - 1 && flag; ++i) {
                        flag = this.melody.get(i) == this.melody.get(i + 1);
                    }
                    if (flag) {
                        this.melody.clear();
                        PlayerUtils.sendTranslatedChat((EntityPlayer)this.mc.thePlayer, "chat.zss.song.scarecrow.boring", new Object[0]);
                    } else {
                        this.scarecrowNotes.addAll(this.melody);
                        PlayerUtils.sendTranslatedChat((EntityPlayer)this.mc.thePlayer, "chat.zss.song.scarecrow.again", new Object[0]);
                    }
                } else {
                    boolean flag = true;
                    for (int i = 0; i < this.melody.size() && flag; ++i) {
                        flag = this.scarecrowNotes.get(i) == this.melody.get(i);
                    }
                    if (flag) {
                        String chat = this.scarecrowFirst ? "first" : "learn";
                        new TimedChatDialogue((EntityPlayer)this.mc.thePlayer, 0, 1600, new IChatComponent[]{new ChatComponentTranslation("chat.zss.song.scarecrow." + chat + ".0", new Object[0]), new ChatComponentTranslation("chat.zss.song.scarecrow." + chat + ".1", new Object[0])});
                        this.song = ZeldaSongs.songScarecrow;
                        this.mc.thePlayer.playSound("zeldaswordskills:success", 0.3f, 1.0f);
                        this.ticksSinceLastNote = 0;
                    } else {
                        this.melody.clear();
                        PlayerUtils.sendTranslatedChat((EntityPlayer)this.mc.thePlayer, "chat.zss.song.scarecrow.forgot", new Object[0]);
                    }
                }
            }
        } else if (this.melody.size() < 9) {
            this.song = ZSSPlayerSongs.get((EntityPlayer)this.mc.thePlayer).getKnownSongFromNotes(this.melody);
            if (this.song != null) {
                if (this.song.playSuccessSound()) {
                    this.mc.thePlayer.playSound("zeldaswordskills:success", 0.3f, 1.0f);
                }
                if (this.song == ZeldaSongs.songScarecrow) {
                    this.scarecrowNotes = new ArrayList<SongNote>(this.melody);
                    this.ticksSinceLastNote = 0;
                } else {
                    PacketDispatcher.sendToServer(new PlayRecordPacket(this.song.getSoundString(), this.x, this.y, this.z));
                }
            }
        }
    }
}

