/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import zeldaswordskills.block.tileentity.TileEntityGossipStone;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.server.SetGossipStoneMessagePacket;
import zeldaswordskills.util.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiEditGossipStone
extends GuiScreen {
    private final TileEntityGossipStone te;
    private GuiButton btnDone;
    private StringBuilder message;

    public GuiEditGossipStone(TileEntityGossipStone te) {
        this.te = te;
    }

    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.btnDone = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, StatCollector.translateToLocal((String)"gui.done"));
        this.buttonList.add(this.btnDone);
        this.message = new StringBuilder(192);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.te.setMessage(this.message.toString());
        PacketDispatcher.sendToServer(new SetGossipStoneMessagePacket(this.te));
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled && button.id == this.btnDone.id) {
            this.te.markDirty();
            this.mc.displayGuiScreen(null);
        }
    }

    protected void keyTyped(char c, int keyCode) {
        if (keyCode == 1) {
            this.actionPerformed(this.btnDone);
        } else if (keyCode == 14 && this.message.length() > 0) {
            this.message.deleteCharAt(this.message.length() - 1);
        } else if (keyCode == 28) {
            this.message.append("\n");
        } else if (ChatAllowedCharacters.isAllowedCharacter((char)c) && this.message.length() < 192) {
            this.message.append(c);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, StatCollector.translateToLocal((String)"gui.zss.gossip_stone.name"), this.width / 2, 40, 0xFFFFFF);
        String[] lines = StringUtils.wrapString(this.message.toString(), 64, 5);
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                lines[i] = "> " + lines[i];
            } else if (i == lines.length - 1) {
                int n = i;
                lines[n] = lines[n] + " <";
            }
            this.fontRendererObj.drawString(lines[i], this.width / 2 - this.fontRendererObj.getStringWidth(lines[i]) / 2, 80 + i * this.fontRendererObj.FONT_HEIGHT, 0xFFFFFF);
        }
        super.drawScreen(mouseX, mouseY, f);
    }
}

