/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.block.tileentity.TileEntityInventory;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.WorldUtils;

public class TileEntityPedestal
extends TileEntityInventory {
    private ItemStack sword;
    private boolean playSound = true;
    private byte orientation;

    public TileEntityPedestal() {
        this.inventory = new ItemStack[3];
    }

    public int getPowerLevel() {
        if (this.sword != null && this.sword.getItem() instanceof ItemZeldaSword && ((ItemZeldaSword)this.sword.getItem()).isMasterSword()) {
            return this.sword.getItem() == ZSSItems.swordMaster || Config.getMasterSwordsProvidePower() ? 15 : 0;
        }
        return 0;
    }

    public void changeOrientation() {
        if (this.hasSword()) {
            this.orientation = (byte)(this.orientation == 0 ? 1 : 0);
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public ItemStack getSword() {
        return this.sword;
    }

    public boolean hasSword() {
        return this.sword != null;
    }

    public void retrieveSword() {
        if (this.sword != null) {
            WorldUtils.playSoundAt(this.worldObj, (double)this.xCoord + 0.5, this.yCoord + 1, (double)this.zCoord + 0.5, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
            WorldUtils.spawnItemWithRandom(this.worldObj, this.sword, this.xCoord, this.yCoord + 1, this.zCoord);
            this.sword = null;
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord));
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public boolean setSword(ItemStack stack, EntityPlayer player) {
        if (this.sword == null && stack != null && WeaponRegistry.INSTANCE.isSword(stack.getItem())) {
            if (stack.getItem() == ZSSItems.swordGolden && stack.hasTagCompound() && stack.getTagCompound().hasKey("SacredFlames") && stack.getTagCompound().getInteger("SacredFlames") == 7) {
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5, "zeldaswordskills:master_sword", 1.0f, 1.0f);
                ItemStack master = new ItemStack(ZSSItems.swordMasterTrue);
                master.addEnchantment(Enchantment.sharpness, 5);
                master.addEnchantment(Enchantment.knockback, 2);
                master.addEnchantment(Enchantment.fireAspect, 2);
                master.addEnchantment(Enchantment.looting, 3);
                this.sword = master;
                if (player != null) {
                    player.triggerAchievement((StatBase)ZSSAchievements.swordTrue);
                }
            } else {
                WorldUtils.playSoundAt(this.worldObj, (double)this.xCoord + 0.5, this.yCoord + 1, (double)this.zCoord + 0.5, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                this.sword = stack.copy();
            }
            if (player != null) {
                int facing = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                this.orientation = (byte)(facing != 0 && facing != 2 ? 1 : 0);
            }
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord));
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    public void onBlockPlaced() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.inventory[i] = new ItemStack(ZSSItems.pendant, 1, i);
        }
        this.playSound = false;
        this.markDirty();
    }

    public void markDirty() {
        super.markDirty();
        int meta = 0;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null) continue;
            meta |= i == 2 ? i << 1 : i + 1;
        }
        if (meta == 7) {
            meta = 8;
            if (this.playSound) {
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5, "zeldaswordskills:master_sword", 1.0f, 1.0f);
                this.retrieveSword();
                EntityPlayer player = this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 8.0);
                if (player != null) {
                    player.triggerAchievement((StatBase)ZSSAchievements.swordMaster);
                }
            } else {
                this.playSound = true;
            }
        }
        if (meta != this.blockMetadata || this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) != meta) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, meta, 2);
        }
    }

    public String getInventoryName() {
        return "";
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return stack != null && stack.getItem() instanceof ItemPendant && stack.getItemDamage() == slot;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.getBoolean("hasSword")) {
            this.sword = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("Sword"));
            this.orientation = compound.hasKey("orientation") ? compound.getByte("orientation") : (byte)0;
        } else {
            this.sword = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.sword != null) {
            compound.setBoolean("hasSword", true);
            compound.setTag("Sword", (NBTBase)this.sword.writeToNBT(new NBTTagCompound()));
            compound.setByte("orientation", this.orientation);
        } else {
            compound.setBoolean("hasSword", false);
        }
    }
}

