/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;

public class TileEntityInscription
extends TileEntity {
    private AbstractZeldaSong song = ZeldaSongs.songTime;

    public boolean canUpdate() {
        return false;
    }

    public AbstractZeldaSong getSong() {
        return this.song;
    }

    public void setSong(AbstractZeldaSong song) {
        if (song != null && !song.canLearnFromInscription(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.blockType, this.blockMetadata)) {
            ZSSMain.logger.warn(String.format("%s cannot be learned from inscriptions; coordinates: %d/%d/%d", song.getDisplayName(), this.xCoord, this.yCoord, this.zCoord));
            return;
        }
        this.song = song;
        if (!this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    private void setNextSong() {
        List<String> songs = ZeldaSongs.getRegisteredNames();
        int i = Math.max(0, songs.indexOf(this.song) + 1);
        if (i == songs.size()) {
            i = 0;
        }
        this.song = null;
        boolean looped = false;
        while (this.song == null && i < songs.size()) {
            this.song = ZeldaSongs.getSongByName(songs.get(i));
            if (this.song.canLearnFromInscription(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.blockType, this.blockMetadata)) continue;
            this.song = null;
            if (++i != songs.size() || looped) continue;
            looped = true;
            i = 0;
        }
        this.setSong(this.song);
    }

    public boolean onActivated(EntityPlayer player) {
        if (this.song == null) {
            ZSSMain.logger.warn(String.format("TileEntityInscription at %d/%d/%d does not have a valid song!", this.xCoord, this.yCoord, this.zCoord));
            return false;
        }
        ItemStack stack = player.getHeldItem();
        if (player.capabilities.isCreativeMode) {
            if (player.isSneaking()) {
                if (!this.worldObj.isRemote) {
                    this.setNextSong();
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.new", new ChatComponentTranslation(this.song.getTranslationString(), new Object[0]));
                }
            } else if (!this.worldObj.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.current", new ChatComponentTranslation(this.song.getTranslationString(), new Object[0]));
            }
            return true;
        }
        if (stack != null && stack.getItem() instanceof ItemInstrument) {
            if (this.worldObj.isRemote) {
                ZSSPlayerSongs.get((EntityPlayer)player).songToLearn = this.song;
                player.openGui((Object)ZSSMain.instance, 5, player.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
            return true;
        }
        if (this.worldObj.isRemote) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.fail", new Object[0]);
        }
        return false;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey("SongName")) {
            this.song = ZeldaSongs.getSongByName(compound.getString("SongName"));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.song != null) {
            compound.setString("SongName", this.song.getUnlocalizedName());
        }
    }
}

