/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.ZSSBlocks;

public class TileEntityDungeonBlock
extends TileEntity {
    private Block renderBlock = null;
    private int renderMetadata = 0;

    public boolean canUpdate() {
        return false;
    }

    public Block getRenderBlock() {
        return this.renderBlock;
    }

    public int getRenderMetadata() {
        return this.renderMetadata;
    }

    public void setRenderBlock(Block block, int metadata) {
        this.renderBlock = block;
        this.renderMetadata = metadata;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if ((this.renderBlock == null || this.renderBlock == Blocks.air) && this.getBlockType() == ZSSBlocks.dungeonCore) {
            this.renderBlock = BlockSecretStone.getBlockFromMeta(this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord));
            this.renderMetadata = 0;
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 2);
        }
        compound.setInteger("renderBlock", this.renderBlock != null ? Block.getIdFromBlock((Block)this.renderBlock) : -1);
        compound.setInteger("renderMetadata", this.renderMetadata);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        int blockId = compound.hasKey("renderBlock") ? compound.getInteger("renderBlock") : -1;
        this.renderBlock = blockId > -1 ? Block.getBlockById((int)blockId) : null;
        this.renderMetadata = compound.getInteger("renderMetadata");
    }
}

