/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.block.BlockTarget;

public class BlockTargetDirectional
extends BlockTarget {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFace;

    public BlockTargetDirectional(Material material) {
        super(material);
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return side + 1 == world.getBlockMetadata(x, y, z) ? Event.Result.ALLOW : Event.Result.DENY;
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return side + 1;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        int meta = face == 0 ? 3 : (face == 1 ? 6 : (face == 2 ? 4 : 5));
        if (entity.rotationPitch < -45.0f) {
            meta = 1;
        } else if (entity.rotationPitch > 45.0f) {
            meta = 2;
        }
        world.setBlockMetadataWithNotify(x, y, z, meta, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return meta == 0 ? (side == 1 ? this.iconFace : this.blockIcon) : (side + 1 != meta ? this.blockIcon : this.iconFace);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_side");
        this.iconFace = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_face");
    }
}

