/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zeldaswordskills.block.tileentity.TileEntityInscription;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;

public class BlockSongInscription
extends BlockContainer {
    private static final float px1 = 0.0625f;
    private static final float px2 = 0.125f;

    public BlockSongInscription() {
        super(Material.iron);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.setHardness(50.0f);
        this.setResistance(2000.0f);
        this.setStepSound(soundTypeMetal);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityInscription();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityInscription) {
            return ((TileEntityInscription)te).onActivated(player);
        }
        return false;
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        switch (side) {
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return meta;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        AbstractZeldaSong song;
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("SongName") && (song = ZeldaSongs.getSongByName(stack.getTagCompound().getString("SongName"))) != null && (te = world.getTileEntity(x, y, z)) instanceof TileEntityInscription) {
            ((TileEntityInscription)te).setSong(song);
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.0625f, 0.875f);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        float f = 0.875f;
        switch (world.getBlockMetadata(x, y, z)) {
            case 1: {
                this.setBlockBounds(0.125f, 0.9375f, 0.125f, f, 1.0f, f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.125f, 0.125f, 0.0f, f, f, 0.0625f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.125f, 0.125f, 0.9375f, f, f, 1.0f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, 0.125f, 0.125f, 0.0625f, f, f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.9375f, 0.125f, 0.125f, 1.0f, f, f);
                break;
            }
            default: {
                this.setBlockBounds(0.125f, 0.0f, 0.125f, f, 0.0625f, f);
            }
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int meta = world.getBlockMetadata(x, y, z);
        int x1 = x;
        int y1 = y;
        int z1 = z;
        ForgeDirection side = null;
        switch (meta) {
            case 0: {
                --y1;
                side = ForgeDirection.UP;
                break;
            }
            case 1: {
                ++y1;
                side = ForgeDirection.DOWN;
                break;
            }
            case 2: {
                --z1;
                side = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                ++z1;
                side = ForgeDirection.NORTH;
                break;
            }
            case 4: {
                --x1;
                side = ForgeDirection.EAST;
                break;
            }
            case 5: {
                ++x1;
                side = ForgeDirection.WEST;
            }
        }
        if (!world.isSideSolid(x1, y1, z1, side)) {
            world.setBlockToAir(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }
}

