/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.tileentity.TileEntitySacredFlame;
import zeldaswordskills.client.render.block.RenderSacredFlame;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockSacredFlame
extends BlockContainer {
    public static final int DIN = 1;
    public static final int FARORE = 2;
    public static final int NAYRU = 4;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockSacredFlame() {
        super(ZSSBlockMaterials.sacredFlame);
        this.disableStats();
        this.setBlockUnbreakable();
        this.setResistance(BlockWeight.IMPOSSIBLE.weight);
        this.setLightLevel(1.0f);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntitySacredFlame();
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public boolean isCollidable() {
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return RenderSacredFlame.renderId;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.getBlockMetadata(x, y, z);
        ItemStack stack = player.getHeldItem();
        if (stack != null && stack.getItem() instanceof ISacredFlame) {
            if (((ISacredFlame)stack.getItem()).onActivatedSacredFlame(stack, world, player, meta & 0xFFFFFFF7, (meta & 8) == 0)) {
                this.extinguishFlame(world, x, y, z);
                return true;
            }
        } else if (!world.isRemote) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.random", new Object[0]);
        }
        return false;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        ItemStack stack = player.getHeldItem();
        if (stack != null) {
            boolean isActive;
            boolean bl = isActive = (meta & 8) == 0;
            if (stack.getItem() instanceof ISacredFlame) {
                if (((ISacredFlame)stack.getItem()).onClickedSacredFlame(stack, world, player, meta & 0xFFFFFFF7, isActive)) {
                    this.extinguishFlame(world, x, y, z);
                }
            } else if (!world.isRemote) {
                if (stack.getItem() == Items.arrow && isActive) {
                    int n = stack.stackSize;
                    player.setCurrentItemOrArmor(0, new ItemStack(meta == 1 ? ZSSItems.arrowFire : (meta == 4 ? ZSSItems.arrowIce : ZSSItems.arrowLight), n));
                    world.playSoundAtEntity((Entity)player, "zeldaswordskills:success_magic", 1.0f, 1.0f);
                    if (Config.getArrowsConsumeFlame() && world.rand.nextInt(80) < n) {
                        this.extinguishFlame(world, x, y, z);
                    }
                } else if (stack.getItem() == ZSSItems.crystalSpirit && isActive) {
                    switch (meta) {
                        case 1: {
                            player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.crystalDin));
                            break;
                        }
                        case 2: {
                            player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.crystalFarore));
                            break;
                        }
                        case 4: {
                            player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.crystalNayru));
                        }
                    }
                    world.playSoundAtEntity((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                    this.extinguishFlame(world, x, y, z);
                } else if (isActive) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.random", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.inactive", new Object[0]);
                }
            }
        }
    }

    protected void extinguishFlame(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (Config.getSacredFlameRefreshRate() > 0 && te instanceof TileEntitySacredFlame) {
            int meta = world.getBlockMetadata(x, y, z);
            world.setBlockMetadataWithNotify(x, y, z, meta | 8, 3);
            ((TileEntitySacredFlame)te).extinguish();
        } else {
            world.setBlockToAir(x, y, z);
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 4));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconArray = new IIcon[8];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:fire" + i / 2 + "_layer_" + i % 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFireIcon(int layer, int meta) {
        return this.iconArray[((meta & 8) == 8 ? 6 : (meta == 1 ? 0 : meta)) + layer];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.iconArray[(meta &= 0xFFFFFFF7) == 1 ? 0 : meta];
    }
}

