/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.block.ISongBlock;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.tileentity.TileEntityGossipStone;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.StringUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class BlockGossipStone
extends Block
implements IHookable,
ILiftable,
ISmashable,
ISongBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;

    public BlockGossipStone() {
        super(ZSSBlockMaterials.adventureStone);
        this.setHardness(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setResistance(BlockWeight.IMPOSSIBLE.weight);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityGossipStone();
    }

    @Override
    public Event.Result canDestroyBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    @Override
    public Material getHookableMaterial(IHookable.HookshotType type, World world, int x, int y, int z) {
        return Material.rock;
    }

    @Override
    public BlockWeight getLiftWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta == 0 ? BlockWeight.MEDIUM : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public void onLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int meta) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityGossipStone) {
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            String msg = ((TileEntityGossipStone)te).getMessage();
            stack.getTagCompound().setString("TegsMessage", msg);
        }
    }

    @Override
    public void onHeldBlockPlaced(World world, ItemStack stack, int x, int y, int z, int meta) {
        if (!stack.hasTagCompound() || !stack.getTagCompound().hasKey("TegsMessage")) {
            ZSSMain.logger.warn("Held GossipBlock stack had an invalid NBT tag: unable to set message.");
            return;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityGossipStone) {
            String msg = stack.getTagCompound().getString("TegsMessage");
            ((TileEntityGossipStone)te).setMessage(msg);
        }
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta == 0 ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return world.getBlockMetadata(x, y, z) == 0 ? Event.Result.DEFAULT : Event.Result.DENY;
    }

    @Override
    public boolean onSongPlayed(World world, int x, int y, int z, EntityPlayer player, AbstractZeldaSong song, int power, int affected) {
        TileEntity te = world.getTileEntity(x, y, z);
        return te instanceof TileEntityGossipStone && ((TileEntityGossipStone)te).onSongPlayed(player, song, power, affected);
    }

    public int damageDropped(int meta) {
        return 0;
    }

    public int getMobilityFlag() {
        return 2;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.getBlockMetadata(x, y, z) == 0;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.getBlockMetadata(x, y, z) == 0 ? this.getExplosionResistance(entity) : BlockWeight.getMaxResistance();
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) == 0 ? this.blockHardness : -1.0f;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!world.isRemote && te instanceof TileEntityGossipStone) {
            ItemStack helm = player.getEquipmentInSlot(4);
            if (helm != null && helm.getItem() == ZSSItems.maskTruth) {
                String msg = ((TileEntityGossipStone)te).getMessage();
                if (msg.startsWith("chat.")) {
                    PlayerUtils.sendTranslatedChat(player, msg, new Object[0]);
                } else {
                    String[] messages = StringUtils.wrapString(msg, 64, 5);
                    new TimedChatDialogue(player, messages);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.gossip_stone.silent", new Object[0]);
            }
        }
        return true;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isRemote) {
            return;
        }
        if (PlayerUtils.isSword(player.getHeldItem())) {
            long time = world.getWorldTime();
            long days = world.getTotalWorldTime() / 24000L;
            long current = (time + 6000L) % 24000L;
            int h = (int)(current / 1000L);
            int m = (int)(current % 1000L * 3L / 50L);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.block.gossip_stone.time", String.format("%02d", h), String.format("%02d", m), days);
        } else if (world.getBlockMetadata(x, y, z) > 0 && player.getHeldItem() != null && player.getHeldItem().getItem() instanceof ItemPickaxe) {
            world.playSoundAtEntity((Entity)player, "random.break", 0.25f, 1.0f / (world.rand.nextFloat() * 0.4f + 0.5f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side < 2 ? this.topIcon : this.blockIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        String s = "zeldaswordskills:" + this.getUnlocalizedName().substring(9);
        this.blockIcon = register.registerIcon(s);
        this.topIcon = register.registerIcon(s + "_top");
    }
}

