/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockDungeonStone;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;

public class BlockDungeonCore
extends BlockDungeonStone {
    public BlockDungeonCore(Material material) {
        super(material);
        this.setHardness(1.5f);
        this.setResistance(10.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityDungeonCore();
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) < 8 ? this.blockHardness : -1.0f;
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityDungeonCore) {
            ((TileEntityDungeonCore)te).onBlockBroken();
        }
        super.breakBlock(world, x, y, z, oldBlock, oldMeta);
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) > 7) {
            super.onBlockClicked(world, x, y, z, player);
        }
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.getTileEntity(x, y, z)) instanceof TileEntityDungeonCore) {
            ((TileEntityDungeonCore)te).setSpawner();
        }
        super.onBlockPlacedBy(world, x, y, z, entity, stack);
    }
}

