/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;

public class BlockDoorLocked
extends Block
implements IDungeonBlock {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconUpper;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconLower;

    public BlockDoorLocked(Material material) {
        super(material);
        this.setBlockUnbreakable();
        this.setResistance(BlockWeight.IMPOSSIBLE.weight);
        this.setStepSound(soundTypeMetal);
    }

    public int getMobilityFlag() {
        return 2;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return y >= 255 ? false : World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && super.canPlaceBlockAt(world, x, y, z) && super.canPlaceBlockAt(world, x, y + 1, z);
    }

    protected boolean canUnlock(EntityPlayer player, int meta) {
        ItemStack key = player.getHeldItem();
        if (key != null) {
            if (key.getItem() == ZSSItems.keySmall) {
                return PlayerUtils.consumeHeldItem(player, ZSSItems.keySmall, 1);
            }
            if (key.getItem() == ZSSItems.keySkeleton) {
                key.damageItem(1, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            if (this.canUnlock(player, world.getBlockMetadata(x, y, z))) {
                world.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_door", 0.25f, 1.0f / (world.rand.nextFloat() * 0.4f + 0.5f));
                world.setBlockToAir(x, y, z);
            } else {
                world.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_rattle", 0.25f, 1.0f / (world.rand.nextFloat() * 0.4f + 0.5f));
            }
        }
        return false;
    }

    public void breakBlock(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        if (world.getBlock(x, y += oldMeta > 7 ? -1 : 1, z) == this) {
            world.setBlockToAir(x, y, z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(ZSSItems.doorLockedSmall);
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 && meta > 7 || side == 1 && meta < 8) {
            return this.iconEmpty;
        }
        return meta > 7 ? (side == 1 ? this.iconTop : this.iconUpper) : (side == 0 ? this.iconTop : this.iconLower);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconEmpty = register.registerIcon("zeldaswordskills:empty");
        this.iconTop = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_top");
        this.iconUpper = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_upper");
        this.iconLower = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_lower");
    }
}

