/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockDoorLocked;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;

public class BlockDoorBoss
extends BlockDoorLocked {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconsTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconsUpper;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconsLower;

    public BlockDoorBoss(Material material) {
        super(material);
    }

    @Override
    protected boolean canUnlock(EntityPlayer player, int meta) {
        return PlayerUtils.consumeHeldItem(player, ZSSItems.keyBig, meta & 7, 1) || PlayerUtils.consumeHeldItem(player, ZSSItems.keySkeleton, 0, 1);
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(ZSSItems.doorLocked, 1, world.getBlockMetadata(x, y, z) & 7);
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return (world.getBlockMetadata(x, y, z) & 7) == expected;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 && meta > 7 || side == 1 && meta < 8) {
            return this.iconEmpty;
        }
        return meta > 7 ? (side == 1 ? this.iconsTop[meta % 8] : this.iconsUpper[meta % 8]) : (side == 0 ? this.iconsTop[meta % 8] : this.iconsLower[meta % 8]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconEmpty = register.registerIcon("zeldaswordskills:empty");
        this.iconsTop = new IIcon[8];
        this.iconsUpper = new IIcon[8];
        this.iconsLower = new IIcon[8];
        for (int i = 0; i < 8; ++i) {
            this.iconsTop[i] = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_top" + i);
            this.iconsUpper[i] = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_upper" + i);
            this.iconsLower[i] = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_lower" + i);
        }
    }
}

