/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.tileentity.TileEntityCeramicJar;
import zeldaswordskills.client.render.block.RenderCeramicJar;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityCeramicJar;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.DungeonLootLists;

public class BlockCeramicJar
extends BlockContainer
implements IExplodable,
IHookable,
IQuakeBlock,
ISmashable,
IWhipBlock {
    private static boolean keepInventory;

    public BlockCeramicJar() {
        super(ZSSBlockMaterials.adventureClay);
        this.disableStats();
        this.setBlockUnbreakable();
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
        this.setBlockBounds(0.285f, 0.0f, 0.285f, 0.715f, 0.665f, 0.715f);
    }

    @Override
    public Event.Result canDestroyBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.ALLOW;
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public Material getHookableMaterial(IHookable.HookshotType type, World world, int x, int y, int z) {
        return Material.clay;
    }

    @Override
    public void handleQuakeEffect(World world, int x, int y, int z, EntityPlayer player) {
        WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        world.func_147480_a(x, y, z, false);
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return BlockWeight.VERY_LIGHT;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        world.func_147480_a(x, y, z, false);
        return Event.Result.ALLOW;
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side != 0 && side != 1;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (ticksInGround > 30) {
            ItemStack stack;
            EntityLivingBase thrower = whip.getThrower();
            EntityCeramicJar jar = new EntityCeramicJar(world, whip.posX, whip.posY + 1.0, whip.posZ);
            double dx = thrower.posX - jar.posX;
            double dy = thrower.posY - jar.posY;
            double dz = thrower.posZ - jar.posZ;
            TargetUtils.setEntityHeading((Entity)jar, dx, dy, dz, 1.0f, 1.0f, true);
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof IInventory && (stack = ((IInventory)te).getStackInSlot(0)) != null) {
                jar.setStack(stack);
            }
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)jar);
            }
            keepInventory = true;
            world.setBlockToAir(x, y, z);
            keepInventory = false;
            whip.setDead();
        }
        return Event.Result.DENY;
    }

    public Item getItemDropped(int meta, Random rand, int fortune) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return RenderCeramicJar.renderId;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityCeramicJar();
    }

    public boolean canDropFromExplosion(Explosion explosion) {
        return false;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return world.getBlock(x, y - 1, z).func_149730_j();
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return super.canPlaceBlockAt(world, x, y, z) && this.canBlockStay(world, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (!keepInventory) {
            IInventory inv;
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof IInventory && (inv = (IInventory)te).getStackInSlot(0) == null && world.rand.nextFloat() < Config.getJarDropChance()) {
                inv.setInventorySlotContents(0, ChestGenHooks.getInfo((String)DungeonLootLists.JAR_DROPS).getOneItem(world.rand));
            }
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote && player.getHeldItem() == null) {
            ItemStack invStack;
            ItemStack jarStack = new ItemStack((Block)this);
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof IInventory && (invStack = ((IInventory)te).getStackInSlot(0)) != null) {
                NBTTagCompound item = new NBTTagCompound();
                invStack.writeToNBT(item);
                jarStack.setTagCompound(new NBTTagCompound());
                jarStack.getTagCompound().setTag("jarStack", (NBTBase)item);
            }
            player.setCurrentItemOrArmor(0, jarStack);
            keepInventory = true;
            world.setBlockToAir(x, y, z);
            keepInventory = false;
        }
        return true;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isRemote && PlayerUtils.isHoldingWeapon(player)) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("jarStack") && (te = world.getTileEntity(x, y, z)) instanceof IInventory) {
            ItemStack jarStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("jarStack"));
            ((IInventory)te).setInventorySlotContents(0, jarStack);
        }
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        world.func_147480_a(x, y, z, false);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityArrow || entity instanceof EntityBoomerang || entity instanceof EntityHookShot) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor) {
        if (!this.canBlockStay(world, x, y, z)) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }
}

