/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;

public class BlockBar
extends Block
implements IWhipBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHorizontal;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVertical;

    public BlockBar(Material material) {
        super(material);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(ZSSCreativeTabs.tabBlocks);
        this.setBlockBounds(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        switch (world.getBlockMetadata(x, y, z) % 3) {
            case 0: {
                return side != 4 && side != 5;
            }
            case 1: {
                return side != 2 && side != 3;
            }
            case 2: {
                return side != 0 && side != 1;
            }
        }
        return false;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        return Event.Result.DEFAULT;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        switch (side) {
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: {
                return 0;
            }
            case 0: 
            case 1: {
                return 2;
            }
        }
        return meta;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor) {
        boolean drop = false;
        switch (world.getBlockMetadata(x, y, z) % 3) {
            case 0: {
                Block block1 = world.getBlock(x + 1, y, z);
                Block block2 = world.getBlock(x - 1, y, z);
                drop = !block1.getMaterial().blocksMovement() && !block2.getMaterial().blocksMovement();
                break;
            }
            case 1: {
                Block block1 = world.getBlock(x, y, z + 1);
                Block block2 = world.getBlock(x, y, z - 1);
                drop = !block1.getMaterial().blocksMovement() && !block2.getMaterial().blocksMovement();
                break;
            }
            case 2: {
                Block block1 = world.getBlock(x, y + 1, z);
                Block block2 = world.getBlock(x, y - 1, z);
                boolean bl = drop = !block1.getMaterial().blocksMovement() && !block2.getMaterial().blocksMovement();
            }
        }
        if (drop && !world.isRemote) {
            this.dropBlockAsItem(world, x, y, z, 0, 0);
            world.setBlockToAir(x, y, z);
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        switch (world.getBlockMetadata(x, y, z) % 3) {
            case 0: {
                this.setBlockBounds(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 1.0f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
            }
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        switch (meta % 3) {
            case 0: {
                return side == 4 || side == 5 ? this.blockIcon : this.iconHorizontal;
            }
            case 1: {
                return side == 2 || side == 3 ? this.blockIcon : (side == 4 || side == 5 ? this.iconHorizontal : this.iconVertical);
            }
            case 2: {
                return side == 0 || side == 1 ? this.blockIcon : this.iconVertical;
            }
        }
        return side == 0 || side == 1 ? this.blockIcon : this.iconVertical;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.blockIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_end");
        this.iconHorizontal = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_horizontal");
        this.iconVertical = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + "_vertical");
    }
}

