/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity.ai;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.util.MathHelper;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.api.entity.IEntityCustomTarget;
import zeldaswordskills.api.entity.ai.EntityAIDynamicAction;
import zeldaswordskills.api.entity.ai.EntityAction;

public class EntityAITargetBombs
extends EntityAIDynamicAction.EntityAIDynamicCustomTarget {
    protected final EntityAINearestAttackableTarget.Sorter sorter;
    protected final float range;
    protected Entity targetBomb;
    protected int delay;
    protected int timer;

    public <T extends EntityCreature & IEntityCustomTarget> EntityAITargetBombs(T entity, EntityAction action, float range, boolean require_ground) {
        this(entity, action, range, require_ground, true);
    }

    public <T extends EntityCreature & IEntityCustomTarget> EntityAITargetBombs(T entity, EntityAction action, float range, boolean require_ground, boolean require_sight) {
        super(entity, action, range, require_ground, require_sight);
        this.sorter = new EntityAINearestAttackableTarget.Sorter(entity);
        this.range = range;
    }

    @Override
    public boolean shouldExecute() {
        if (this.actor.getActionTime(this.action.id) > 0) {
            return true;
        }
        if (this.targetBomb != null && !this.targetBomb.isEntityAlive()) {
            this.softReset();
        } else if (super.shouldExecute()) {
            if (this.delay == 0) {
                this.delay = 5 + this.entity.worldObj.rand.nextInt(10) + this.entity.worldObj.rand.nextInt(10);
                if (this.entity.getAttackTarget() != null) {
                    double d = this.entity.getDistanceToEntity((Entity)this.entity.getAttackTarget());
                    this.delay += MathHelper.ceiling_double_int((double)((double)this.range - d));
                }
            }
            return this.timer++ > this.delay;
        }
        return false;
    }

    @Override
    public void startExecuting() {
        this.targeting.setCustomTarget(this.targetBomb);
        super.startExecuting();
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.softReset();
    }

    protected void softReset() {
        this.targeting.setCustomTarget(null);
        this.targetBomb = null;
        this.delay = 0;
        this.timer = 0;
    }

    @Override
    protected Entity getTarget() {
        if (this.targetBomb == null && this.targeting.getCustomTarget() == null) {
            if (this.timer++ < this.entity.getRNG().nextInt(20)) {
                return null;
            }
            List bombs = this.entity.worldObj.getEntitiesWithinAABB(IEntityBomb.class, this.entity.boundingBox.expand((double)this.range, (double)(this.range / 2.0f), (double)this.range));
            Collections.sort(bombs, this.sorter);
            if (!bombs.isEmpty()) {
                this.targetBomb = (Entity)bombs.get(0);
            }
            this.timer = 0;
        }
        return this.targetBomb;
    }
}

