/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public enum MagicType {
    FIRE("fire", true, "textures/blocks/lava_still.png", "zeldaswordskills:magic_fire", "flame"),
    ICE("ice", true, "textures/blocks/ice.png", "zeldaswordskills:magic_ice", "snowshovel"),
    LIGHTNING("lightning", false, "textures/blocks/gold_block.png", "zeldaswordskills:shock", "cloud"),
    WATER("water", false, "textures/blocks/water_still.png", "random.splash", "splash"),
    WIND("wind", false, "textures/blocks/emerald_block.png", "zeldaswordskills:whirlwind", "cloud");

    private final String unlocalizedName;
    private final boolean affectsBlocks;
    private final ResourceLocation texture;
    private final String moveSound;
    private final String trailingParticle;

    private MagicType(String name, boolean affectsBlocks, String texture, String moveSound, String trailingParticle) {
        this.unlocalizedName = name;
        this.affectsBlocks = affectsBlocks;
        this.texture = new ResourceLocation(texture);
        this.moveSound = moveSound;
        this.trailingParticle = trailingParticle;
    }

    public String toString() {
        return StatCollector.translateToLocal((String)("magic." + this.unlocalizedName + ".name"));
    }

    public boolean affectsBlocks(World world, EntityLivingBase caster) {
        return this.affectsBlocks && (caster instanceof EntityPlayer || world.getGameRules().getGameRuleBooleanValue("mobGriefing"));
    }

    public ResourceLocation getEntityTexture() {
        return this.texture;
    }

    public String getMovingSound() {
        return this.moveSound;
    }

    public int getSoundFrequency() {
        switch (this) {
            case FIRE: {
                return 12;
            }
            case ICE: {
                return 4;
            }
            case WIND: {
                return 5;
            }
        }
        return 6;
    }

    public float getSoundVolume(Random rand) {
        switch (this) {
            case ICE: {
                return 0.5f + rand.nextFloat();
            }
            case WIND: {
                return 0.6f;
            }
        }
        return 1.0f + rand.nextFloat();
    }

    public float getSoundPitch(Random rand) {
        switch (this) {
            case ICE: {
                return rand.nextFloat() * 0.4f + 0.8f;
            }
            case WIND: {
                return 1.0f;
            }
        }
        return rand.nextFloat() * 0.7f + 0.3f;
    }

    public String getTrailingParticle() {
        return this.trailingParticle;
    }
}

