/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import net.minecraft.item.ItemStack;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.WorldUtils;

public enum BombType {
    BOMB_STANDARD("standard", CustomExplosion.IgnoreLiquid.NONE),
    BOMB_WATER("water", CustomExplosion.IgnoreLiquid.WATER),
    BOMB_FIRE("fire", CustomExplosion.IgnoreLiquid.LAVA),
    BOMB_FLOWER("flower", CustomExplosion.IgnoreLiquid.NONE);

    public final String unlocalizedName;
    public final CustomExplosion.IgnoreLiquid ignoreLiquidType;

    private BombType(String name, CustomExplosion.IgnoreLiquid ignoreLiquidType) {
        this.unlocalizedName = name;
        this.ignoreLiquidType = ignoreLiquidType;
    }

    public void postExplosionEffect(World world, Explosion explosion) {
        if (this == BOMB_FLOWER) {
            this.disperseSeeds(world, explosion.explosionX, explosion.explosionY, explosion.explosionZ);
        }
    }

    private void disperseSeeds(World world, double x, double y, double z) {
        int n = world.rand.nextInt(3) + 1;
        for (int i = 0; i < n; ++i) {
            WorldUtils.spawnItemWithRandom(world, new ItemStack(ZSSItems.bombFlowerSeed), x, y, z, 0.15f);
        }
    }
}

