/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

public interface IProgressType {
    public static final IProgressType LINEAR = new IProgressType(){

        @Override
        public float getProgress(float x) {
            return x;
        }
    };
    public static final IProgressType SQRT = new ProgressTypeRoot(2);
    public static final IProgressType ROOT_CUBE = new ProgressTypeRoot(3);
    public static final IProgressType SQUARED = new ProgressTypeExponential(2);
    public static final IProgressType CUBED = new ProgressTypeExponential(3);
    public static final IProgressType POWER_4 = new ProgressTypeExponential(4);

    public float getProgress(float var1);

    public static class ProgressTypeRoot
    implements IProgressType {
        private final int n;

        public ProgressTypeRoot(int n) {
            this.n = n;
        }

        @Override
        public float getProgress(float x) {
            switch (this.n) {
                case 1: {
                    return x;
                }
                case 2: {
                    return (float)Math.sqrt(x);
                }
                case 3: {
                    return (float)Math.cbrt(x);
                }
            }
            return x <= 0.0f ? 0.0f : (float)Math.exp(Math.log(x) / (double)this.n);
        }
    }

    public static class ProgressTypeExponential
    implements IProgressType {
        private final int n;

        public ProgressTypeExponential(int n) {
            this.n = n;
        }

        @Override
        public float getProgress(float x) {
            return (float)Math.pow(x, this.n);
        }
    }
}

