/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import zeldaswordskills.ZSSMain;

public class DirtyEntityAccessor {
    public static void damageEntity(EntityLivingBase target, DamageSource source, float amount) {
        target.damageEntity(source, amount);
    }

    public static float getModifiedDamage(EntityLivingBase entity, DamageSource source, float amount) {
        if (!source.isUnblockable()) {
            int armor = 25 - entity.getTotalArmorValue();
            amount = amount * (float)armor / 25.0f;
        }
        amount = entity.applyPotionDamageCalculations(source, amount);
        return Math.max(amount - entity.getAbsorptionAmount(), 0.0f);
    }

    public static void setLivingXp(EntityLiving entity, int xp, boolean add) {
        entity.experienceValue = add ? entity.experienceValue + xp : xp;
    }

    public static void setSize(Entity entity, float width, float height) {
        NBTTagCompound compound = entity.getEntityData();
        compound.setFloat("origWidth", entity.width);
        compound.setFloat("origHeight", entity.height);
        entity.setSize(width, height);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).eyeHeight = 0.85f * height;
        }
    }

    public static void restoreOriginalSize(Entity entity) {
        NBTTagCompound compound = entity.getEntityData();
        if (compound.hasKey("origWidth") && compound.hasKey("origHeight")) {
            entity.setSize(compound.getFloat("origWidth"), compound.getFloat("origHeight"));
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).eyeHeight = ((EntityPlayer)entity).getDefaultEyeHeight();
            }
        } else {
            ZSSMain.logger.warn("Attempted to restore original size without any available data");
        }
    }
}

