/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.worldgen;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class ComponentVillageBookShop
extends StructureVillagePieces.Village {
    public static WeightedRandomChestContent[] bookshopChestContents = null;
    private boolean hasMadeChest;

    public static ComponentVillageBookShop construct(StructureVillagePieces.Start start, List pieces, Random rand, int p1, int p2, int p3, int p4, int p5) {
        StructureBoundingBox bounds = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)10, (int)8, (int)9, (int)p4);
        return ComponentVillageBookShop.canVillageGoDeeper((StructureBoundingBox)bounds) && StructureComponent.findIntersecting((List)pieces, (StructureBoundingBox)bounds) == null ? new ComponentVillageBookShop(start, p5, rand, bounds, p4) : null;
    }

    public ComponentVillageBookShop() {
    }

    public ComponentVillageBookShop(StructureVillagePieces.Start start, int componentType, Random rand, StructureBoundingBox bounds, int coordMode) {
        super(start, componentType);
        this.coordBaseMode = coordMode;
        this.boundingBox = bounds;
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox bounds) {
        int i;
        int height = 8;
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.getAverageGroundLevel(world, bounds);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.field_143015_k - this.boundingBox.maxY + 8 - 1, 0);
        }
        this.fillWithBlocks(world, bounds, 1, 0, 1, 8, 0, 6, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, bounds, 2, 0, 2, 7, 0, 5, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, bounds, 1, 1, 0, 8, 7, 6, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, bounds, 1, 1, 3, 8, 5, 6, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, bounds, 1, 6, 4, 8, 6, 5, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, bounds, 1, 4, 1, 8, 4, 2, Blocks.cobblestone, Blocks.cobblestone, false);
        this.fillWithBlocks(world, bounds, 2, 1, 4, 7, 4, 5, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, bounds, 2, 1, 3, 7, 3, 3, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, bounds, 3, 2, 3, 6, 3, 3, Blocks.air, Blocks.air, false);
        this.placeBlockAtCurrentPosition(world, Blocks.air, 0, 6, 1, 3, bounds);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 3, 4, 4, bounds);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 6, 4, 4, bounds);
        this.fillWithBlocks(world, bounds, 1, 2, 4, 1, 4, 5, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, bounds, 8, 2, 4, 8, 4, 5, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, bounds, 2, 2, 6, 7, 4, 6, Blocks.planks, Blocks.planks, false);
        this.fillWithBlocks(world, bounds, 1, 1, 1, 1, 3, 1, Blocks.fence, Blocks.fence, false);
        this.fillWithBlocks(world, bounds, 8, 1, 1, 8, 3, 1, Blocks.fence, Blocks.fence, false);
        int n = this.getMetadataWithOffset(Blocks.oak_stairs, 3);
        int s = this.getMetadataWithOffset(Blocks.oak_stairs, 2);
        int w = this.getMetadataWithOffset(Blocks.oak_stairs, 0);
        int e = this.getMetadataWithOffset(Blocks.oak_stairs, 1);
        this.placeBlockAtCurrentPosition(world, Blocks.stone_stairs, n, 3, 0, 0, bounds);
        this.placeBlockAtCurrentPosition(world, Blocks.stone_stairs, n, 4, 0, 0, bounds);
        this.placeBlockAtCurrentPosition(world, Blocks.stone_stairs, n, 5, 0, 0, bounds);
        this.placeBlockAtCurrentPosition(world, Blocks.stone_stairs, n, 6, 0, 0, bounds);
        for (i = 1; i <= 8; ++i) {
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, n, i, 5, 2, bounds);
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, n, i, 6, 3, bounds);
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, n, i, 7, 4, bounds);
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, s, i, 5, 7, bounds);
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, s, i, 6, 6, bounds);
            this.placeBlockAtCurrentPosition(world, Blocks.oak_stairs, s, i, 7, 5, bounds);
        }
        if (!this.hasMadeChest) {
            int k;
            i = this.getYWithOffset(1);
            int j = this.getXWithOffset(2, 4);
            if (bounds.isVecInside(j, i, k = this.getZWithOffset(2, 4))) {
                Log.instance().debug(String.format("Bookshop %d %d %d - dir %d", i, j, k, this.coordBaseMode));
                if (bookshopChestContents == null) {
                    ArrayList<WeightedRandomChestContent> list = new ArrayList<WeightedRandomChestContent>();
                    list.add(new WeightedRandomChestContent(Items.book, 0, 1, 1, 1));
                    list.add(new WeightedRandomChestContent((Item)Witchery.Items.GENERIC, Witchery.Items.GENERIC.itemVampireBookPage.damageValue, 1, 1, 3));
                    list.add(new WeightedRandomChestContent((Item)Witchery.Items.GENERIC, Witchery.Items.GENERIC.itemVampireBookPage.damageValue, 1, 1, 2));
                    list.add(new WeightedRandomChestContent((Item)Witchery.Items.GENERIC, Witchery.Items.GENERIC.itemVampireBookPage.damageValue, 1, 1, 1));
                    for (String bonusBook : Config.instance().townBooks) {
                        try {
                            Item item;
                            String name = bonusBook;
                            int meta = 0;
                            int comma = bonusBook.lastIndexOf(44);
                            if (comma >= 0) {
                                name = bonusBook.substring(0, comma);
                                String metaString = bonusBook.substring(comma + 1);
                                meta = Integer.parseInt(metaString);
                            }
                            if ((item = (Item)Item.itemRegistry.getObject(name)) == null) continue;
                            list.add(new WeightedRandomChestContent(item, meta, 1, 1, 1));
                        }
                        catch (Throwable ex) {
                            // empty catch block
                        }
                    }
                    bookshopChestContents = list.toArray(new WeightedRandomChestContent[list.size()]);
                }
                this.hasMadeChest = true;
                this.generateStructureChestContents(world, bounds, rand, 2, 1, 4, bookshopChestContents, 5 + rand.nextInt(6), new ItemStack[]{new ItemStack(Witchery.Items.VAMPIRE_BOOK)});
                this.addBookInFrame(world, 3, 3, 6, ComponentVillageBookShop.bookshopChestContents[rand.nextInt((int)ComponentVillageBookShop.bookshopChestContents.length)].theItemId.copy());
                this.addBookInFrame(world, 4, 3, 6, ComponentVillageBookShop.bookshopChestContents[rand.nextInt((int)ComponentVillageBookShop.bookshopChestContents.length)].theItemId.copy());
                this.addBookInFrame(world, 5, 3, 6, ComponentVillageBookShop.bookshopChestContents[rand.nextInt((int)ComponentVillageBookShop.bookshopChestContents.length)].theItemId.copy());
                this.addBookInFrame(world, 6, 3, 6, ComponentVillageBookShop.bookshopChestContents[rand.nextInt((int)ComponentVillageBookShop.bookshopChestContents.length)].theItemId.copy());
            }
        }
        for (int j = 1; j < 7; ++j) {
            for (int k = 1; k < 7; ++k) {
                this.clearCurrentPositionBlocksUpwards(world, k, 8, j, bounds);
                this.func_151554_b(world, Blocks.cobblestone, 0, k, -1, j, bounds);
            }
        }
        return true;
    }

    private boolean generateStructureChestContents(World world, StructureBoundingBox bounds, Random rand, int x, int y, int z, WeightedRandomChestContent[] contents, int quantity, ItemStack[] extraItems) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(x, z);
        if (bounds.isVecInside(i1, j1 = this.getYWithOffset(y), k1 = this.getZWithOffset(x, z)) && world.getBlock(i1, j1, k1) != Blocks.chest) {
            world.setBlock(i1, j1, k1, (Block)Blocks.chest, 0, 2);
            TileEntityChest chest = (TileEntityChest)world.getTileEntity(i1, j1, k1);
            if (chest != null) {
                WeightedRandomChestContent.generateChestContents((Random)rand, (WeightedRandomChestContent[])contents, (IInventory)chest, (int)quantity);
                if (extraItems != null) {
                    for (ItemStack stack : extraItems) {
                        chest.setInventorySlotContents(rand.nextInt(chest.getSizeInventory()), stack.copy());
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void addBookInFrame(World world, int x, int y, int z, ItemStack stack) {
        int xWorld = this.getXWithOffset(x, z);
        int yWorld = this.getYWithOffset(y);
        int zWorld = this.getZWithOffset(x, z);
        int direction = 0;
        switch (this.coordBaseMode) {
            default: {
                direction = 2;
                break;
            }
            case 1: {
                direction = 3;
                break;
            }
            case 2: {
                direction = 0;
                break;
            }
            case 3: {
                direction = 1;
            }
        }
        EntityItemFrame frame = new EntityItemFrame(world, xWorld, yWorld, zWorld, direction);
        if (frame != null && frame.onValidSurface() && !world.isRemote) {
            world.spawnEntityInWorld((Entity)frame);
            frame.setDisplayedItem(stack);
        }
    }

    protected void func_143012_a(NBTTagCompound nbtRoot) {
        super.func_143012_a(nbtRoot);
        nbtRoot.setBoolean("Chest", this.hasMadeChest);
    }

    protected void func_143011_b(NBTTagCompound nbtRoot) {
        super.func_143011_b(nbtRoot);
        this.hasMadeChest = nbtRoot.getBoolean("Chest");
    }
}

