/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.util;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityHornedHuntsman;
import com.emoniph.witchery.entity.ai.EntityAIAttackOnCollide2;
import com.emoniph.witchery.network.PacketPushTarget;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.Log;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EntityUtil {
    private static Field fieldTrackedEntities = null;
    public static Field fieldGhastTargetedEntity;
    public static Field fieldGhastAggroCooldown;

    private EntityUtil() {
    }

    public static EntityPlayer playerOrFake(World world, String thrower) {
        return EntityUtil.playerOrFake(world, world != null ? world.getPlayerEntityByName(thrower) : null);
    }

    public static EntityPlayer playerOrFake(World world, EntityLivingBase entity) {
        if (entity != null && entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        if (world == null || !(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
    }

    public static <T extends Entity> T findNearestEntityWithinAABB(World world, Class<T> clazz, AxisAlignedBB bounds, Entity entity) {
        Entity foundEntity = world.findNearestEntityWithinAABB(clazz, bounds, entity);
        if (foundEntity != null) {
            return (T)foundEntity;
        }
        return null;
    }

    public static void spawnEntityInWorld(World world, Entity entity) {
        if (entity != null && world != null && !world.isRemote) {
            world.spawnEntityInWorld(entity);
        }
    }

    public static void correctProjectileTrackerSync(World world, Entity projectile) {
        block6: {
            if (!world.isRemote && world instanceof WorldServer) {
                try {
                    if (fieldTrackedEntities == null) {
                        fieldTrackedEntities = ReflectionHelper.findField(EntityTracker.class, (String[])new String[]{"trackedEntities", "field_72793_b", "b"});
                    }
                    if (fieldTrackedEntities == null) break block6;
                    EntityTracker tracker = ((WorldServer)world).getEntityTracker();
                    Set trackedEntities = (Set)fieldTrackedEntities.get(tracker);
                    for (EntityTrackerEntry next : trackedEntities) {
                        if (next.myEntity != projectile) continue;
                        next.ticks = 1;
                        break;
                    }
                }
                catch (IllegalAccessException e) {
                    Log.instance().warning(e, "Exception occurred setting entity tracking for bolt.");
                }
                catch (Exception e) {
                    Log.instance().debug(String.format("Exception occurred setting entity tracking for bolt. %s", e.toString()));
                }
            }
        }
    }

    public static void push(World world, Entity entity, EntityPosition position, double power) {
        Entity entity2 = entity;
        double d = position.x - entity2.posX;
        double d1 = position.y - entity2.posY;
        double d2 = position.z - entity2.posZ;
        double d4 = d * d + d1 * d1 + d2 * d2;
        if ((d4 *= d4) <= Math.pow(6.0, 4.0)) {
            double d5 = -(d * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
            double d6 = -(d1 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
            double d7 = -(d2 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
            if (d5 > 0.0) {
                d5 = 0.22;
            } else if (d5 < 0.0) {
                d5 = -0.22;
            }
            if (d6 > 0.2) {
                d6 = 0.12;
            } else if (d6 < -0.1) {
                d6 = 0.12;
            }
            if (d7 > 0.0) {
                d7 = 0.22;
            } else if (d7 < 0.0) {
                d7 = -0.22;
            }
            entity2.motionX += d5 * power;
            entity2.motionY += d6 * (power / 3.0);
            entity2.motionZ += d7 * power;
        }
    }

    public static void pullTowards(World world, Entity entity, EntityPosition target, double dy, double yy) {
        if (entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || target.occupiedBy(entity)) {
            return;
        }
        double d = target.x - entity.posX;
        double d1 = target.y - entity.posY;
        double d2 = target.z - entity.posZ;
        float distance = MathHelper.sqrt_double((double)(d * d + d1 * d1 + d2 * d2));
        if ((double)distance < 0.01) {
            return;
        }
        float f2 = 0.1f + (float)dy;
        double mx = d / (double)distance * (double)f2 * (double)distance;
        double my = yy == 0.0 ? 0.4 : d1 / (double)distance * (double)distance * 0.2 + 0.2 + yy;
        double mz = d2 / (double)distance * (double)f2 * (double)distance;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.jump.id, 20, 1));
        }
        if (entity instanceof EntityPlayer) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(mx, my, mz), (EntityPlayer)entity);
        } else {
            entity.motionX = mx;
            entity.motionY = my;
            entity.motionZ = mz;
        }
    }

    public static void pushback(World world, Entity entity, EntityPosition hit, double xyScale, double ySpeed) {
        double d = hit.x - entity.posX;
        double d1 = hit.y - entity.posY;
        double d2 = hit.z - entity.posZ;
        Vec3 vec = Vec3.createVectorHelper((double)d, (double)d1, (double)d2).normalize();
        double dx = -vec.xCoord * xyScale;
        double dy = Math.max(-vec.yCoord, ySpeed);
        double dz = -vec.zCoord * xyScale;
        if (entity instanceof EntityPlayer) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(dx, dy, dz), (EntityPlayer)entity);
        } else {
            entity.motionX = dx;
            entity.motionY = dy;
            entity.motionZ = dz;
        }
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, TileEntity tile, double radius) {
        return EntityUtil.getEntitiesInRadius(clazz, tile.getWorldObj(), 0.5 + (double)tile.xCoord, 0.5 + (double)tile.yCoord, 0.5 + (double)tile.zCoord, radius);
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, World world, double x, double y, double z, double radius) {
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius));
        List entities = world.getEntitiesWithinAABB(clazz, bounds);
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity.getDistanceSq(x, entity.posY, z) <= radiusSq)) continue;
            nearbyEntities.add(entity);
        }
        return nearbyEntities;
    }

    public static void setTarget(EntityLiving attacker, EntityLivingBase victim) {
        attacker.setAttackTarget(victim);
        if (attacker instanceof EntityGhast) {
            try {
                EntityGhast ghastEntity = (EntityGhast)attacker;
                if (fieldGhastTargetedEntity == null) {
                    fieldGhastTargetedEntity = ReflectionHelper.findField(EntityGhast.class, (String[])new String[]{"targetedEntity", "field_70792_g", "g"});
                }
                fieldGhastTargetedEntity.set(ghastEntity, victim);
                if (fieldGhastAggroCooldown == null) {
                    fieldGhastAggroCooldown = ReflectionHelper.findField(EntityGhast.class, (String[])new String[]{"aggroCooldown", "field_70798_h", "h"});
                }
                fieldGhastAggroCooldown.set(ghastEntity, 20000);
            }
            catch (IllegalAccessException e) {
                Log.instance().warning(e, "Exception occurred setting ghast target.");
            }
            catch (Exception e) {
                Log.instance().debug(String.format("Exception occurred setting ghast target. %s", e.toString()));
            }
        }
        if (attacker instanceof EntityCreature) {
            EntityCreature attackerCreature = (EntityCreature)attacker;
            attackerCreature.setTarget((Entity)victim);
            attackerCreature.setRevengeTarget(victim);
            if (attackerCreature instanceof EntityZombie || attackerCreature instanceof EntityCreeper) {
                boolean found = false;
                Class<?> victimClass = victim.getClass();
                for (Object obj : attackerCreature.targetTasks.taskEntries) {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                    if (!(task.action instanceof EntityAIAttackOnCollide2)) continue;
                    EntityAIAttackOnCollide2 ai = (EntityAIAttackOnCollide2)task.action;
                    if (ai == null || !ai.appliesToClass(victimClass)) break;
                    found = true;
                    break;
                }
                if (!found) {
                    attacker.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide2(attackerCreature, victimClass, 1.0, false));
                }
            }
        }
    }

    public static void dropAttackTarget(EntityLiving entity) {
        entity.setAttackTarget(null);
        if (entity instanceof EntityCreature) {
            EntityCreature creatureEntity = (EntityCreature)entity;
            creatureEntity.setTarget(null);
            creatureEntity.setRevengeTarget(null);
        }
    }

    public static void syncInventory(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
        }
    }

    public static void persistanceRequired(EntityLiving entity) {
        entity.func_110163_bv();
    }

    public static void setNoDrops(EntityLiving entity) {
        if (entity != null) {
            NBTTagCompound nbtEntity = entity.getEntityData();
            nbtEntity.setBoolean("WITCNoDrops", true);
        }
    }

    public static boolean isNoDrops(EntityLivingBase entity) {
        if (entity == null || entity instanceof EntityPlayer) {
            return false;
        }
        NBTTagCompound nbtEntity = entity.getEntityData();
        return nbtEntity.getBoolean("WITCNoDrops");
    }

    public static float getHealthAfterDamage(LivingHurtEvent event, float currentHealth, EntityLivingBase entity) {
        float j;
        if (event.source.isUnblockable()) {
            return currentHealth - event.ammount;
        }
        float damage = event.ammount;
        int i = 25 - entity.getTotalArmorValue();
        float f1 = damage * (float)i;
        damage = f1 / 25.0f;
        if (entity.isPotionActive(Potion.resistance) && event.source != DamageSource.outOfWorld) {
            i = (entity.getActivePotionEffect(Potion.resistance).getAmplifier() + 1) * 5;
            j = 25 - i;
            f1 = damage * j;
            damage = f1 / 25.0f;
        }
        if (damage <= 0.0f) {
            damage = 0.0f;
        } else {
            i = EnchantmentHelper.getEnchantmentModifierDamage((ItemStack[])entity.getLastActiveItems(), (DamageSource)event.source);
            if (i > 20) {
                i = 20;
            }
            if (i > 0 && i <= 20) {
                j = 25 - i;
                f1 = damage * j;
                damage = f1 / 25.0f;
            }
        }
        return currentHealth - damage;
    }

    public static void instantDeath(EntityLivingBase entity, EntityLivingBase attacker) {
        if (entity != null && entity.worldObj != null && !entity.worldObj.isRemote) {
            if (entity instanceof EntityLiving) {
                entity.setHealth(0.0f);
                if (attacker == null) {
                    entity.onDeath(DamageSource.magic);
                } else {
                    entity.onDeath((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)attacker));
                }
                entity.setDead();
            } else if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.capabilities.isCreativeMode) {
                    if (player.isPlayerSleeping()) {
                        player.wakeUpPlayer(true, true, false);
                    }
                    entity.setHealth(0.0f);
                    if (ExtendedPlayer.get(player).isVampire()) {
                        entity.onDeath((DamageSource)(attacker == null ? DamageSourceSunlight.SUN : new DamageSourceSunlight((Entity)attacker)));
                    } else {
                        entity.onDeath((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)attacker));
                    }
                }
            }
        }
    }

    public static boolean touchOfDeath(Entity victim, EntityLivingBase attacker, float damage) {
        if (victim != null && victim.isEntityInvulnerable()) {
            return false;
        }
        if (victim != null && victim.worldObj != null && !victim.worldObj.isRemote) {
            if (victim instanceof EntityLiving) {
                EntityDamageSource source = new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)attacker);
                EntityLiving creature = (EntityLiving)victim;
                float cap = 10000.0f;
                if (victim instanceof IHandleDT) {
                    cap = ((IHandleDT)victim).getCapDT((DamageSource)source, damage);
                    if (cap <= 0.0f) {
                        return false;
                    }
                    if (attacker instanceof EntityLiving) {
                        cap = Math.min(6.0f, cap);
                    }
                }
                creature.attackEntityFrom((DamageSource)source, 0.0f);
                creature.setHealth(Math.max(creature.getHealth() - Math.min(damage, cap), 0.0f));
                creature.attackEntityFrom((DamageSource)source, 0.0f);
            } else if (victim instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)victim;
                if (!player.capabilities.isCreativeMode) {
                    player.setHealth(Math.max(player.getHealth() - damage, 0.0f));
                    if (player.getHealth() <= 0.0f) {
                        if (attacker == null) {
                            player.onDeath(DamageSource.magic);
                        } else {
                            player.onDeath((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)attacker));
                        }
                    } else {
                        player.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)attacker), 0.0f);
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean moveToBlockPositionAndUpdate(EntityLiving entity, int x, int y, int z, int maxDY) {
        World world = entity.worldObj;
        boolean done = false;
        int mod = 0;
        int sign = -1;
        while (!done && mod <= 2 * maxDY && y < 250 && y > 2) {
            if (BlockUtil.isNormalCube(world.getBlock(x, y, z)) && world.isAirBlock(x, y + 1, z) && world.isAirBlock(x, y + 2, z)) {
                done = true;
                continue;
            }
            y += ++mod * (sign *= -1);
        }
        if (done) {
            entity.setPositionAndUpdate(0.5 + (double)x, 1.05 + (double)y, 0.5 + (double)z);
        }
        return done;
    }

    public static class DamageSourceVampireFire
    extends DamageSource {
        public static final DamageSourceVampireFire SOURCE = new DamageSourceVampireFire();

        public DamageSourceVampireFire() {
            super("onFire");
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }
    }

    public static class DamageSourceSunlight
    extends EntityDamageSource {
        public static final DamageSourceSunlight SUN = new DamageSourceSunlight(null);

        public DamageSourceSunlight(Entity attacker) {
            super("sun", attacker);
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }

        public IChatComponent func_151519_b(EntityLivingBase p_151519_1_) {
            EntityLivingBase entitylivingbase1 = p_151519_1_.func_94060_bK();
            String s = "witchery:death.attack." + this.damageType;
            String s1 = s + ".player";
            return entitylivingbase1 != null && StatCollector.canTranslate((String)s1) ? new ChatComponentTranslation(s1, new Object[]{p_151519_1_.func_145748_c_(), entitylivingbase1.func_145748_c_()}) : new ChatComponentTranslation(s, new Object[]{p_151519_1_.func_145748_c_()});
        }
    }
}

