/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;

public class RitePriorIncarnation
extends Rite {
    private static final String PRIOR_INV_KEY = "WITCPriIncInv";
    private static final String PRIOR_USR_KEY = "WITCPriIncUsr";
    private static final String PRIOR_LOC_KEY = "WITCPriIncLoc";
    private final int radius;
    private final int aoe;

    public static boolean isRiteAllowed() {
        return Config.instance().allowDeathItemRecoveryRite && !Witchery.isDeathChestModInstalled;
    }

    public RitePriorIncarnation(int radius, int aoe) {
        this.radius = radius;
        this.aoe = aoe;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, int initialStage) {
        steps.add(new StepPriorIncarnation(this, initialStage));
    }

    private static class StepPriorIncarnation
    extends RitualStep {
        private final RitePriorIncarnation rite;
        private int stage = 0;

        public StepPriorIncarnation(RitePriorIncarnation rite, int initialStage) {
            super(false);
            this.rite = rite;
            this.stage = initialStage;
        }

        @Override
        public int getCurrentStage() {
            return this.stage;
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (!RitePriorIncarnation.isRiteAllowed() || world.getGameRules().getGameRuleBooleanValue("keepInventory")) {
                EntityPlayer player = ritual.getInitiatingPlayer(world);
                if (player != null) {
                    ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.disabled", new Object[0]);
                }
                return RitualStep.Result.ABORTED_REFUND;
            }
            if (this.stage == 0 && ticks % 20L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (!world.isRemote) {
                int r = this.rite.radius;
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(posX - r), (double)posY, (double)(posZ - r), (double)(posX + r), (double)(posY + 1), (double)(posZ + r));
                boolean found = false;
                for (Object obj : world.getEntitiesWithinAABB(EntityPlayer.class, bounds)) {
                    EntityPlayer player = (EntityPlayer)obj;
                    if (!(Coord.distance(player.posX, player.posY, player.posZ, posX, posY, posZ) <= (double)r)) continue;
                    NBTTagCompound nbt = Infusion.getNBT((Entity)player);
                    if (Config.instance().traceRites()) {
                        Log.instance().debug(String.format("Prior invocation for %s", player.getCommandSenderName()));
                    }
                    if (!nbt.hasKey(RitePriorIncarnation.PRIOR_INV_KEY) || !nbt.hasKey("WITCPriIncLocX") || !nbt.hasKey("WITCPriIncLocY") || !nbt.hasKey("WITCPriIncLocZ")) continue;
                    NBTTagList tagList = nbt.getTagList(RitePriorIncarnation.PRIOR_INV_KEY, 10);
                    double x = nbt.getDouble("WITCPriIncLocX");
                    double y = nbt.getDouble("WITCPriIncLocY");
                    double z = nbt.getDouble("WITCPriIncLocZ");
                    double dSq = Coord.distanceSq(posX, posY, posZ, x, y, z);
                    if (Config.instance().traceRites()) {
                        Log.instance().debug(String.format("Distance to death %f items %d", Math.sqrt(dSq), tagList.tagCount()));
                    }
                    if (!(dSq <= (double)(this.rite.aoe * this.rite.aoe)) || tagList.tagCount() <= 0) continue;
                    if (Config.instance().traceRites()) {
                        Log.instance().debug(String.format("Recovering %d items", tagList.tagCount()));
                    }
                    for (int i = 0; i < tagList.tagCount(); ++i) {
                        NBTTagCompound baseTag = tagList.getCompoundTagAt(i);
                        if (baseTag != null && baseTag instanceof NBTTagCompound) {
                            NBTTagCompound tag = baseTag;
                            ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
                            if (stack != null) {
                                if (Config.instance().traceRites()) {
                                    Log.instance().debug(String.format(" - Recovered %s", stack.toString()));
                                }
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)posX, (double)posY, (double)posZ, stack));
                                continue;
                            }
                            Log.instance().warning("Prior Incarnation stack is null");
                            continue;
                        }
                        Log.instance().warning("Prior Incarnation item has incorrect NBT type or is null " + baseTag);
                    }
                    EntitySkeleton skeleton = new EntitySkeleton(world);
                    skeleton.setLocationAndAngles((double)posX, (double)posY, (double)posZ, 0.0f, 0.0f);
                    skeleton.setCustomNameTag(player.getCommandSenderName());
                    world.spawnEntityInWorld((Entity)skeleton);
                    nbt.removeTag(RitePriorIncarnation.PRIOR_INV_KEY);
                    nbt.removeTag("WITCPriIncLocX");
                    nbt.removeTag("WITCPriIncLocY");
                    nbt.removeTag("WITCPriIncLocZ");
                    found = true;
                }
                if (found) {
                    ParticleEffect.HUGE_EXPLOSION.send(SoundEffect.RANDOM_FIZZ, world, posX, posY, posZ, 3.0, 3.0, 16);
                } else {
                    ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, world, posX, posY, posZ, 1.0, 2.0, 16);
                }
            }
            return RitualStep.Result.COMPLETED;
        }
    }

    public static class EventHooks {
        @SubscribeEvent
        public void onItemExpire(ItemExpireEvent event) {
            String username;
            ItemStack stack;
            NBTTagCompound nbtItem;
            if (event.entityItem != null && !event.entityItem.worldObj.isRemote && RitePriorIncarnation.isRiteAllowed() && !event.isCanceled() && (nbtItem = (stack = event.entityItem.getEntityItem()).getTagCompound()) != null && nbtItem.hasKey(RitePriorIncarnation.PRIOR_USR_KEY) && (username = nbtItem.getString(RitePriorIncarnation.PRIOR_USR_KEY)) != null && !username.isEmpty()) {
                MinecraftServer server = MinecraftServer.getServer();
                for (WorldServer world : server.worldServers) {
                    NBTTagCompound nbt;
                    EntityPlayer player = world.getPlayerEntityByName(username);
                    if (player == null) continue;
                    if (Config.instance().traceRites()) {
                        Log.instance().debug(String.format("Saving stack %s for player %s", stack.toString(), player.getCommandSenderName()));
                    }
                    if (!(nbt = Infusion.getNBT((Entity)player)).hasKey(RitePriorIncarnation.PRIOR_INV_KEY)) {
                        NBTTagList tagList = new NBTTagList();
                        nbt.setTag(RitePriorIncarnation.PRIOR_INV_KEY, (NBTBase)tagList);
                    }
                    NBTTagList list = nbt.getTagList(RitePriorIncarnation.PRIOR_INV_KEY, 10);
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    nbtItem.removeTag(RitePriorIncarnation.PRIOR_USR_KEY);
                    if (nbtItem.hasNoTags()) {
                        stack.setTagCompound(null);
                    }
                    stack.writeToNBT(tagCompound);
                    list.appendTag((NBTBase)tagCompound);
                    break;
                }
            }
        }

        @SubscribeEvent
        public void onEntityItemPickup(EntityItemPickupEvent event) {
            if (!event.item.worldObj.isRemote && RitePriorIncarnation.isRiteAllowed() && !event.isCanceled()) {
                ItemStack stack = event.item.getEntityItem();
                EventHooks.removePriorUserTag(stack);
            }
        }

        public static void removePriorUserTag(ItemStack stack) {
            NBTTagCompound nbtItem;
            if (stack != null && (nbtItem = stack.getTagCompound()) != null && nbtItem.hasKey(RitePriorIncarnation.PRIOR_USR_KEY)) {
                if (Config.instance().traceRites()) {
                    Log.instance().debug(String.format("removing prio incarnation tag for player %s", nbtItem.getString(RitePriorIncarnation.PRIOR_USR_KEY)));
                }
                nbtItem.removeTag(RitePriorIncarnation.PRIOR_USR_KEY);
                if (nbtItem.hasNoTags()) {
                    stack.setTagCompound(null);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerDrops(PlayerDropsEvent event) {
            if (event.entityPlayer != null && !event.entityPlayer.worldObj.isRemote && event.entityPlayer.isPotionActive(Witchery.Potions.KEEP_INVENTORY)) {
                event.setCanceled(true);
                return;
            }
            if (event.entityPlayer != null && !event.entityPlayer.worldObj.isRemote && RitePriorIncarnation.isRiteAllowed() && !event.isCanceled()) {
                if (event.entityPlayer.worldObj.getGameRules().getGameRuleBooleanValue("keepInventory")) {
                    return;
                }
                ArrayList drops = event.drops;
                if (drops != null && drops.size() > 0) {
                    EntityPlayer player = event.entityPlayer;
                    World world = player.worldObj;
                    for (int i = 0; i < drops.size(); ++i) {
                        ItemStack stack = ((EntityItem)drops.get(i)).getEntityItem();
                        if (stack == null) continue;
                        NBTTagCompound nbt = stack.getTagCompound();
                        if (nbt == null) {
                            nbt = new NBTTagCompound();
                            stack.setTagCompound(nbt);
                        }
                        if (Config.instance().traceRites()) {
                            Log.instance().debug(String.format("Tagging stack %s for player %s", stack.toString(), player.getCommandSenderName()));
                        }
                        nbt.setString(RitePriorIncarnation.PRIOR_USR_KEY, player.getCommandSenderName());
                    }
                    NBTTagCompound nbt = Infusion.getNBT((Entity)player);
                    if (nbt.hasKey(RitePriorIncarnation.PRIOR_INV_KEY)) {
                        nbt.removeTag(RitePriorIncarnation.PRIOR_INV_KEY);
                    }
                    nbt.setDouble("WITCPriIncLocX", player.posX);
                    nbt.setDouble("WITCPriIncLocY", player.posY);
                    nbt.setDouble("WITCPriIncLocZ", player.posZ);
                }
            }
        }
    }
}

