/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.ritual.rites.RiteExpandingEffect;
import com.emoniph.witchery.util.Dye;
import com.emoniph.witchery.util.Log;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class RiteFertility
extends RiteExpandingEffect {
    public RiteFertility(int radius, int height) {
        super(radius, height, false);
    }

    @Override
    public void doBlockAction(World world, int posX, int posY, int posZ, int currentRadius, EntityPlayer player, boolean enhanced) {
        Block blockID = world.getBlock(posX, posY, posZ);
        if ((blockID != Blocks.dirt || blockID != Blocks.grass || blockID != Blocks.mycelium || blockID != Blocks.farmland || world.rand.nextInt(5) == 0) && player != null) {
            ItemDye.applyBonemeal((ItemStack)Dye.BONE_MEAL.createStack(), (World)world, (int)posX, (int)posY, (int)posZ, (EntityPlayer)player);
        }
    }

    @Override
    public boolean doRadiusAction(World world, int posX, int posY, int posZ, int radius, EntityPlayer player, boolean enhanced) {
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (Object obj : world.playerEntities) {
            EntityPlayer entityPlayer = (EntityPlayer)obj;
            double distanceSq = entityPlayer.getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ);
            if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
            if (entityPlayer.isPotionActive(Potion.confusion)) {
                entityPlayer.removePotionEffect(Potion.confusion.id);
            }
            if (entityPlayer.isPotionActive(Potion.blindness)) {
                entityPlayer.removePotionEffect(Potion.blindness.id);
            }
            if (entityPlayer.isPotionActive(Potion.poison)) {
                entityPlayer.removePotionEffect(Potion.poison.id);
            }
            if (!enhanced) continue;
            entityPlayer.addPotionEffect(new PotionEffect(Potion.regeneration.id, 300, 1));
            entityPlayer.addPotionEffect(new PotionEffect(Potion.field_76443_y.id, 2400));
        }
        ArrayList<EntityZombie> villagersToZombify = new ArrayList<EntityZombie>();
        for (Object e : world.loadedEntityList) {
            double distanceSq;
            EntityZombie victim;
            if (!(e instanceof EntityZombie) || !(victim = (EntityZombie)e).isVillager() || !((distanceSq = victim.getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ)) > minSq) || !(distanceSq <= radiusSq)) continue;
            Log.instance().debug(String.format("Try curing zombie %f %f %f", distanceSq, minSq, radiusSq));
            villagersToZombify.add(victim);
        }
        for (EntityZombie entityZombie : villagersToZombify) {
            EntityVillager entityvillager = new EntityVillager(world);
            entityvillager.copyLocationAndAnglesFrom((Entity)entityZombie);
            entityvillager.onSpawnWithEgg((IEntityLivingData)null);
            entityvillager.setLookingForHome();
            if (entityZombie.isChild()) {
                entityvillager.setGrowingAge(-24000);
            }
            world.removeEntity((Entity)entityZombie);
            world.spawnEntityInWorld((Entity)entityvillager);
            entityvillager.addPotionEffect(new PotionEffect(Potion.confusion.id, 200, 0));
            world.playAuxSFXAtEntity((EntityPlayer)null, 1017, (int)entityvillager.posX, (int)entityvillager.posY, (int)entityvillager.posZ, 0);
        }
        return true;
    }
}

